var contentsDictionary = {};

contentsDictionary["id_gs01_0032"] = new ContentsDictionaryEntry("Troubleshooting Guide", "\n \n Troubleshooting Guide\n Network Camera\n \n Model No. BB-HCM527\n \n BB-HCM547\n \n \n");

contentsDictionary["id_gs01_0033"] = new ContentsDictionaryEntry("Introduction", "Introduction\n About this document\n • This document is written for both the BB-HCM527 (Indoor Use Only) and the BB-HCM547 (Outdoor Ready). Available features and operations vary slightly depending on the model. You can confirm the model no. of your camera by checking the model no. printed on the front of the camera. Features and operations that apply to the BB-HCM547 only are marked as “BB-HCM547 only” in this document.\n \n • Model number suffixes (“A” and “CE”) are omitted from the following model numbers shown in this document, unless necessary.\n BB-HCM527A, BB-HCM527CE, BB-HCM547A, BB-HCM547CE\n \n \n \n Trademarks\n • Microsoft, Windows, Windows Vista, Hotmail, ActiveX, Internet Explorer, and Windows Media are either registered trademarks or trademarks of Microsoft Corporation in the United States and/or other countries.\n \n • Screen shots reprinted with permission from Microsoft Corporation.\n \n • All other trademarks identified herein are the property of their respective owners.\n \n • This software is based in part on the work of the Independent JPEG Group.\n \n \n \n Abbreviations\n • UPnP is the abbreviation for “Universal Plug and Play”.\n \n • The Network Camera is referred to as “the camera” in this document.\n \n • The Setup CD-ROM is referred to as “the CD-ROM” in this document.\n \n • The term “SD memory card” is used in this document to refer to SD memory cards and SDHC memory cards.\n \n \n \n");

contentsDictionary["id_gs01_0022"] = new ContentsDictionaryEntry("Section 1 Troubleshooting", "Section 1 Troubleshooting \n The Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/) includes various technical information not included in this document. Refer to the website if you need additional assistance.\n");

contentsDictionary["id_gs01_0038"] = new ContentsDictionaryEntry("1.1 Understanding the Camera Indicator", "1.1 Understanding the Camera Indicator \n The camera’s indicator lights as follows according to the status of the camera. Understanding how and when the indicator lights can help you troubleshoot problems with the camera.\n Camera Status or Operation\n Indicator Color and Pattern\n Normal Operation\n Green\n When power is turned on (camera is starting up)\n Orange→Flashing orange\n Obtaining IP address via DHCP\n Flashing green\n LAN cable not connected or no LAN connection\n Orange\n Automatic Setup\n In progress\n Flashing green\n Completed\n Green\n Updating firmware\n Flashing orange\n Factory reset (by software or by pressing the FACTORY DEFAULT RESET button)\n Flashing orange→Off→(The camera restarts)\n UPnP™ port forwarding error\n Flashing orange (2-second intervals)\n SD memory card is damaged, write-protected, or not formatted properly\n Red\n Camera failure\n Flashing red\n \n");

contentsDictionary["id_gs01_0023"] = new ContentsDictionaryEntry("1.2 Camera Indicator Issues", "1.2 Camera Indicator Issues \n Problem\n Cause and Remedy\n The indicator lights or flashes orange.\n • The LAN cable is not connected.\n → Make sure the LAN cable is connected properly.\n \n \n \n \n • Your hub or router is not working.\n → Confirm that the hub and router are turned on and working properly.\n \n \n \n \n The indicator continues flashing orange.\n • The camera’s firmware is being updated.\n → If you access the camera from a web browser, the [Update Firmware] page will be displayed. Update the firmware (see 9.5 Updating the Camera’s Firmware in the Operating Instructions). If you fail to update the firmware, see 1.10 Miscellaneous Issues.\n \n \n \n \n The indicator continues flashing orange (2-second interval).\n • The router on your network is turned off.\n → Turn the router on, and wait for the indicator to turn green.\n \n \n \n \n • An error occurred while setting up port forwarding by UPnP™.\n → Refer to the Setup Guide and set up the camera again by selecting [Automatic Setup] in the Setup Program.\n \n \n \n \n The indicator continues flashing green.\n • The camera did not receive an IP address from the DHCP server or from the router’s DHCP feature.\n → When setting [Automatic Setup] or [DHCP], the camera may not receive an IP address due to network failures. For more information, consult your ISP or network administrator.\n \n \n \n \n The indicator does not light.\n • The indicator is disabled.\n → Confirm the [Indicator Control] setting (see 7.6 Changing the Indicator Display in the Operating Instructions).\n \n \n \n \n • The camera may be malfunctioning.\n → If you cannot access the camera, the camera may be malfunctioning. Contact an authorized service center.\n \n \n \n \n When using an AC adaptor\n • The camera may not be receiving power.\n → Confirm that the AC adaptor is connected to the power outlet and that the correct AC adaptor is being used. See Preparation in the Installation Guide.\n \n \n \n \n When using PoE\n • The camera may not be receiving power.\n → Confirm that the camera is connected to the PoE hub and that the PoE hub is turned on.\n \n → Confirm that the camera is connected to the PoE hub using a cat-5 straight cable. Some hubs and routers do not support cross cables.\n \n → Refer to the operating instructions included with the PoE hub if the trouble persists.\n \n \n \n \n • Too many clients are connected to the PoE hub.\n → Some PoE hubs have a wattage limit. Refer to the operating instructions included with the PoE hub and confirm that the hub’s wattage limit is not being exceeded.\n \n \n \n \n • The PoE hub may be malfunctioning.\n → Confirm that other PoE devices can receive power from the PoE hub.\n \n \n \n \n • There is another device connected between the camera and PoE hub.\n → Connect the camera directly to the PoE hub.\n \n \n \n \n • The LAN cable connecting the camera and the PoE hub is not a standard PoE cable.\n → Use a 4-pair UTP/STP cat-5 cable.\n \n \n \n \n The indicator continues flashing red.\n • The camera may be malfunctioning.\n → Contact an authorized service center.\n \n \n \n \n The indicator lights red.\n • The SD memory card is write-protected.\n → Slide the switch on the SD memory card to the correct position.\n \n \n \n \n • The SD memory card is not formatted properly.\n → Format the SD memory card. You can format the card using the camera (see 8.2 Formatting an SD Memory Card in the Operating Instructions), or by using the SD Memory Card Formatting Software. See the Panasonic Network Camera support site (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) for more information.\n \n \n \n \n • The SD memory card is damaged.\n → Replace the SD memory card.\n \n \n \n \n \n");

contentsDictionary["id_gs01_0024"] = new ContentsDictionaryEntry("1.3 Camera Setup Issues", "1.3 Camera Setup Issues \n Problem\n Cause and Remedy\n The Setup Program will not set up the camera.\n • More than 20 minutes have passed since the camera was turned on.\n → Turn the camera off, then turn it on again. Refer to the Setup Guide and set up the camera.\n \n \n \n \n • A network error may have occurred during setup.\n → Confirm that your network is working. Make sure that all the LAN cables are connected properly and that your router is turned on and functioning properly.\n \n \n \n \n • IP addresses of two or more cameras are overlapping.\n → If you are installing more than one camera, turn on one camera and set up that camera before turning on the next camera.\n \n \n \n \n Viewnetcam.com registration fails.\n • Your PC is not connecting to the Internet through the router.\n → Refer to the operating instructions included with your router and make sure the PC is connected to the router and can access the Internet. Try registering with Viewnetcam.com service again.\n \n \n \n \n • If you do not receive an E-mail from the Viewnetcam.com service, the E-mail address you entered during registration may be incorrect.\n → Register your correct E-mail address again at the Viewnetcam.com website at http://www.viewnetcam.com.\n \n \n \n \n The Setup Program does not list any cameras.\n • Firewall or antivirus software on your PC is blocking the connection.\n → To avoid any possible problems, temporarily disable any firewall or antivirus software and set up the camera again. If you cannot disable your firewall or antivirus software, search for the desired camera by entering its MAC address (see Finding cameras on the LAN in the Operating Instructions).\n \n \n \n \n • The camera is connected to a different network or router than the PC.\n → Set up the camera from a PC connected to the same network or router as the camera.\n \n \n \n \n UPnP™ port forwarding setup fails.\n • Your router does not support UPnP™.\n → Refer to the operating instructions included with your router. If your router does not support UPnP™, you cannot set up port forwarding automatically, and must set it up manually in order to access the camera from the Internet.\n \n \n \n \n • Your router’s UPnP™ feature is disabled.\n → Refer to the operating instructions included with your router and enable UPnP™.\n \n \n \n \n • The camera was turned on before the router was turned on.\n → Turn the router on first, and then turn the camera on.\n \n \n \n \n • The camera’s [Default Gateway] setting is not set or is incorrect.\n → Confirm the [Default Gateway] setting (see 5.1.1 Network (IPv4) Settings in the Operating Instructions).\n \n \n \n \n The camera’s IP address and port number have been forgotten.\n • Use the Setup Program to display a list of all cameras and their IP addresses on the network (see Finding cameras on the LAN in the Operating Instructions).\n \n \n The administrator password has been forgotten.\n • Press the FACTORY DEFAULT RESET button to reset the camera. All settings will be erased and reset to their default values. Refer to the Setup Guide and set up the camera again.\n \n \n An error is displayed in the camera status field in the Setup Program.\n • There was an error.\n → Turn the camera off, then turn it on again.\n \n \n \n \n \n");

contentsDictionary["id_gs01_0025"] = new ContentsDictionaryEntry("1.4 Camera Access Issues", "1.4 Camera Access Issues \n Problem\n Cause and Remedy\n The camera cannot be accessed.\n • The camera’s IP address has changed.\n → Use the Setup Program to confirm the camera’s new IP address (see Finding cameras on the LAN in the Operating Instructions).\n \n \n \n \n • An inappropriate IP address was assigned to the camera using the [Static] setting.\n → Assign an IP address that belongs to the same class as other network devices (router, PCs, etc.) on the local area network. For example, if your router’s address is 192.168.0.1, you can assign an IP address between 192.168.0.2 and 192.168.0.254 as long as the assigned address is not used by another network device. See 5.1.1 Network (IPv4) Settings in the Operating Instructions and set an appropriate IP address, or select [Automatic Setup] or [DHCP] as the connection mode. \n \n \n \n \n • You are trying to access the camera from a PC connected to the same network as the camera, and are using the global IP address or the URL assigned to you by your Dynamic DNS service.\n → When accessing the camera from a PC connected to the same network as the camera, use the camera’s local IP address (e.g., 192.168.0.xxx). You can use the Setup Program to confirm the camera’s local IP address (see Finding cameras on the LAN in the Operating Instructions).\n \n \n \n \n • You changed the domain name assigned to your Viewnetcam.com account.\n → Confirm the domain name assigned to your Viewnetcam.com account, then restart the camera. The information saved in the camera is updated to match the domain name assigned to Viewnetcam.com.\n \n \n \n \n • The address you are using to enter the camera does not match the camera’s [HTTPS] setting.\n → If the camera’s [HTTPS] setting is set to [Use HTTPS], enter “https://” followed by the IP address or host name and the port number of the camera. If set to [Use HTTP], enter “http://” followed by the IP address or host name of the camera.\n \n \n \n \n • You did not enter the correct URL.\n → Confirm the domain name assigned to your Viewnetcam.com account, then access the camera using that address.\n \n \n \n \n • The [HTTPS] setting on the [Multi-Camera] page does not match the camera’s [HTTPS] setting.\n → Confirm that the camera’s [HTTPS] setting on the [Multi-Camera] page (see 7.2 Registering Multiple Cameras in the Operating Instructions) matches the camera’s [HTTPS] setting.\n \n \n \n \n • You entered the camera’s IPv6 address in Internet Explorer® 6.\n → Internet Explorer 6 does not support IPv6 addresses. Use the camera’s IPv4 address (e.g., 192.168.0.xxx) when accessing from home, and use a Dynamic DNS service, such as Viewnetcam.com, to access the computer over the Internet, or upgrade to Internet Explorer 7 (see 11.4 Accessing the Camera in IPv6 Mode in the Operating Instructions for information on accessing the camera in IPv6 mode).\n \n \n \n \n • The network is congested.\n → Camera access may be affected by network traffic. Wait for a while and try again.\n \n \n \n \n • Your web browser is accessing a proxy server.\n → Set your web browser to bypass the proxy server when accessing the camera from a PC on the same LAN (see 12.1 Proxy Server Settings in the Operating Instructions).\n \n \n \n \n • The connection type is wrong.\n → If the network connection type is not set to [Auto Negotiation] (see 5.1.1 Network (IPv4) Settings in the Operating Instructions), set up the camera and the router by referring to the connection table (see 1.11 Connection Type Table).\n \n \n \n \n • The [Default Gateway] or DNS server address settings may be wrong.\n → Consult your ISP or network administrator, and assign the correct settings (see 5.1.1 Network (IPv4) Settings in the Operating Instructions).\n \n \n \n \n • The camera is malfunctioning.\n → Contact an authorized service center.\n \n \n \n \n “Failed to access” is displayed.\n • You changed the domain name assigned to your Viewnetcam.com account.\n → Confirm the domain name assigned to your Viewnetcam.com account, then restart the camera. The information saved in the camera is updated to match the domain name assigned to Viewnetcam.com.\n \n \n \n \n The camera can be accessed over the LAN, but not from the Internet.\n • The camera has not been configured properly to be accessed from the Internet.\n → Refer to Section 4 Configuring the Camera for Access from the Internet in the Operating Instructions. Make sure that port forwarding has been configured properly (see 4.1 Configuring Port Forwarding in the Operating Instructions) and that you have registered with a Dynamic DNS service and configured the camera to use that Dynamic DNS service (see 4.2 Configuring the Camera to Use a Dynamic DNS Service in the Operating Instructions).\n \n \n \n \n • The [Default Gateway] setting may be wrong.\n → Consult your ISP or network administrator, and assign the correct settings (see 5.1.1 Network (IPv4) Settings in the Operating Instructions).\n \n \n \n \n • Your router does not support UPnP™.\n → Refer to the operating instructions included with your router. If your router does not support UPnP™, you must configure the router’s port forwarding feature manually (see Configuring port forwarding without using UPnP™ in the Operating Instructions).\n \n \n \n \n • Your router’s UPnP™ feature is disabled.\n → Refer to the operating instructions included with your router and enable UPnP™.\n \n \n \n \n • Your router’s port forwarding feature has not been properly configured.\n → Refer to Configuring port forwarding without using UPnP™ in the Operating Instructions and the operating instructions included with your router, and confirm that the router’s port forwarding feature is configured correctly.\n \n \n \n \n • The router’s firewall feature (packet filtering, etc.) is blocking camera access.\n → Set the router to allow access to the camera. Refer to the operating instructions included with your router.\n \n \n \n \n • You are using the camera’s local IP address when trying to access the camera from the Internet.\n → Use the global IP address assigned to you by your ISP and the port number of the camera when accessing from the Internet, or use the URL provided by the Dynamic DNS service provider, such as Viewnetcam.com. See Section 4 Configuring the Camera for Access from the Internet in the Operating Instructions for more information.\n \n \n \n \n • The camera’s global IP address has changed.\n → Confirm the current global IP address on the [Status] page (see 9.1 Confirming Camera Status in the Operating Instructions).\n \n \n \n \n • The port number assigned to the camera is restricted by your ISP.\n → Some ISPs do not allow access from the Internet using certain port numbers, such as port 80, which is the camera’s default port number. Ask your ISP or network administrator about which port numbers are available for access over the Internet, and change the camera’s port number if necessary.\n \n \n \n \n The camera’s global IP address has been forgotten.\n • Confirm the current global IP address on the [Status] page (see 9.1 Confirming Camera Status in the Operating Instructions).\n \n \n Authentication dialogs are displayed frequently.\n • The user name and password for the administrator or for general users have been changed.\n → Close your web browser, then start the web browser again and access the camera.\n \n \n \n \n The camera can be accessed over the LAN, but not from a mobile phone.\n • You did not enter the complete address.\n → Enter /mobile at the end of the address.\nExample: http://***.***.***.***:50001/mobile \n \n \n \n \n • Your mobile phone supports only XHTML.\n → Enter /mobilex at the end of the address.\nExample: http://***.***.***.***:50001/mobilex \n \n \n \n \n • You changed the resolution to 320 × 240.\n → Some mobile phones do not support 320 × 240 resolution images.\n \n \n \n \n • The file size of the image is exceeding the capacity of the mobile phone.\n → View the image at 192 × 144 resolution.\n \n \n \n \n • The address you are using to enter the camera does not match the camera’s [HTTPS] setting.\n → If the camera’s [HTTPS] setting is set to [Use HTTPS], enter “https://” followed by the IP address or host name and the port number of the camera. If set to [Use HTTP], enter “http://” followed by the IP address or host name of the camera.\n \n \n \n \n • The camera is configured to use HTTPS, but your mobile phone does not support HTTPS connections.\n → If desired, configure the camera to use HTTP (see 5.2 HTTPS Settings in the Operating Instructions).\n \n \n \n \n When accessing the camera, the [Update Firmware] page is displayed.\n • The power to the camera was turned off during a firmware update.\n → Download the latest firmware from the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) and update the firmware (see 9.5 Updating the Camera’s Firmware in the Operating Instructions).\n \n \n \n \n \n");

contentsDictionary["id_gs01_0043"] = new ContentsDictionaryEntry("1.5 Camera Image Display Issues", "1.5 Camera Image Display Issues \n Problem\n Cause and Remedy\n Only half of the image is displayed.\n • Your web browser is out of date.\n → Upgrade to Internet Explorer 6.0 or later.\n \n \n \n \n The camera image is not displayed.\n • The appropriate viewer programs (ActiveX® Controls) are not installed.\n → Viewer programs must be installed in order to display video. See the information regarding security dialogs and ActiveX Controls in 1.2 Viewing Live Camera Images in the Operating Instructions.\n \n \n \n \n • The network is congested.\n → Camera access may be affected by network traffic. Wait for a while and try again.\n \n \n \n \n • Your web browser is accessing a proxy server.\n → Set your web browser to bypass the proxy server when accessing the camera from a PC on the same LAN (see 12.1 Proxy Server Settings in the Operating Instructions).\n \n \n \n \n A gray screen is displayed.\n • Too many users are viewing camera images.\n → The maximum number of users that can view live and buffered camera images is limited, as described in 1.4 Maximum Number of Viewing Sessions in the Operating Instructions. Additional users will see a gray screen, and [The maximum number of accesses has been exceeded.] will be displayed. Click your web browser’s refresh button periodically until you are allowed to view video images, or use the [Refresh Rate] selector to select to view still images.\n \n \n \n \n • The camera is not available on this day or at this time according to the [Operation Time] setting.\n → A gray screen is displayed when the camera is outside the operation time. This is normal.\n \n \n \n \n Video changes to still images.\n • The length of time that video can be displayed has been limited for general users or guest users.\n → You can change the amount of time that video can be displayed before switching to still images (see Creating or modifying a general user account or Changing the features available to guest users in the Operating Instructions).\n \n \n \n \n The image is out of focus.\n • The lens cover has dust, dirt, fingerprints, or moisture on it.\n → Clean the lens cover with a dry cloth (see 14.1 Cleaning the Camera in the Operating Instructions).\n \n \n \n \n • The object is too close to the camera.\n → Adjust the zoom using the 4.6× zoom feature. If the object is still out of focus, locate the object at least 0.75 m (2 feet 6 inches) away from the camera.\n \n \n \n \n The color of the image is strange.\n • The [White Balance] setting is not appropriate for the image being viewed.\n → Adjust the [White Balance] setting in the operation bar (see 1.2.1 Using the Operation Bar in the Operating Instructions).\n \n \n \n \n • Your PC’s color display setting is lower than 16-bit.\n → Set the PC to display colors at 16-bit quality or higher.\n \n \n \n \n The image has flicker noise in it.\n • The object is dark.\n → Make the area around the camera brighter.\n \n → Change the object or adjust the [Brightness] setting in the operation bar (see 1.2.1 Using the Operation Bar in the Operating Instructions).\n \n \n \n \n • The [AC Power Source Frequency] setting is incorrect.\n → Change the setting to match the frequency of your power source (see 5.5 Changing Basic Camera Settings in the Operating Instructions).\n \n \n \n \n • The shutter speed is too fast.\n → When the shutter speed is faster, flicker noise may be seen depending on the light source. This is not a malfunction. Reduce the shutter speed if necessary (see 5.5 Changing Basic Camera Settings in the Operating Instructions).\n \n \n \n \n An old image is displayed.\n • Your web browser’s temporary files setting is causing old images to be displayed. \n → Change your web browser’s temporary files setting (see 12.3 Changing the [Temporary Internet files] Setting in the Operating Instructions).\n \n \n \n \n The image refreshes very slowly.\n • In general, the image refresh rate may vary depending on network conditions, PC performance, the number of people accessing the camera, and the type of object being viewed.\n \n \n • Many users are accessing the camera.\n → If many users are accessing the camera simultaneously, the image refresh rate decreases.\n \n \n \n \n • You are not using an Ethernet switching hub.\n → If you view multiple cameras on the [Multi] page, image refresh rate may improve by connecting the cameras to an Ethernet switching hub.\n \n \n \n \n • The amount of bandwidth that the camera is allowed to use is set too low.\n → Adjust the [Max. Bandwidth Usage] setting (see 5.1.1 Network (IPv4) Settings or 11.3 Configuring Your Camera for IPv6 in the Operating Instructions).\n \n \n \n \n • The camera is in color night view mode.\n → The image refresh rate decreases when color night view mode is activated. Make the area around the camera brighter.\n \n \n \n \n • When viewing multiple cameras on the [Multi] page, too much data is being sent over the network.\n → If you do not have enough bandwidth, the refresh rate may decrease. Reduce the image resolution or the number of cameras being displayed. As a general guideline, about 3 to 4 Mbps of bandwidth are required to display 4 camera images on the [Multi] page.\n \n \n \n \n • The image has not been refreshed.\n → Click your web browser’s refresh button.\n \n \n \n \n • [Analog Video Output] is set to [Enable].\n → When [Analog Video Output] is set to [Enable], frame rate will decrease. Set [Analog Video Output] to [Disable] (see 7.5 Controlling the Analog Video Output Signal in the Operating Instructions). \n \n \n \n \n • You are accessing the camera using HTTPS.\n → When accessing the camera using HTTPS, frame rate decreases and camera response time increases. This is normal. If desired, configure the camera to use HTTP (see 5.2 HTTPS Settings in the Operating Instructions).\n \n \n \n \n MPEG-4 images are not displayed and an “X” is displayed in the image area.\n • The viewer program (ActiveX Controls) required for displaying MPEG-4 images is not installed.\n → Select [MPEG-4] as the refresh rate on the single camera page, and install the viewer program following the on-screen instructions. If you cannot install the program, download the program from the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html).\n \n \n \n \n • Your browser’s pop-up blocker prevented the MPEG-4 viewer program (ActiveX Controls) from being installed.\n → Disable your browser’s pop-up blocker and try to view MPEG-4 images again (see 1.2 Viewing Live Camera Images in the Operating Instructions).\n \n \n \n \n MPEG-4 images are not displayed.\n • The streaming method is set to [Unicast].\n → Unicast streaming is not possible when viewing camera images over the Internet, and may not be possible when viewing camera images on certain local networks. Set the streaming method to [HTTP].\n \n \n \n \n • The streaming method is set to [Multicast].\n → Multicast streaming is not possible when viewing camera images over the Internet, and may not be possible when viewing camera images on certain local networks. Select [Auto], [Unicast] or [HTTP] as the streaming method.\n \n → Consult your Internet Service Provider (ISP) or network administrator regarding multicasting.\n \n \n \n \n • Your web browser is accessing a proxy server.\n → Certain proxy servers do not allow MPEG-4 streaming. Set the refresh rate to [MJPEG].\n \n \n \n \n MPEG-4 images break up or are not displayed properly.\n • The maximum setting for [MPEG-4 Bit Rate] exceeds the bandwidth of the network connection.\n → Reduce the maximum setting for [MPEG-4 Bit Rate] (see 5.7 Changing Video Streaming Settings in the Operating Instructions) and try again.\n \n \n \n \n • The streaming method is set to [Unicast].\n → Data packets are being lost. Select [HTTP] as the streaming method.\n \n \n \n \n • The PC’s specifications do not meet the requirements, or the PC’s video card is weak.\n → Refer to the Important Information and use a PC that meets the specifications noted.\n \n → User a higher-performance video card.\n \n \n \n \n MPEG-4 videos appear choppy.\n • The maximum setting for [MPEG-4 Bit Rate] is too high.\n → Reduce the maximum setting for [MPEG-4 Bit Rate] (see 5.7 Changing Video Streaming Settings in the Operating Instructions).\n \n \n \n \n Image quality is poor when viewing MPEG-4 images.\n • The network’s bandwidth is too narrow.\n → Reduce the maximum setting for [MPEG-4 Bit Rate] (see 5.7 Changing Video Streaming Settings in the Operating Instructions) and try again.\n \n → Reduce the setting for [MPEG-4 Max. Frame Rate] (see 5.7 Changing Video Streaming Settings in the Operating Instructions) and try again.\n \n → Access the camera from a network with greater bandwidth.\n \n \n \n \n Frame rate is slow or video is interrupted when viewing MPEG-4 images.\n • A user with a low bandwidth connection is viewing MPEG-4 images.\n → If a user with a low bandwidth connection or if many users are viewing images using unicast streaming, frame rate will decrease and image quality may be affected for all users viewing MPEG-4 images. Increase the minimum setting for [MPEG-4 Bit Rate] (see 5.7 Changing Video Streaming Settings in the Operating Instructions) and try again.\n \n \n \n \n • Many users are viewing MPEG-4 images, or users are viewing MPEG-4 images at different image resolutions.\n → If many users are viewing MPEG-4 images, or if users are viewing MPEG-4 images at different image resolutions, frame rate and image quality may decrease.\n \n \n \n \n • The camera is configured to buffer images in MPEG-4 format.\n → When the camera is configured to buffer images in MPEG-4 format, frame rate will decrease when viewing MPEG-4 images on the single camera and multi camera pages.\n \n \n \n \n The maximum frame rate displayed when viewing MPEG-4 images is low.\n • The PC’s specifications do not meet the requirements, or the PC’s video card is weak.\n → Refer to the Important Information and use a PC that meets the specifications noted.\n \n → Use a higher-performance video card.\n \n \n \n \n \n");

contentsDictionary["id_gs01_0028"] = new ContentsDictionaryEntry("1.6 Operation Bar Issues", "1.6 Operation Bar Issues \n Problem\n Cause and Remedy\n Pan/tilt, zoom (4.6× zoom feature), click to center, preset features, or other features on the single camera page do not work.\n • Your PC is not connected to the camera.\n → Click your web browser’s refresh button. Confirm that the image refreshes, and then try again.\n \n \n \n \n • The camera is not turned on.\n → Confirm that the camera is turned on.\n \n \n \n \n • Many users are operating the camera simultaneously.\n → Wait for a while, then try again.\n \n \n \n \n • The pan or tilt range has reached its end.\n → When [Left End], [Right End], [Up End], or [Down End] is displayed at the top of the operation bar, the lens can not be moved any further in that direction.\n \n \n \n \n • The zoom range has reached its end.\n → When [Tele End] or [Wide End] is displayed at the top of the operation bar, the lens cannot zoom in or out any further.\n \n \n \n \n • The pan or tilt range has been restricted by the administrator.\n → Adjust the pan or tilt range settings (see 1.2.1 Using the Operation Bar in the Operating Instructions).\n \n \n \n \n The desired feature button or selector is not displayed in the operation bar.\n • The desired features have been disabled for the general user or for guest users.\n → Refer to the Operating Instructions and change the feature access level for the general user (see Creating or modifying a general user account) or for guest users (see Changing the features available to guest users) to allow access to the desired features.\n \n \n \n \n \n");

contentsDictionary["id_gs01_0039"] = new ContentsDictionaryEntry("1.7 Audio Issues", "1.7 Audio Issues \n Problem\n Cause and Remedy\n The talk button is gray or is not displayed.\n • The [Output] setting is set to [Disable] on the [Audio] page.\n → Set it to [Enable] (see 5.6 Changing Audio Settings in the Operating Instructions).\n \n \n \n \n • The talk feature is disabled for the general user’s account or for guest users.\n → Refer to the Operating Instructions and change the feature access level for the general user (see Creating or modifying a general user account) or for guest users (see Changing the features available to guest users) to allow access to the desired feature.\n \n \n \n \n • Your web browser is accessing a proxy server.\n → Set your web browser to bypass the proxy server when accessing the camera from a PC on the same LAN (see 12.1 Proxy Server Settings in the Operating Instructions).\n \n \n \n \n • Many users are accessing the camera.\n → If many users are accessing the camera simultaneously, the audio buttons may not be available. Wait for a while and try again.\n \n \n \n \n The listen button is gray or is not displayed.\n • The [Input] setting is set to [Disable] on the [Audio] page.\n → Set it to [Enable] (see 5.6 Changing Audio Settings in the Operating Instructions).\n \n \n \n \n • The listen feature is disabled for the general user’s account or for guest users.\n → Refer to the Operating Instructions and change the feature access level for the general user (see Creating or modifying a general user account) or for guest users (see Changing the features available to guest users) to allow access to the desired feature.\n \n \n \n \n • Many users are accessing the camera.\n → If many users are accessing the camera simultaneously, the audio buttons may not be available. Wait for a while and try again.\n \n \n \n \n Audio cannot be heard through the speaker connected to the camera.\n • The talk button is turned off (\n).\n → Click the talk button again to turn on to talk (\n).\n \n \n \n \n • The PC’s microphone is not selected as the audio input device.\n → Open the PC’s control panel and select the microphone as the audio input device.\n \n \n \n \n • The PC’s microphone is muted.\n → Open the PC’s control panel and unmute the microphone.\n \n \n \n \n • The speaker is not connected to the camera properly.\n → Refer to the Installation Guide and confirm that the speaker is connected properly.\n \n \n \n \n • The speaker is not a powered speaker.\n → The camera’s audio output is line level, therefore the audio output must be amplified. Use a powered speaker or connect an amplifier to the speaker.\n \n \n \n \n • The talk button has changed from \n to \n.\n → The [PC Audio Input Timeout] setting on the [Audio] page is automatically turning the talk feature off. Change the setting if necessary (see 5.6 Changing Audio Settings in the Operating Instructions).\n \n \n \n \n • The speaker is turned off or its volume is set too low.\n → Confirm that the speaker is turned on and that its volume is turned up.\n \n \n \n \n • Audio output is disabled.\n → Confirm that the [Output] setting is set to [Enable] on the [Audio] page.\n \n \n \n \n Audio cannot be heard on the computer.\n • The camera’s listen button is muted (\n).\n → Click the listen button again to turn off the mute (\n).\n \n \n \n \n • The camera’s volume is turned down.\n → Adjust the camera’s volume slider.\n \n \n \n \n • The PC’s volume is turned down or muted.\n → Adjust the PC’s volume.\n \n \n \n \n • The external microphone is not connected to the camera properly.\n → Refer to the Installation Guide and confirm that the external microphone is connected properly.\n \n \n \n \n Noise or feedback is heard.\n • The audio heard from your PC is being picked up by the camera’s microphone and is causing feedback.\n → Mute the audio for a moment, turn the volume down, then unmute the audio.\n \n \n \n \n • The audio plugs of the audio device (microphone, speaker, etc.) are dirty or are not connected firmly.\n → Make sure the audio plugs are clean and connected firmly.\n \n \n \n \n The audio is interrupted.\n • Too many applications are being run on the PC.\n → Close any unnecessary applications on your PC.\n \n \n \n \n • The amount of bandwidth that the camera is allowed to use is set too high.\n → Adjust the [Max. Bandwidth Usage] setting (see 5.1.1 Network (IPv4) Settings or 11.3 Configuring Your Camera for IPv6 in the Operating Instructions).\n \n \n \n \n • The [Mute during Pan/Tilt/Zoom] setting is set to [Enable] on the [Audio] page.\n → If set to [Enable], the camera audio is automatically muted whenever the camera is panning, tilting, or zooming. As a result, the audio may sound interrupted.\n \n \n \n \n • The sound being picked up by the microphone is too quiet.\n → Set the microphone sensitivity to [Maximum] (see 5.6 Changing Audio Settings in the Operating Instructions).\n \n \n \n \n \n");

contentsDictionary["id_gs01_0029"] = new ContentsDictionaryEntry("1.8 Image Buffer/Transfer Issues", "1.8 Image Buffer/Transfer Issues \n Problem\n Cause and Remedy\n The camera does not transfer buffered images.\n • Errors have occurred on the way to the E-mail, FTP, or HTTP server.\n → Refer to the [Protocol] column on the [Status] page (see 9.1 Confirming Camera Status in the Operating Instructions), and check if errors are displayed.\n \n \n \n \n • The [Default Gateway] or DNS server address settings may be wrong.\n → Consult your ISP or network administrator, and assign the correct settings (see 5.1.1 Network (IPv4) Settings in the Operating Instructions).\n \n \n \n \n • The login ID or password entered for E-mail, FTP, or HTTP transferring is incorrect.\n → Confirm that the correct settings are entered.\n \n \n \n \n • When transferring images by HTTP, the camera does not support the response received from the HTTP server, such as “100 Continue”, “302 Moved”, etc.\n → Consult the HTTP server administrator. The camera supports only “2xx” responses, such as “201 Created”.\n \n \n \n \n Buffered images are not received by mobile phone E-mail.\n • The image resolution of the transferred file is too large.\n → Set the resolution to 192 × 144 and the image quality to [Favor Motion]. Some mobile phones do not support 320 × 240 resolution.\n \n \n \n \n Images are buffered or transferred at a slow rate. The camera transfers old images.\n • The camera is configured to buffer or transfer images too quickly (i.e., too many images in a short time).\n → When configuring the trigger, set the [Image Buffer Frequency] to buffer or transfer images at a slower rate (see 2.1 Configuring a Timer Trigger or 2.2 Configuring an Alarm or Motion Detection Trigger in the Operating Instructions).\n \n \n \n \n Buffered MPEG-4 images are not displayed and an “X” is displayed.\n • Windows Media® Player is not installed.\n → Install Windows Media Player.\n \n \n \n \n • Windows Media Player is not properly configured.\n → Start Windows Media Player and configure the initial settings.\n \n \n \n \n • The Windows software used by Windows Media Player are out-of-date.\n → Use [Windows Update] to update the software. \n \n \n \n \n • The G.726 audio codec is not installed.\n → Click the link displayed below the MPEG-4 buffered image area (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html). Follow the on-screen instructions and install the codec.\n \n \n \n \n The audio is interrupted.\n • Multiple triggers are configured to buffer MPEG-4 videos.\n → This is normal. If multiple triggers are configured to buffer MPEG-4 videos, audio may be interrupted as a result.\n \n \n \n \n \n");

contentsDictionary["id_gs01_0044"] = new ContentsDictionaryEntry("1.9 SD Memory Card Issues", "1.9 SD Memory Card Issues \n Problem\n Cause and Remedy\n Images are not being buffered to the SD memory card.\n • The SD memory card is write-protected.\n → Slide the switch on the SD memory card to the correct position.\n \n \n \n \n • The SD memory card may have been removed without pressing the FUNCTION button.\n → If the FUNCTION button is not pressed before the SD memory card is removed, the card may be damaged. Format the card using the camera (see 8.2 Formatting an SD Memory Card in the Operating Instructions).\n \n \n \n \n • The SD memory card is not formatted properly.\n → Format the SD memory card. You can format the card using the camera (see 8.2 Formatting an SD Memory Card in the Operating Instructions), or by using the SD Memory Card Formatting Software. See the Panasonic Network Camera support site (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) for more information.\n \n \n \n \n Images are buffered to the SD memory card at a slow rate.\n • This may occur if the SD memory card was formatted using a PC.\n → Format the SD memory card. You can format the card using the camera (see 8.2 Formatting an SD Memory Card in the Operating Instructions), or by using the SD Memory Card Formatting Software. See the Panasonic Network Camera support site (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) for more information.\n \n \n \n \n \n");

contentsDictionary["id_gs01_0030"] = new ContentsDictionaryEntry("1.10 Miscellaneous Issues", "1.10 Miscellaneous Issues \n Problem\n Cause and Remedy\n ActiveX Controls cannot be installed.\n • Security software installed on the PC is blocking the installation of ActiveX Controls.\n → Close the security software, then try again.\n \n \n \n \n The camera’s firmware cannot be updated.\n • There was a problem while updating the firmware. (The power was turned off, there was a network failure, etc.)\n → Update the firmware again by following the procedure below.\n 1. Turn the camera off, then turn it on again.\n \n 2. Try to access the camera again. You may need to use the Setup Program on the included CD-ROM to find the camera in case its IP address has changed. (See Finding cameras on the LAN in the Operating Instructions.)\n \n 3. If the top page is displayed, confirm the firmware version number on the top page. If the version number displayed is the latest version, the firmware was updated properly. If the version number displayed is not the latest version, repeat the procedure for updating the firmware. (See 9.5 Updating the Camera’s Firmware in the Operating Instructions.)\n \n \n \n \n \n • An error “The firmware file is illegal.” is displayed.\n → The wrong firmware is used. Download an appropriate firmware from the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) and update the firmware again (see 9.5 Updating the Camera’s Firmware in the Operating Instructions).\n \n \n \n • BB-HCM527 only: “The page cannot be displayed.” is displayed.\n → The firmware for BB-HCM527 may not be used. Access the camera using HTTP and download an appropriate firmware from the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html). Then update the firmware again (see 9.5 Updating the Camera’s Firmware in the Operating Instructions).\n \n \n \n \n A shortcut to the camera is not displayed in the [My Network Places] folder.\n • The UPnP™ component of Windows® XP is not installed.\n → See 12.2 Creating a Shortcut to the Camera in the Operating Instructions.\n \n \n \n \n \n");

contentsDictionary["id_gs01_0037"] = new ContentsDictionaryEntry("1.11 Connection Type Table", "1.11 Connection Type Table \n \n \n Auto Negotiation\n 100 Mbps\n 10 Mbps\n Full Duplex\n Half Duplex\n Full Duplex\n Half Duplex\n Auto Negotiation\n ü \n –\n ü \n –\n ü \n 100Base-TX\n Full Duplex\n –\n ü \n –\n –\n –\n Half Duplex\n ü \n –\n ü \n –\n –\n 10Base-T\n Full Duplex\n –\n –\n –\n ü \n –\n Half Duplex\n ü \n –\n –\n –\n ü \n \n");

contentsDictionary["id_om01_0203"] = new ContentsDictionaryEntry("Operating Instructions", "\n \n Operating Instructions\n Network Camera\n \n Model No. BB-HCM527\n \n BB-HCM547\n \n \n Please read this document before using the product, and save this document for future reference.\n Panasonic Network Camera Website: http://panasonic.co.jp/pcc/products/en/netwkcam/regionlinks/index.html \n \n \n \n");

contentsDictionary["id_om01_0118"] = new ContentsDictionaryEntry("Main Features", "Main Features\n Splash-resistant body (BB-HCM547 only)\n The BB-HCM547 features an IPX4-compliant*1 splash-resistant body that allows the camera to be used both indoors and outdoors. (See the Installation Guide and Mounting Guide for proper outdoor installation instructions.)\n \n Zoom features\n The camera features an optical zoom that allows you to magnify images by up to 2.3× and a digital zoom that allows you to further magnify images by up to 2×, for a total zoom range of 4.6×.\n \n On-site and remote camera monitoring\n Camera images can be monitored from a PC, both on-site and over the Internet. You can even use your mobile phone to view still images when you’re out of the house.\n \n MPEG-4 and Motion JPEG (MJPEG) support\n Live camera images can be viewed and buffered (i.e., stored in memory) in both MPEG-4 and JPEG (MJPEG) formats, allowing you to select the video format that best suits your needs.\n \n Backlight Correction feature\n When this feature is enabled, the camera can automatically correct the brightness of the camera image. This means even when there is backlight in the image, the camera can correct the image to provide a more consistent, natural image.\n \n Audio features\n The camera features a built-in microphone that allows you to monitor the audio while viewing live camera images using your PC. You can connect a user-supplied microphone if desired. Additionally, by connecting a user-supplied external powered speaker, you can talk to someone while seeing their image on your PC.\n \n Motion detection feature\n The camera’s motion detection feature allows you to buffer or transfer camera images when the camera detects motion in the camera image.\n \n Camera image buffering and playback\n Camera images can be automatically buffered at specific times, when the camera’s external sensors (customer-provided) are triggered, or when the camera detects motion. You can program the camera to buffer these camera images, and then you can play back these images later while accessing the camera or save them to your PC. You can also program the camera to transfer images by E-mail or upload them to an FTP or HTTP server as they are being buffered.\n \n PoE (Power over Ethernet) ready\n The camera is compliant with PoE (IEEE 802.3af) standards, and contains a power receiving device that enables it to receive power from the same Ethernet cable used for network connection. This allows you to mount the camera in locations where there is no power outlet nearby, saving you the cost of installing a new power outlet. In addition, power can be supplied to the camera using an Ethernet cable of up to 100 m (about 328 feet) long, allowing you more freedom to install the camera wherever you want. PoE connection requires a PoE compliant hub or similar device. An optional AC adaptor can be used instead of a PoE connection if you want to connect the camera to a standard AC outlet.\n \n SD/SDHC memory card support\n Camera images can be recorded to an optional SD/SDHC memory card in addition to the camera’s internal memory. The camera supports Panasonic SD memory cards from 64 MB to 2 GB in capacity, as well as Panasonic SDHC memory cards. Additionally, the Stand-alone SD Memory Card Recording feature allows you to configure the camera to record images without using a PC.\n \n UPnP™ support\n When connecting the camera to a UPnP™ compatible router, the camera’s network settings can be automatically configured, making setup quick and easy. For more information, see 4.1 Configuring Port Forwarding.\n \n Viewnetcam.com support\n After registering your camera with the Viewnetcam.com service, you can access the camera while away from home using an easy to remember Internet address of your choosing, such as ***.viewnetcam.com. For more information, see 4.2.1 Configuring the Camera to Use Viewnetcam.com.\n \n Multi-language support\n All camera pages can be displayed in English, French, German, Italian, Spanish, Russian, Simplified Chinese, and Japanese. The most commonly used camera pages can be displayed in Korean.\n \n \n *1 When the camera is installed according to the instructions provided in the included documentation, and the camera has been properly waterproofed.\n \n \n \n");

contentsDictionary["id_om01_0207"] = new ContentsDictionaryEntry("Other Information", "Other Information\n About this document\n • This document is written for both the BB-HCM527 (Indoor Use Only) and the BB-HCM547 (Outdoor Ready). Available features and operations vary slightly depending on the model. You can confirm the model no. of your camera by checking the model no. printed on the front of the camera. Features and operations that apply to the BB-HCM547 only are marked as “BB-HCM547 only” in this document.\n \n • The camera illustrations in this document depict the BB-HCM547.\n \n • Model number suffixes (“A” and “CE”) are omitted from the following model numbers shown in this document, unless necessary.\n BB-HCM527A, BB-HCM527CE, BB-HCM547A, BB-HCM547CE\n \n \n \n Trademarks\n • SDHC Logo is a trademark.\n \n • Microsoft, Windows, Windows Vista, Hotmail, ActiveX, Internet Explorer, and Windows Media are either registered trademarks or trademarks of Microsoft Corporation in the United States and/or other countries.\n \n • Screen shots reprinted with permission from Microsoft Corporation.\n \n • All other trademarks identified herein are the property of their respective owners.\n \n • This software is based in part on the work of the Independent JPEG Group.\n \n \n \n Abbreviations\n • UPnP is the abbreviation for “Universal Plug and Play”.\n \n • The Network Camera is referred to as “the camera” in this document.\n \n • The Setup CD-ROM is referred to as “the CD-ROM” in this document.\n \n • The term “SD memory card” is used in this document to refer to SD memory cards and SDHC memory cards.\n \n \n \n");

contentsDictionary["id_om01_0123"] = new ContentsDictionaryEntry("Section 1 Camera Monitoring", "Section 1 Camera Monitoring \n");

contentsDictionary["id_om01_0124"] = new ContentsDictionaryEntry("1.1 Accessing the Camera", "1.1 Accessing the Camera \n You will need to know the following information to access the camera.\n • The camera’s IP address (e.g., 192.168.0.253) or URL (e.g., ***.viewnetcam.com)\n \n • The port number of the camera, if it is not 80.\n \n • The user name and password required to access the camera, which were set during camera setup.\n \n \n  \n 1. Start your PC’s web browser.\n \n 2. In the browser’s address bar, enter http:// followed by the IP address of the camera, then press [Enter] on the keyboard.\n Example: http://192.168.0.253 \n • If the camera’s port number is a port number other than 80, enter “:” and the port number after the IP address.\n Example: http://192.168.0.253:50001 \n \n • If you have registered with a Dynamic DNS service, such as Viewnetcam.com (see 4.2.1 Configuring the Camera to Use Viewnetcam.com), enter the URL instead of the IP address. Note that accessing the camera this way may only work when you are accessing the camera from outside, i.e., from a PC that is not connected to the same network as the camera.\n Example: http://***.viewnetcam.com \n If the camera’s port number is a port number other than 80, enter “:” and the port number after the URL.\n Example: http://***.viewnetcam.com:50001 \n \n • If the camera is configured to use HTTPS (see 5.2 HTTPS Settings), enter https:// followed by the IP address or host name and the port number of the camera.\n Example: https://192.168.0.253:80 \n Example: https://***.viewnetcam.com:80 \n \n \n \n 3. When the authentication dialog is displayed, enter the user name and password, then click [OK]. The top page is displayed.\n Note\n • If the authentication dialog is not displayed, click the [Login] tab after the camera’s top page is displayed. For more information, see 6.5 The Login Tab.\n \n \n • If a security warning is displayed when accessing the camera using HTTPS, see Installing security certificates.\n \n \n \n \n 4. After the top page is displayed, click the desired tab. (Depending on how the camera has been configured, certain tabs may not be displayed.)\n \n \n A. To display the top page\n \n B. To view images from this camera (see 1.2 Viewing Live Camera Images)\n \n C. To view images from multiple cameras (see 1.3 Viewing Multiple Camera Images)\n \n D. To view buffered camera images (see 2.6 Viewing Buffered Images)\n \n E. To configure the camera\n \n F. To configure the camera to be accessed over the Internet (see Section 4 Configuring the Camera for Access from the Internet)\n \n G. To confirm camera status and perform camera maintenance (see Section 9 Camera Administration and Maintenance)\n \n H. To view URLs for Panasonic Network Camera support sites on the Internet (see Section 10 The [Support] Tab)\n \n I. To log in to the camera as the administrator or as a general user (see 6.5 The Login Tab)\n \n J. Click the desired display language\n \n K. Displays the camera’s model number\n \n L. Displays the camera’s firmware version number\n \n M. Displays [IPv4] or [IPv6] depending on the camera’s network configuration\n \n \n \n \n");

contentsDictionary["id_om01_0125"] = new ContentsDictionaryEntry("1.2 Viewing Live Camera Images", "1.2 Viewing Live Camera Images \n 1. Access the camera (see 1.1 Accessing the Camera).\n \n 2. Click the [Single] tab.\n • Viewer programs (ActiveX® Controls) must be installed in order to view MPEG-4 images, MJPEG images, and to use audio features. If the appropriate viewer program (ActiveX Control) is not installed, the camera will prompt you to install them. For more information, see ActiveX dialog for Windows® XP Service Pack 2 or Security Warning dialog (for Windows 2000) depending on which operating system you are using.\n \n • If the [Security Warning] dialog is displayed, see Security Warning dialog (for Windows 2000).\n \n • If the camera image is not displayed, or if the ActiveX message is displayed at the top of the screen, see If you cannot install ActiveX Controls, or if you cannot see video (MPEG-4 or MJPEG) images in Internet Explorer.\n \n \n \n \n The single camera page (JPEG)\n \n \n A. Date and time overlay (see 7.1 Changing Image Display Settings)\n \n B. Snapshot button (see 1.2.8 Taking Snapshots)\n \n C. Talk button (see 1.2.11 Audio Features)\n \n D. Listen button (see 1.2.11 Audio Features)\n \n E. Volume slider (see 1.2.11 Audio Features)\n \n F. Detection notification sound button (see 1.2.9 Detection Notification Sound)\n \n G. Camera name (see 7.1 Changing Image Display Settings)\n \n H. Full-screen button (click to view the image in 4:3 full-screen mode; click \n to return to normal mode)\n \n I. Status overlay (see 7.1 Changing Image Display Settings)\n \n J. Camera image (click an area of the camera image to use the click to center feature (see Click to center), or use your mouse to use the zoom feature (see 1.2.7 Zooming) when displaying MJPEG or MPEG-4 images)\n \n K. Operation bar (see 1.2.1 Using the Operation Bar)\n \n L. Text overlay (see 7.1 Changing Image Display Settings)\n \n M. Banner (see 7.1 Changing Image Display Settings)\n \n N. Displays [IPv4] or [IPv6] depending on the camera’s network configuration\n \n \n \n The single camera page (MPEG-4)\n MPEG-4 images can be viewed by selecting [MPEG-4] under the refresh rate selector on the single camera page.\n Note\n • The first time you select MPEG-4 as the refresh rate, a license agreement is displayed. If you agree to the terms of the license, select [I accept the License agreement], then click [OK]. You will then be prompted to install the viewer program (ActiveX Controls).\n \n \n \n \n \n A. Date and time overlay (see 7.1 Changing Image Display Settings)\n \n B. Talk button (see 1.2.11 Audio Features)\n \n C. Snapshot button (see 1.2.8 Taking Snapshots)\n \n D. Listen button (see 1.2.11 Audio Features)\n \n E. Camera name (see 7.1 Changing Image Display Settings)\n \n F. Volume slider (see 1.2.11 Audio Features)\n \n G. Camera image (click an area of the camera image to use the click to center feature (see Click to center), or use your mouse to use the zoom feature (see 1.2.7 Zooming) when displaying MJPEG or MPEG-4 images)\n \n H. Full-screen button (click to view the image in 4:3 full-screen mode; click \n to return to normal mode)\n \n I. Status overlay (see 7.1 Changing Image Display Settings)\n \n J. Operation bar (see 1.2.1 Using the Operation Bar)\n \n K. Text overlay (see 7.1 Changing Image Display Settings)\n \n L. MPEG-4 streaming method (see 1.2.6 Video Images (MJPEG and MPEG-4) and Image Refresh Rate)\n \n M. Banner (see 7.1 Changing Image Display Settings)\n \n N. Displays [IPv4] or [IPv6] depending on the camera’s network configuration\n \n \n Note\n Image display\n • If no camera image is displayed, the appropriate viewer program (ActiveX Controls) may not be installed. See ActiveX dialog for Windows® XP Service Pack 2 or Security Warning dialog (for Windows 2000) for more information.\n \n • If the camera image is not displayed immediately or correctly, click your web browser’s refresh button to display the latest camera image.\n \n • The image refresh rate may vary depending on network conditions, PC performance, the number of people accessing the camera, and the type of objects being viewed.\n \n • The image refresh rate may decrease when buffering images to an SD memory card.\n \n • When the camera is in a dark environment, color night view mode (if enabled; see 5.5 Changing Basic Camera Settings) automatically brightens the image, however the image refresh rate may decrease (i.e., images may appear choppy) and overall image quality may decrease (i.e., images may appear grainy).\n \n • When the camera is in a dark environment, white or colored dots or horizontal lines may be displayed in the camera image. This is a characteristic of the camera’s image sensor, and is not a malfunction.\n \n • A gray screen is displayed instead of the camera image in the following situations:\n – Too many users are accessing the camera. When the maximum number of accesses has been exceeded (refer to the tables in 1.4 Maximum Number of Viewing Sessions), additional users will see a gray screen, and [The maximum number of accesses has been exceeded.] will be displayed under the camera image. Click your web browser’s refresh button periodically until you are allowed to view video images, or use the [Refresh Rate] selector to select to view still images.\n \n – The camera is configured to not display images at this time of day (see 7.3 Specifying Operation Times). [The operation time has ended.] will be displayed under the camera image. If viewing MPEG-4 images, the last image displayed before the operation time ended is displayed for about 20 seconds before the screen turns gray.\n \n \n \n \n Related settings\n • The default settings for [Refresh Rate], [Resolution], and [Image Quality] that are used each time the single camera page is accessed can be changed (see 7.1 Changing Image Display Settings).\n \n • Using the [Refresh Rate] selector in the operation bar, you can select whether video images (MJPEG or MPEG-4) are displayed, or still images that are refreshed periodically (3 seconds, 5 seconds, etc.) are displayed.\n \n • To reduce data traffic when other users are accessing the camera, you can configure the camera to automatically switch from displaying video images to still images. Set the [Video Display Time] for general users (see Creating or modifying a general user account) and for guest users (see Changing the features available to guest users).\n \n \n \n \n ActiveX dialog for Windows® XP Service Pack 2\n To view video images (i.e., MPEG-4 and MJPEG images) or use the camera’s audio features, the corresponding viewer program (ActiveX Controls) must be installed on your PC. Follow the steps below to install ActiveX Control when using Windows XP Service Pack 2.\n Note\n • If ActiveX Controls cannot be installed, download them from the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html).\n \n \n \n 1. When the ActiveX Control message is displayed in Internet Explorer®, click the message and select [Install ActiveX Control...].\n \n \n \n 2. Click [Install].\n \n \n \n \n \n ActiveX dialog for Windows Vista®\n To view video images (i.e., MPEG-4 and MJPEG images), the corresponding viewer program (ActiveX Controls) must be installed on your PC. Follow the steps below to install ActiveX Control when using Windows Vista.\n Note\n • If ActiveX Controls cannot be installed, download them from the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html).\n \n \n \n Installing for MJPEG\n 1. When the ActiveX Control message is displayed in Internet Explorer, click the message and select [Install ActiveX Control...].\n \n \n \n 2. Click [Install].\n \n \n \n \n \n Installing for MPEG-4\n 1. When the pop-up block message is displayed in Internet Explorer, click the message and select [Temporarily Allow Pop-ups].\n \n \n \n 2. When a license agreement is displayed and you agree to the terms of the license, select [I accept the License agreement], then click [OK].\n \n 3. When the ActiveX Control message is displayed in Internet Explorer, click the message and select [Install ActiveX Control...].\n \n \n \n 4. Click [Install].\n \n \n \n \n \n \n Security Warning dialog (for Windows 2000)\n To view video images (i.e., MPEG-4 and MJPEG images) or use the camera’s audio features, the corresponding viewer program (ActiveX Controls) must be installed on your PC. If ActiveX Controls need to be installed on your PC, the [Security Warning] dialog will be displayed when trying to view video images (MPEG-4 or MJPEG) for the first time. You can install ActiveX Controls by clicking [Yes] when the following dialog is displayed, however, you must be logged into your PC as a user with Administrator privileges.\n Note\n • If ActiveX Controls cannot be installed, download them from the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html).\n \n \n \n \n \n \n If you cannot install ActiveX Controls, or if you cannot see video (MPEG-4 or MJPEG) images in Internet Explorer\n Confirm the following Internet Explorer settings.\n 1. Click [Tools]→[Internet Options...]→[Security] tab and click [Custom level...] on the web browser.\n \n 2. Under [Download signed ActiveX controls], select [Prompt].\n \n 3. Under [Run ActiveX controls and plug-ins], select [Enable].\n \n \n  \n If you need to install ActiveX Controls, you can download them from the Panasonic Network Camera support site (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) or install them using the CD-ROM included with your camera.\n 1. After downloading the ActiveX Controls installer or inserting the CD-ROM in your PC, restart the PC.\n \n 2. Confirm that Internet Explorer is closed.\n \n 3. Double-click the downloaded ActiveX Controls installer, or open the [ocx] folder on the CD-ROM, then open the [MPEG-4] or [MJPEG] folder on the CD-ROM and double-click [install.bat].\n \n \n Note\n • When using Windows Vista, you must be logged into your PC as a user with Administrator privileges. For more information, open the [ocx] folder on the CD-ROM, then open the [MPEG-4] or [MJPEG] folder on the CD-ROM and double-click [ReadmeEng.txt].\n \n • After installing or enabling ActiveX Controls, you may need to wait a moment before camera images are displayed.\n \n • If you use a proxy server, see 12.1 Proxy Server Settings.\n \n • If your computer or your network uses a firewall for security purposes, the firewall may prevent video images from being displayed. In this case, you can use the [Refresh Rate] selector to select to view still images. If you want to view video images, consult your network administrator.\n \n • If your browser’s pop-up blocker is enabled, you may not be able to install the MPEG-4 viewer program (ActiveX Controls), and therefore you will not be able to view MPEG-4 images. Disable your browser’s pop-up blocker and try to view MPEG-4 images again.\n \n \n \n \n");

contentsDictionary["id_om01_0130"] = new ContentsDictionaryEntry("1.2.1 Using the Operation Bar", "1.2.1 Using the Operation Bar \n The operation bar is displayed to the left of the camera image when viewing images from a single camera, and provides the following features.\n \n \n A. End Display and Preset Display: When the lens has reached the end of its pan, tilt, zoom (4.6× zoom only), the appropriate message will be displayed here ([Left End], [Right End], [Up End], [Down End], [Tele End], [Wide End]. Additionally, when a preset (see 1.2.10 Registering and Changing Presets) is selected, the name of the preset is displayed here (except [Home Position]).\n \n B. Pan and Tilt Scan Buttons: Allow you to pan or tilt the lens to its maximum pan or tilt range. The lens returns to the original position when finished.\n \n C. Navigation Buttons: Allow you to pan the lens left and right, and tilt the lens up and down. Click the center navigation button to move the lens to the home position.\n \n D. Pan/Tilt Range Button: Allows you to limit the pan and tilt range of the camera’s lens (see 1.2.3 Limiting the Pan/Tilt Range).\n \n E. Zoom Buttons: Allow you to use the 4.6× zoom feature to zoom in and out as desired (see 1.2.7 Zooming).\n \n F. Preset Program Button: Allows you to add, change, or delete presets (see 1.2.10 Registering and Changing Presets).\n \n G. Preset Selection Buttons and Menu: Allow you to move the lens to a pre-programmed position. You can register up to 20 presets (see 1.2.10 Registering and Changing Presets).Click buttons 1–8 to move the lens to the corresponding preset, or select the desired preset from the pull-down menu.\n \n H. Brightness Controls: Allow you to change the brightness of the displayed image. Click [-] to darken the image, [+] to brighten the image, and [STD] to return the image to the standard brightness level. There are a total of 9 brightness levels available. Brightness changes to the standard level when the backlight feature is turned on or off.\n \n I. Backlight Correction Buttons: Allow you to turn the backlight correction feature on and off. This feature can automatically correct the brightness of the camera image (see 1.2.4 Backlight Correction).\n \n J. White Balance Selector: Allows you to adjust the white balance to match the environment of the camera. Change this setting to achieve the most natural looking colors (see 1.2.5 White Balance).\n \n K. Output Control: Controls the output signals of the external I/O interface (see 7.4 Controlling the External Output Terminal).\n \n L. Refresh Rate Selector: Determines how often the camera image is refreshed (see 1.2.6 Video Images (MJPEG and MPEG-4) and Image Refresh Rate). Select [MPEG-4] or [MJPEG] to view video images, or one of the other settings to view still images (JPEG format) that are refreshed only periodically. For example, selecting [3 s] will refresh the camera image once every 3 seconds.\n \n M. Image Resolution Selector: Determines the resolution of the image (i.e., the size of the image in pixels) that is displayed.\n \n N. Image Quality Selector: Allows you to select the image quality. Select [Favor Clarity] for optimal image clarity, [Favor Motion] for optimal motion quality, and [Standard] for standard image quality. This selector is not displayed when [MPEG-4] is selected under [Refresh Rate].\n \n O. Streaming Method Selector: Allows you to select the method used to stream MPEG-4 images from the camera (see 1.2.6 Video Images (MJPEG and MPEG-4) and Image Refresh Rate). This selector is displayed only when [MPEG-4] is selected under [Refresh Rate]. To stream MPEG-4 images using Multicast, you must first configure the camera for multicasting (see 5.7 Changing Video Streaming Settings), after which [Multicast] is available from this pull-down menu.\n \n \n \n Note\n • The brightness and white balance settings assigned to the home position are used each time the camera is turned on, however, the current settings are saved when registering a preset (see 1.2.10 Registering and Changing Presets) and those settings are used when viewing a preset.\n \n • The camera lens moves to the home position when it is turned on. You can change the home position if necessary (see 1.2.10 Registering and Changing Presets).\n \n \n \n");

contentsDictionary["id_om01_0282"] = new ContentsDictionaryEntry("1.2.2 Aiming the Camera Lens", "1.2.2 Aiming the Camera Lens \n The camera’s lens can be panned from -175° to +175° and tilted from 0° to +82°.\n \n \n \n Pan\n \n Tilt\n \n There are several ways you can move the camera lens to view the desired image, as described in this section.\n Click to center\n Allows you to quickly and easily center the camera image on the desired point. Simply move the mouse cursor to the desired point in the camera image, and click. Note that the camera may not be able to center on the clicked point if it is outside of the pan and tilt range of the lens.\n \n \n This feature can be disabled for general users (see Creating or modifying a general user account) and for guest users (see Changing the features available to guest users). Note, however, that if the click to center feature and 4.6× zoom features are disabled, users can still use this feature when using the 10× digital zoom feature. Users can click to center the image within the zoomed area, but the lens will not pan or tilt.\n \n Pan and tilt scan buttons\n Allow you to pan or tilt the lens to its maximum pan or tilt range. The lens returns to the original position when finished.\n This feature can be disabled for general users (see Creating or modifying a general user account) and for guest users (see Changing the features available to guest users).\n \n Navigation buttons\n Allow you to pan the lens left and right, and tilt the lens up and down. Click the center navigation button to move the lens to the home position.\n • The camera lens moves to the home position when it is turned on. You can change the home position if necessary (see 1.2.10 Registering and Changing Presets).\n \n \n This feature can be disabled for general users (see Creating or modifying a general user account) and for guest users (see Changing the features available to guest users).\n \n Presets\n Allow you to move the lens to a pre-programmed position. You can register up to 20 presets (see 1.2.10 Registering and Changing Presets). Click buttons 1–8 to move the lens to the corresponding preset, or select the desired preset from the pull-down menu. You can also move the lens to the home position by clicking the center navigation button.\n This feature can be disabled for general users (see Creating or modifying a general user account) and for guest users (see Changing the features available to guest users).\n \n");

contentsDictionary["id_om01_0361"] = new ContentsDictionaryEntry("1.2.3 Limiting the Pan/Tilt Range", "1.2.3 Limiting the Pan/Tilt Range \n You can limit the maximum pan and tilt range of the camera’s lens. The maximum pan range is -175° to +175°. The maximum tilt range is 0° to +82°.\n Note\n • This feature is available to the camera administrator only.\n \n \n \n 1. Click the [Pan/Tilt Range] button in the operation bar.\n \n \n \n 2. Set the pan and tilt range as desired.\n a. Aim the camera to the leftmost point you want to allow to be seen, then click \n.\n \n b. Aim the camera to the rightmost point you want to allow to be seen, then click \n.\n \n c. Aim the camera to the uppermost point you want to allow to be seen, then click \n.\n \n d. Aim the camera to the lowermost point you want to allow to be seen, then click \n.\n \n \n \n 3. Click [Save].\n \n \n Note\n • Even if you limit the pan and tilt range, you can view the entire range of the camera’s pan and tilt range while setting the pan and tilt range on this page.\n \n • When you click the [Pan/Tilt Range] button, the refresh rate changes to MJPEG.\n \n • You can aim the camera by clicking on the desired navigation button, or by using the click to center feature.\n \n \n \n");

contentsDictionary["id_om01_0470"] = new ContentsDictionaryEntry("1.2.4 Backlight Correction", "1.2.4 Backlight Correction \n The camera’s backlight correction feature can automatically correct the brightness of the camera image. You can turn this feature on and off by clicking [On] and [Off] under [Backlight] in the operation bar.\n • If you select to display the status in the overlay setting, \n is displayed on the single camera and multi camera pages when the backlight correction feature is on (see 7.1 Changing Image Display Settings).\n \n • Brightness automatically changes to the standard brightness level each time the backlight feature is turned on or off.\n \n • When this feature is enabled, the camera can automatically correct the brightness of the camera image. This means even when there is backlight in the image, the camera can correct the image to provide a more consistent, natural image.\n \n • The effectiveness of this feature may vary depending on the object being viewed and other conditions.\n Additionally, under certain conditions, the image may appear unnatural, or noise may appear in the image when this feature is enabled.\n \n \n");

contentsDictionary["id_om01_0371"] = new ContentsDictionaryEntry("1.2.5 White Balance", "1.2.5 White Balance \n While viewing camera images on the single camera page, you can use the [White Balance] selector to adjust the camera’s image to match the environment of the camera. Change this setting to achieve the most natural looking colors.\n The following settings are available.\n – [Auto]: White balance is adjusted automatically according to the image being displayed\n \n – [Indoor]: Electric bulb (2800 K)\n \n – [Fluorescent (White)]: White type fluorescent light (4000 K)\n \n – [Fluorescent (Daylight)]: Daylight type fluorescent light (4800 K)\n \n – [Outdoor]: Solar light (6000 K)\n \n – [Hold]: Maintains the current white balance setting\n \n \n Note\n • “K” is the unit used to measure color temperature.\n \n • The current white balance setting is saved when you register a preset (see 1.2.10 Registering and Changing Presets).\n \n \n \n");

contentsDictionary["id_om01_0372"] = new ContentsDictionaryEntry("1.2.6 Video Images (MJPEG and MPEG-4) and Image Refresh Rate", "1.2.6 Video Images (MJPEG and MPEG-4) and Image Refresh Rate \n Using the [Refresh Rate] selector in the operation bar, you can select whether video images ([MJPEG] or [MPEG-4]) are displayed, or still images that are refreshed periodically (3 seconds, 5 seconds, etc.) are displayed. You can change the default setting for [Refresh Rate] that is used each time the single camera page is accessed (see 7.1 Changing Image Display Settings).\n MJPEG\n MJPEG (Motion JPEG) is a video format that displays a continuous series of still images. Because each MJPEG frame is a still image, this format offers high-quality images, but uses more bandwidth, and frame rate may decrease as a result. To view images in MJPEG format, set the [Refresh Rate] selector to [MJPEG].\n \n MPEG-4\n MPEG-4 is a video format that updates images only when there is a variation in the image displayed, and as a result, requires less bandwidth. MPEG-4 is useful in situations when less bandwidth is available, such as when viewing camera images over the Internet. To view images in MPEG-4 format, set the [Refresh Rate] selector to [MPEG-4], then select the desired streaming format under [Streaming Method]. MPEG-4 images can be streamed using multicast, unicast, and HTTP (see 5.7 Changing Video Streaming Settings). When accessing the camera using HTTPS, multicast and unicast streaming is not possible: HTTP is the only available streaming method.\n – [Auto]: The first available MPEG-4 streaming method will be used, beginning with multicast, then unicast, then HTTP. The current streaming method is displayed below the camera image.\n \n – [Multicast] (Multicast RTP): Multicast allows you to stream the same data over the network to multiple parties, thus reducing the amount of data that is sent over the network.\n • Multicast streaming is not possible when viewing camera images over the Internet.\n \n • In order to use multicast streaming, the camera must be configured for multicasting (see 5.7 Changing Video Streaming Settings). Note that multicast streaming is not possible when viewing camera images on certain local networks. Consult your network administrator before configuring the camera for multicasting.\n \n • MPEG-4 images may break up when accessing the camera over a low bandwidth connection. This is normal. In this case, select [Unicast] or [HTTP] as the streaming method.\n \n • If MPEG-4 images cannot be displayed when [Multicast] is selected as the streaming method, select [Auto], [Unicast] or [HTTP].\n \n \n \n – [Unicast] (Unicast RTP): While no special settings are required to stream video using unicast, video is streamed to each individual user viewing MPEG-4 images, which creates more network traffic as more users access the camera. Unicast is generally more reliable than multicast, and is not as susceptible to image quality issues that may occur with when multicasting.\n • Unicast streaming is not possible when viewing camera images over the Internet.\n \n • Unicast streaming may not be possible when viewing camera images on certain local networks. Consult your network administrator for more information.\n \n • If a user with a low bandwidth connection or if many users are viewing images using unicast streaming, frame rate will decrease and image quality may be affected for all users viewing MPEG-4 images.\n \n • If MPEG-4 images cannot be displayed when [Unicast] is selected as the streaming method, select [Auto] or [HTTP].\n \n \n \n – [HTTP] (RTP over HTTP): When streaming video using HTTP, the camera confirms that the data is being received by the user. Video can be viewed in network environment that do not support multicast or unicast streaming, however, this streaming method requires more bandwidth than the other methods.\n • If a user with a low bandwidth connection or if many users are viewing images using HTTP streaming, frame rate will decrease and image quality may be affected for all users viewing MPEG-4 images.\n \n • If MPEG-4 images cannot be displayed when [HTTP] is selected as the streaming method, select [MJPEG] as the image refresh rate.\n \n \n \n \n Note\n • If a user with a low bandwidth connection is viewing MPEG-4 images, frame rate will decrease and image quality may be affected for all users viewing MPEG-4 images.\n \n • When the camera is configured to buffer images in MPEG-4 format, frame rate will decrease when viewing MPEG-4 images on the single camera and multi camera pages.\n \n • To adjust video streaming settings in order to improve image quality or frame rate when viewing MPEG-4 images, see 5.7 Changing Video Streaming Settings.\n \n \n \n \n Still Images\n Still images that are refreshed periodically can be displayed instead of video images by selecting the desired refresh rate. For example, selecting [3 s] will refresh the camera image once every 3 seconds.\n \n");

contentsDictionary["id_om01_0236"] = new ContentsDictionaryEntry("1.2.7 Zooming", "1.2.7 Zooming \n The camera has two zoom features. The first is an optical zoom that allows you to magnify images by up to 2.3× and a digital zoom feature that allows you to further magnify images by up to 2×, for a total zoom range of 4.6×. This feature is referred to in this document as the “4.6× zoom” feature. The 4.6× zoom feature can be used when:\n – Viewing video images on the single camera page\n \n \n The second zoom feature is a 10× (by area) digital zoom. This feature uses the ActiveX Controls installed on your PC; when using this feature, the lens itself does not zoom. This means that while you are using the 10× digital zoom, another user can be looking at the same image with no zoom. This feature is referred to in this document as the “10× digital zoom” feature. The 10× digital zoom can be used when:\n – Viewing video images on the single camera page (when the 4.6× zoom feature is disabled)\n \n – Viewing video images from multiple cameras on the multi camera page\n \n – Viewing buffered MJPEG video images on the buffered image page\n \n \n There are 3 ways to use the zoom features, as explained later in this section.\n Note\n • As the digital zoom magnification increases, image quality decreases.\n \n • You can move the lens as normal (selecting a preset, using the navigation buttons, etc.) even when zooming.\n \n • The 4.6× zoom feature can be disabled for general users (see Creating or modifying a general user account) and for guest users (see Changing the features available to guest users). The 10× digital zoom is available when the optical zoom feature is disabled.\n \n • If the 4.6× zoom feature is disabled for general users or guest users, or when zooming while viewing buffered MJPEG video images, the 10× digital zoom is available. The digital zoom magnification (×1.0–×10.0) is displayed briefly while zooming.\n \n • When [Tele End] is displayed at the top of the operation bar, the lens cannot zoom in any further. When [Wide End] is displayed, the lens cannot zoom out any further.\n \n • When using the optical zoom to zoom out, the lens zooms in slightly after the zoom out. This is a characteristic of the camera’s zoom feature, and is not a malfunction.\n \n \n \n Zooming with the zoom buttons\n Click \n or \n in the operation bar to use the 4.6× zoom to zoom in or out, respectively. Note that these buttons are not displayed if the 4.6× zoom feature is disabled for general users or guest users.\n \n Zooming with the scroll wheel\n With the cursor placed over the camera image, rotate the scroll wheel away from you to zoom in, and rotate the scroll wheel toward you to zoom out. Note that the zoom speed depends on your mouse performance and your PC’s mouse settings.\n \n \n A. Zoom in\n \n B. Zoom out\n \n \n \n \n Zooming with the right mouse button\n Right-click the upper part of the image to zoom in, and right-click the lower part of the image to zoom out.\n \n \n A. Zoom in\n \n B. Zoom out\n \n \n \n \n");

contentsDictionary["id_om01_0129"] = new ContentsDictionaryEntry("1.2.8 Taking Snapshots", "1.2.8 Taking Snapshots \n You can take snapshots while viewing camera images and save them on your PC.\n 1. Click the snapshot button (\n).\n • The camera image opens in a new window.\n \n \n \n 2. Right-click the image, and select [Save Picture As...].\n • The [Save Picture] dialog appears.\n \n \n \n 3. Enter a name for the file.\n \n 4. Specify where you want to save the file, then click [Save].\n \n 5. Click [Close].\n \n \n Note\n • Snapshots are saved in JPEG format at the [Favor Clarity] setting.\n \n • This feature can be disabled for general users (see Creating or modifying a general user account) and for guest users (see Changing the features available to guest users).\n \n \n \n");

contentsDictionary["id_om01_0826"] = new ContentsDictionaryEntry("1.2.9 Detection Notification Sound", "1.2.9 Detection Notification Sound \n While viewing MJPEG images on the single or multi-camera screens, your computer can play a sound to notify you when motion is detected or when the sensor is triggered.\n This feature can be set independently on each computer that accesses the camera, and functions whether the triggers on the camera’s [Buffer/Transfer] page are active or disabled.\n 1. While viewing the single camera or multi camera screen, click \n.\n \n \n \n 2. Set the following parameters as desired.\n a. Under [Play Sound on Detection], select whether you want your computer to play a sound to notify you when motion is detected or when the sensor is triggered.\n \n b. Under [Sound File], click [Browse], then select the desired sound (audio file).\n • Only PCM-format .wav files are compatible with this feature.\n \n • Only files that are less than 10 seconds long are compatible with this feature.\n \n \n \n c. Under [Playback Time], select the desired playback time.\n \n d. Under [Motion Detection] and [Alarm1]/[Alarm2], select whether you want your computer to play a sound to notify you when there is a motion or sensor detection.\n \n \n \n 3. Click [Save].\n \n 4. Click your web browser’s refresh button to apply the new settings.\n Note\n • When [16 Screens] is selected as the number of cameras displayed on the multi-camera screen, the detection notification sound feature cannot be used.\n \n • You can set the detection notification sound feature for each camera viewed on the multi-camera screen.\n \n \n \n \n \n");

contentsDictionary["id_om01_0132"] = new ContentsDictionaryEntry("1.2.10 Registering and Changing Presets", "1.2.10 Registering and Changing Presets \n Presets allow you to easily aim the camera lens in the desired direction. Brightness and white balance settings are also saved when registering a preset. The following presets can be registered:\n • Home position (the direction that the lens moves to when you turn the camera on or click the center navigator button)\n \n • Alarm positions 1 and 2\n \n • Presets 1–20\n \n \n Viewing a preset\n You can move the lens to a preset position in the following ways:\n • Click the center navigator button (to move the lens to the home position)\n \n • Click [-Preset-] and select a preset from the pull-down menu\n \n • Click a blue preset button (1–8) (Unregistered preset buttons are displayed in white.)\n \n \n \n Registering or changing a preset\n Note\n • This feature is available to the camera administrator only.\n \n \n \n 1. Confirm that you are logged in to the camera as the administrator.\n \n 2. Click [Program].\n \n 3. Aim the camera in the desired direction.\n \n 4. Adjust the zoom (using the 4.6× zoom feature), brightness, backlight, and white balance settings if desired. These settings will be registered to the preset. \n \n 5. Under [Preset Number], select the desired preset from the pull-down menu.\n \n 6. Enter a name for the preset (max. 15 characters).\n • You cannot rename the home position or alarm positions.\n \n • See 14.2 ASCII Character Table for a list of valid characters. Note that [Space], [\"], ['], [&], [<] and [>] cannot be used.\n \n \n \n 7. Click [Save] to register the preset, or click [Back] to cancel.\n • When [Success!] is displayed, click [Back] to continue.\n \n \n \n \n \n Deleting a preset\n Note\n • This feature is available to the camera administrator only.\n \n \n \n 1. Confirm that you are logged in to the camera as the administrator.\n \n 2. Click [Program].\n \n 3. Under [Preset Number], select the desired preset from the pull-down menu.\n • You cannot delete the home position or alarm positions.\n \n \n \n 4. Click [Delete] to delete the preset, or click [Back] to cancel.\n • When [Success!] is displayed, click [Back] to continue.\n \n \n \n \n \n");

contentsDictionary["id_om01_0208"] = new ContentsDictionaryEntry("1.2.11 Audio Features", "1.2.11 Audio Features \n The camera supports the following audio features.\n – Talk\n By connecting a microphone to your PC and an external speaker to the camera, you can talk to someone while seeing their image on your PC screen.\n \n – Listen\n If you have speakers or headphones connected to your PC, the person on the camera side can talk to you using a microphone connected to the camera.\n \n \n Using the talk feature\n While viewing live images from the camera, you can talk into your PC’s microphone. Your voice will be heard through the external speaker connected to the camera.\n • In order to use this feature, a microphone must be connected to the PC, and an external speaker must be connected to the camera. Refer to the Installation Guide for information on connecting an external speaker to the camera.\n \n \n 1. Confirm that the talk button (\n) is displayed. \n • Click the talk off button (\n) if it is displayed to turn the microphone on. The button will change to the talk button (\n).\n \n \n \n 2. Talk into your PC’s microphone.\n \n \n Note\n • To turn off the microphone, click the talk button (\n) or the listen off button (\n). The talk button will change to the talk off button.\n \n \n \n \n Using the listen feature\n While viewing live images from the camera, you can monitor the audio from the camera’s microphone.\n 1. Confirm that the listen button (\n) is displayed.\n • You can mute the audio by pressing the listen button. It will change to the listen off button (\n).\n \n • Press the listen off button to monitor the audio again.\n \n \n \n 2. Adjust the volume using the volume slider (\n).\n • When viewing MPEG-4 images, the volume slider changes appearance (\n).\n \n \n \n \n Note\n Talk and listen\n • These features can be disabled for general users (see Creating or modifying a general user account) and for guest users (see Changing the features available to guest users).\n \n • The talk and listen features cannot be used simultaneously.\n \n • The audio may be interrupted or delayed due to your PC’s performance, the network environment, if you are running other applications, or if you have multiple windows open. Close other applications and windows or reduce the maximum bandwidth (see 5.1.1 Network (IPv4) Settings or 11.3 Configuring Your Camera for IPv6) for best performance.\n \n • If you experience difficulty when using audio features, refer to 1.7 Audio Issues in the Troubleshooting Guide.\n \n \n Talk\n • The talk feature can be used by only one user at a time.\n \n • You can change the maximum time the talk feature can be used (see 5.6 Changing Audio Settings). After the set amount of time passes, the talk feature is automatically turned off.\n \n • The volume of the sound heard through the camera’s external speaker can be adjusted (see 5.6 Changing Audio Settings).\n \n \n Listen\n • The camera’s built-in microphone is disabled when a device is connected to the camera’s external microphone jack.\n \n \n • By default the camera’s microphone is automatically muted when the lens is panning, tilting, or zooming. You can change this setting if desired, as well as adjust the sensitivity of the microphone (see 5.6 Changing Audio Settings).\n \n • When the image is refreshed (such as during preset registration or when clicking your browser’s refresh button), the volume is reset to the center position and the mute will be turned off (i.e., audio will be heard again).\n \n \n \n \n");

contentsDictionary["id_om01_0137"] = new ContentsDictionaryEntry("1.3 Viewing Multiple Camera Images", "1.3 Viewing Multiple Camera Images \n You can register other Panasonic Network Cameras to this camera (see 7.2 Registering Multiple Cameras) and use the multi camera page to view images from multiple cameras. After you have registered the other cameras to this camera (up to 16 cameras can be registered), follow the procedure below to view camera images.\n 1. Access the camera (see 1.1 Accessing the Camera).\n \n 2. Click the [Multi] tab.\n \n \n The multi camera screen\n \n \n A. Full-screen button (click to view the image in 4:3 full-screen mode; click \n to return to normal mode)\n \n B. Changes the number of cameras displayed\n \n C. Switches the display to a different set of cameras\n \n D. Determines the video format of images displayed, or how often the camera images are refreshed\n \n E. Determines the resolution (i.e., the number of pixels) that are displayed for each image\n \n F. Text overlay (see 7.1 Changing Image Display Settings)*1 \n \n G. Date and time overlay (see 7.1 Changing Image Display Settings)*1 \n \n H. Snapshot button (see 1.2.8 Taking Snapshots)\n \n I. Talk button*2 (see 1.2.11 Audio Features)\n \n J. Listen button*2 (see 1.2.11 Audio Features)\n \n K. Volume slider*2 (see 1.2.11 Audio Features)\n \n L. Detection notification sound button (see 1.2.9 Detection Notification Sound).*3 \n \n M. Camera name (see 7.2 Registering Multiple Cameras; click to view the selected camera’s image in a new window)\n \n N. Camera image (click an area of the camera image to use the click to center feature (see Click to center)*4, or use your mouse to use the 10× digital zoom feature when displaying MJPEG or MPEG-4 images)\n \n O. Status overlay (see 7.1 Changing Image Display Settings)\n \n \n \n \n *1 Overlays are displayed only if they are configured for the camera (see 7.1 Changing Image Display Settings). For other cameras, overlays cannot be displayed if the other cameras do not support the overlay feature.\n \n *2 The audio controls displayed for other cameras depend on the audio features supported by the other cameras.\n \n *3 If the camera does not support detection notification sounds, this feature is not available.\n \n *4 If the camera does not support pan and tilt features, this feature is not available.\n \n \n Note\n General Information\n • When viewing multiple cameras, the 4.6× zoom feature is not available, however the 10× digital zoom is available. Note however that as the magnification increases, image quality decreases.\n \n • When viewing images on the multi camera page, the maximum image resolution available is 320 × 240.\n \n • When [16 Screens] is selected as the number of cameras displayed, all images are displayed in 192 × 144 pixel resolution, images are displayed as still images, and the audio controls are not displayed.\n \n • MPEG-4 images displayed on the multi camera page are streamed using the HTTP protocol.\n \n • When the camera is configured to display MPEG-4 images on the multi camera page (see 7.1 Changing Image Display Settings), images from other cameras may be displayed in MJPEG format when accessing the camera using HTTPS. Click your web browser’s refresh button to display MPEG-4 images.\n \n • If a camera configured for the multi camera page is configured to not allow access from guest users, an authentication dialog will be displayed for that camera. You will need to enter a valid user name and password in order to view images from that camera.\n \n • If a camera displayed on the multi camera page is configured to not allow general users or guest users to access certain features (presets, pan/tilt, etc.), those features are not available and their corresponding buttons or controls will not be displayed.\n \n • The image refresh rate may vary depending on network conditions, PC performance, the number of people accessing the cameras, and the type of objects being viewed.\n \n • The image refresh rate may decrease when buffering images to an SD memory card.\n \n • When viewing video images, we recommend connecting the cameras using an Ethernet switching hub instead of a repeater hub to improve image refresh rate.\n \n • As a general guideline, about 3 to 4 Mbps of bandwidth are required to display 4 camera images. If you do not have enough bandwidth, the refresh rate may decrease.\n \n • When viewing MJPEG/JPEG images on the multi camera page, the talk button is displayed in gray for cameras that do not support speakers.\n \n • When viewing MPEG-4 images on the multi camera page, the talk off button (\n) is displayed for cameras that do not support speakers.\n \n \n Related settings\n • The default settings for [Refresh Rate] and [Resolution] that are used each time the multi camera page is accessed can be changed (see 7.1 Changing Image Display Settings).\n \n • Image quality for MJPEG and still images cannot be changed directly on the multi camera page. This setting is determined on the [Image Display] page (see 7.1 Changing Image Display Settings).\n \n • To reduce data traffic when other users are accessing the camera, you can configure the camera to automatically switch from displaying video images to still images. Set the [Video Display Time] for general users (see Creating or modifying a general user account) and for guest users (see Changing the features available to guest users).\n \n • When the refresh rate is too slow, you may be able to improve the refresh rate by limiting the bandwidth (see 5.1.1 Network (IPv4) Settings or 11.3 Configuring Your Camera for IPv6).\n \n \n \n \n When a camera image is not displayed\n • Confirm the settings on the multi camera setup page (see 7.2 Registering Multiple Cameras).\n \n • When configuring cameras for the multi camera page, make sure that the cameras you want to access from the Internet have been registered to this camera using their global IP addresses. For Internet access, local IP addresses (such as 192.168.xxx.xxx) cannot be used.\n \n \n \n");

contentsDictionary["id_om01_0476"] = new ContentsDictionaryEntry("1.4 Maximum Number of Viewing Sessions", "1.4 Maximum Number of Viewing Sessions \n The maximum number of users that can view live and buffered camera images depends on the type of images being viewed, as described in the following tables. Additional users will see a gray screen.\n Access Limitations for HTTP Connections\n Image Format\n No. of Users\n Total No. of Users (Regardless of Image Format)\n MJPEG\n Max. 30\n Max. 30\n MPEG-4\n Max. 10\n \n \n Access Limitations for HTTPS Connections\n Image Format\n No. of Users\n Total No. of Users (Regardless of Image Format)\n MJPEG\n Max. 10\n Max. 10\n MPEG-4\n Max. 5\n \n \n");

contentsDictionary["id_om01_0095"] = new ContentsDictionaryEntry("Section 2 Using Triggers to Buffer and Transfer Images", "Section 2 Using Triggers to Buffer and Transfer Images \n The camera can be configured to buffer its images, i.e., save camera images temporarily in its memory. You can view these images later when accessing the camera. The camera can also be configured to transfer camera images by E-mail, FTP, or HTTP.\n Before you can configure the camera to buffer images, you need to decide what method the camera will use to buffer or transfer images. Buffering methods are called “triggers”; up to 5 triggers can be configured. Camera images can be buffered or transferred based on the following triggers:\n – Timer\n Camera images can be buffered or transferred at specific times on specific days.\n \n – Alarm (i.e., external sensors)\n Camera images can be buffered or transferred when the camera’s external sensors are triggered. The active time of the camera’s sensors can also be specified.\n \n – Motion Detection\n Camera images can be buffered or transferred when the camera detects motion in the camera image. The active time of the camera’s motion detection feature can also be specified.\n \n \n Note\n • The image buffering and transferring features and the motion detection feature are not designed to be used for security or surveillance. No responsibility will be taken by our company with respect to consequences resulting from the use of these features.\n \n • The camera does not use encryption when sending user names and passwords to FTP, E-mail, or HTTP servers. Use caution as necessary to prevent disclosure of this information.\n \n • For added security, we recommend periodically changing the user names and passwords that are required to access your FTP, E-mail, and HTTP servers.\n \n • Refer to 14.3 Internal Memory Capacity for Buffered Images for the camera’s memory capacity for buffering images.\n \n • Refer to 14.4 SD Memory Card Capacity for Buffered Images for SD memory card capacity information.\n \n • Buffered images will be stored on SD memory card (not in the camera’s internal memory) if there is an SD memory card in the camera and if SD memory card recording is started (see 8.3 Starting and Stopping SD Memory Card Recording).\n \n • If the camera is triggered and begins buffering or transferring images, it cannot be triggered again until the camera stops buffering or transferring images, as shown in the figure below.\n \n \n The camera can be triggered.\n \n \n The camera is buffering or transferring images and cannot be triggered during this time.\n \n \n A\n The camera is triggered. Buffering or transferring begins.\n B\n Buffering or transferring ends.\n \n \n \n \n Follow the procedures in this section to configure the camera to buffer or transfer images.\n");

contentsDictionary["id_om01_0131"] = new ContentsDictionaryEntry("2.1 Configuring a Timer Trigger", "2.1 Configuring a Timer Trigger \n Note\n • When you change settings for a trigger, all images buffered in the memory for the selected trigger are deleted. Additionally, images buffered for other triggers may also be deleted. See 2.8 Understanding How the Camera Manages Buffered Images for more information.\n \n \n \n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Buffer/Transfer], click [Trigger].\n \n \n \n 3. Click a trigger number (1–5).\n \n \n \n 4. Check [Enable Image Buffer/Transfer] to enable the trigger.\n \n 5. Select [Timer] from the pull-down menu, then click [Next] to make additional settings (explained below), or click [Save] to finish.\n \n \n \n 6. Set the following parameters as desired.\n a. Under [Time], select the days of the week when the trigger will be active.\n \n b. Select the time of day the trigger will be active, or click [Always] to enable the trigger for the full 24 hours of each day selected.\n \n c. Under [Image Setting], select the desired image format, image resolution, and image quality.\n • When [MPEG-4] is selected and a microphone is connected to the camera, the buffered MPEG-4 file contains audio from the camera’s microphone if the microphone is enabled.\n \n • The image quality setting is not available when [MPEG-4] is selected as the image format.\n \n • When configuring the trigger to transfer images to a mobile phone’s E-mail address, set the image resolution to 192 × 144, and set the image quality to [Favor Motion]. Note that your mobile phone may not be able to receive the image if the file size of the image is too large.\n \n \n \n d. Under [Image Buffer Frequency], select the desired buffer or transfer rate.\n • This setting is not available when [MPEG-4] is selected as the image format.\n \n • The image buffer rate may decrease when buffering images to an SD memory card.\n \n \n \n e. Under [Transfer Method], select the desired buffer or transfer method.\n • MPEG-4 images cannot be transferred.\n \n • If [MPEG-4] is selected as the image format and the camera cannot buffer images to an SD memory card (e.g., no card is inserted), [No Transfer, No Memory Overwrite] is the only available option.\n \n \n – [No Transfer, No Memory Overwrite]: Images are not transferred. Images are buffered until the memory is full.\n \n – [No Transfer, Memory Overwrite]: Images are not transferred. Once the memory is full, new images replace the old images.\n \n – [FTP]: After an image is captured, it is transferred to the specified FTP site.\n \n – [E-mail]: After an image is captured, it is sent to the specified E-mail address.\n \n – [HTTP]: After an image is captured, it is transferred to the specified website.\n \n \n \n \n \n 7. Follow the procedure below based on the settings you made under [Transfer Method].\n a. If you selected to not transfer images (i.e., to buffer images only), click [Save] to finish.\n • All images buffered in the internal memory for the selected trigger are deleted when you click [Save].\n \n \n \n b. If you selected to transfer images by FTP, E-mail, or HTTP, click [Next].\n • The appropriate transfer settings page is displayed.\n – For FTP transfer, see 2.4.1 Transferring Images by FTP.\n \n – For E-mail transfer, see 2.4.2 Transferring Images by E-mail.\n \n – For HTTP transfer, see 2.4.3 Transferring Images by HTTP.\n \n \n \n \n \n \n \n \n Note\n • In order for this feature to work as expected, make sure the camera’s date and time setting is correct (see 5.4 Setting the Date and Time).\n \n • When MPEG-4 videos are buffered to an SD memory card, the maximum size for a single MPEG-4 file is 20 MB. When the 20 MB limit is reached, a new file is created. About 1 second of video will not be buffered when a new file is created.\n \n • When selecting the buffer or transfer rate, keep in mind that the actual rate may be slower depending on network conditions, the number of people accessing the camera, and the type of objects being viewed.\n \n • When the camera is configured to buffer images in MPEG-4 format, frame rate will decrease when viewing MPEG-4 images on the single camera and multi camera pages.\n \n \n \n");

contentsDictionary["id_om01_0210"] = new ContentsDictionaryEntry("2.2 Configuring an Alarm or Motion Detection Trigger", "2.2 Configuring an Alarm or Motion Detection Trigger \n Note\n • When you change settings for a trigger, all images buffered in the memory for the selected trigger are deleted. Additionally, images buffered for other triggers may also be deleted. See 2.8 Understanding How the Camera Manages Buffered Images for more information.\n \n \n \n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Buffer/Transfer], click [Trigger].\n \n \n \n 3. Click a trigger number (1–5).\n \n \n \n 4. Check [Enable Image Buffer/Transfer] to enable the trigger.\n \n 5. Select [Alarm1], [Alarm2], or [Motion Detection] from the pull-down menu, then click [Next].\n • If [Alarm1] or [Alarm2], is selected, select [Rising: GND to Open (High).] or [Falling: Open (High) to GND.] depending on the state of the sensor. See the Installation Guide for details.\n \n • For information on how the motion detection feature detects motion and how to adjust the sensitivity of the motion detection feature, see 2.9 Adjusting Motion Detection Sensitivity.\n \n • The motion detection feature is disabled when panning, tilting, or using the 4.6× zoom, i.e., moving the camera lens will not trigger the motion detection feature.\n \n \n \n \n \n 6. Set the following parameters as desired.\n a. Under [Time], select the days of the week when the trigger will be active.\n \n b. Select the time of day the trigger will be active, or click [Always] to enable the trigger for the full 24 hours of each day selected.\n \n c. Under [Image Setting], select the desired image format, image resolution, and image quality.\n • When [MPEG-4] is selected and a microphone is connected to the camera, the buffered MPEG-4 file contains audio from the camera’s microphone if the microphone is enabled.\n \n • The image quality setting is not available when [MPEG-4] is selected as the image format.\n \n • When configuring the trigger to transfer images to a mobile phone’s E-mail address, set the image resolution to 192 × 144, and set the image quality to [Favor Motion]. Note that your mobile phone may not be able to receive the image if the file size of the image is too large.\n \n \n \n d. Under [Lens Position When Triggered], select [Do not move] or the desired preset. The lens will aim in the appropriate direction when triggered.\n \n e. Under [External Output], select the desired length of time for which the output terminals of the external I/O interface are turned on when the camera has been triggered.\n \n f. Under [Image Buffer Frequency], select the desired buffer or transfer rate.\n When [MPEG-4] is selected\n Select how many seconds of video you would like to save. This setting allows you to see camera images beginning from when the camera was triggered.\n When [JPEG] is selected\n To configure the camera to buffer or transfer images from before the camera was triggered, click [Enable Pre-trigger Image Buffer] and select the image buffer or transfer rate and the total number of images to be buffered or transferred. This setting allows you to see camera images leading up to the moment when the camera was triggered.\n To configure the camera to buffer or transfer images from after the camera was triggered, click [Enable Post-trigger Image Buffer] and select the image buffer or transfer rate and the total number of images to be buffered or transferred. This setting allows you to see camera images beginning from when the camera was triggered.\n • The image buffer rate may decrease when buffering images to an SD memory card.\n \n \n \n g. Under [Sensor deactivation time setting], select the amount of time that must pass after a detection before this trigger can make another detection.\n • If the camera is triggered often, many images will be buffered or transferred. If those images are transferred to a mobile phone by E-mail, for example, many messages will be sent and mobile phone charges may become expensive. It is therefore recommended to use this setting to help reduce the number of images that are buffered or transferred.\n \n • Images will not be buffered or transferred during the deactivation time. As a result, pre-buffer images from the next detection may not be buffered or transferred. For example, if this parameter is set to [10 s], and if the camera is configured to buffer 1 image per second and store 10 images before detection (i.e., buffer images for 10 seconds), the camera will not buffer or transfer images if it is triggered within 10 seconds of the previous trigger. Images can only be buffered or transferred 10 seconds after the previous trigger.\n \n \n The camera can be triggered.\n \n \n The camera is buffering or transferring images and cannot be triggered during this time.\n \n \n Deactivation time; the camera cannot be triggered.\n \n \n A\n The camera is triggered. Buffering or transferring begins. No new images will be buffered or transferred.\n B\n Buffering or transferring ends, deactivation time starts. No new images will be buffered or transferred.\n C\n Deactivation time ends. The camera can buffer or transfer images again.\n \n \n \n \n h. Under [Transfer Method], select the desired transfer method.\n • MPEG-4 images cannot be transferred.\n \n \n – [No Transfer, No Memory Overwrite]: Images are not transferred. Images are buffered until the memory is full.\n \n – [No Transfer, Memory Overwrite]: Images are not transferred. Once the memory is full, new images replace the old images.\n \n – [FTP]: After the camera is triggered, it transfers images to the specified FTP site.\n \n – [E-mail]: After the camera is triggered, it sends images to the specified E-mail address.\n \n – [HTTP]: After the camera is triggered, it transfers images to the specified website.\n \n \n \n i. Under [Send Notification When Triggered], select the desired method for receiving notification when the camera is triggered, or select [Disable].\n \n \n \n 7. Follow the procedure below based on the settings you made under [Transfer Method] and [Send Notification When Triggered].\n a. If you selected to not transfer images and to not send notification when the camera is triggered, click [Save] to finish.\n • All images buffered in the internal memory for the selected trigger are deleted when you click [Save].\n \n \n \n b. If you selected to transfer images by FTP, E-mail, or HTTP, click [Next].\n • The appropriate transfer settings page is displayed.\n – For FTP transfer, see 2.4.1 Transferring Images by FTP.\n \n – For E-mail transfer, see 2.4.2 Transferring Images by E-mail.\n \n – For HTTP transfer, see 2.4.3 Transferring Images by HTTP.\n \n \n \n \n \n c. If you selected to not transfer images, but selected to send notification, click [Next].\n • The appropriate notification settings page is displayed.\n – For E-mail notification, see 2.5.1 Sending Trigger Notifications by E-mail.\n \n – For HTTP notification, see 2.5.2 Sending Trigger Notifications by HTTP.\n \n \n \n \n \n \n \n \n Note\n • In order for this feature to work as expected, make sure the camera’s date and time setting is correct (see 5.4 Setting the Date and Time).\n \n • When selecting the buffer or transfer rate, keep in mind that the actual rate may be slower depending on network conditions, the number of people accessing the camera, and the type of objects being viewed.\n \n • When the camera is configured to buffer images in MPEG-4 format, frame rate will decrease when viewing MPEG-4 images on the single camera and multi camera pages.\n \n \n \n");

contentsDictionary["id_om01_0242"] = new ContentsDictionaryEntry("2.3 Disabling and Enabling a Trigger", "2.3 Disabling and Enabling a Trigger \n After configuring an image buffering trigger, you can later disable the trigger to temporarily turn it off, and enable it to turn it on again. While disabled, a trigger will not buffer images, transfer images, or send trigger notification.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Buffer/Transfer], click [Trigger].\n \n 3. Click a trigger number (1–5).\n \n \n \n 4. Uncheck [Enable Image Buffer/Transfer] to disable the trigger.\n • To enable a trigger you disabled earlier, check [Enable Image Buffer/Transfer].\n \n \n \n 5. Click [Save].\n • All images buffered are deleted when you click [Save].\n \n \n \n \n");

contentsDictionary["id_om01_0243"] = new ContentsDictionaryEntry("2.4 Configuring the Camera to Transfer Images", "2.4 Configuring the Camera to Transfer Images \n When configuring the camera’s timer, external sensor, or motion detection triggers, you can set the camera to transfer the captured images by FTP (see 2.4.1 Transferring Images by FTP), E-mail (see 2.4.2 Transferring Images by E-mail), or HTTP (see 2.4.3 Transferring Images by HTTP). Once images are successfully transferred, they are deleted.\n");

contentsDictionary["id_om01_0244"] = new ContentsDictionaryEntry("2.4.1 Transferring Images by FTP", "2.4.1 Transferring Images by FTP \n The following screen is displayed if you select to transfer images by FTP while configuring a timer, external sensor, or motion detection trigger (see 2.1 Configuring a Timer Trigger or 2.2 Configuring an Alarm or Motion Detection Trigger). Follow the procedure below to configure the camera to transfer images to an FTP site. Ask the FTP server administrator for the appropriate settings.\n \n \n 1. Set the following parameters as desired.\n a. Enter the IP address or host name*1 of the FTP server.\n • An IPv6 address can be entered.\n \n \n \n b. Enter the port number used by the server. (Port 21 is normally used for FTP.)\n \n c. Enter the login ID*2 (user name) required to access the server (max. 63 characters).\n \n d. Enter the password*2 required to access the server (max. 63 characters).\n \n e. Select the desired setting for [Login Timing].\n – [Every Time]: The camera logs in to the server every time it transfers an image to the server.\n \n – [One Time]: The camera logs in to the server and stays connected for about 1 minute (unless a new transfer begins before this time expires). This can reduce transfer time when several images are transferred in a short time.\n \n \n \n f. Enter the desired name*1 for transferred files (max. 234 characters). Transferred files will be saved using this file name.\n • You can specify existing directories on the server by entering “\\” before the desired file name. For example, if you enter “CameraImages\\Image”, the camera will upload files to the directory “CameraImages” and save the files using the name “Image”.\n \n \n \n g. Select the desired setting for [Overwrite setting].\n – [Overwrite File]: The file on the server is replaced by the file uploaded by the camera, i.e., only 1 file is saved on the server.\n \n – [Save as New File with Time Stamp]: A time stamp is added to the end of the file name, allowing multiple files to be saved on the server. For example, if you set the file name as “Image”, an uploaded file may be saved as “Image20061231173020500”.\nThe time stamp format is Year/Month/Date/24-hour time/Second/Millisecond.\nTherefore, in this example, the file was captured on December 31, 2006, at 5:30 PM and 20 seconds and 500 milliseconds. Note that if you configure the camera to adjust its time setting for Daylight Saving Time/Summer Time (see 5.4 Setting the Date and Time), an “s” will be inserted between the date and time of the time stamp.\n \n \n \n h. Select the transfer method required to upload files to the server.\n • Select [Passive Mode] normally. If files are not uploaded properly, change the setting to [Active Mode].\n \n \n \n \n \n 2. Follow the procedure below based on the settings you made when configuring the trigger.\n a. If you selected to not send notification when the camera is triggered, click [Save], then click [Go to Trigger page].\n \n b. If you selected to send notification when the camera is triggered, click [Next].\n • The appropriate notification settings page is displayed.\n – For E-mail notification, see 2.5.1 Sending Trigger Notifications by E-mail.\n \n – For HTTP notification, see 2.5.2 Sending Trigger Notifications by HTTP.\n \n \n \n \n \n \n \n \n \n \n *1 [Space], [\"], ['], [&], [<], and [>] cannot be entered.\n \n *2 [\"] cannot be entered.\n \n \n");

contentsDictionary["id_om01_0245"] = new ContentsDictionaryEntry("2.4.2 Transferring Images by E-mail", "2.4.2 Transferring Images by E-mail \n The following screen is displayed if you select to transfer images by E-mail while configuring a timer, external sensor, or motion detection trigger (see 2.1 Configuring a Timer Trigger or 2.2 Configuring an Alarm or Motion Detection Trigger). Follow the procedure below to configure the camera to send images to an E-mail address. Ask your Internet Service Provider (ISP) or network administrator for the appropriate settings.\n Note\n • To prevent camera images from being sent to the wrong party, make sure you enter the desired destination e-mail addresses correctly.\n \n \n \n \n \n 1. Set the following parameters as desired.\n a. Under [E-mail Transfer], enter the IP address or the host name*1 of the SMTP server (outgoing mail server).\n • An IPv6 address can be entered.\n \n • This feature cannot transfer images to web-based mail servers, such as Hotmail®.\n \n \n \n b. Enter the port number used by the server. (Port 25 is normally used for sending E-mail.)\n \n c. Enter the reply E-mail address*2 that will be shown to the recipient as the sender of the E-mail.\n • In an effort to reduce spam, many ISPs block E-mail sent through the SMTP server from an E-mail address that is not associated with the SMTP server, therefore, we recommend entering the E-mail address assigned to you by your ISP.\n \n \n \n d. Enter the destination E-mail address*2. Up to 3 addresses can be entered.\n \n e. Enter the subject*2 that will be displayed in E-mail messages sent by the camera (max. 44 characters).\n • The date and time (24-hour format) is automatically attached to the subject.\nFor example, if you enter “Camera” as the subject, an E-mail may be sent with the subject “Camera:20061231173020500”.\nThe time stamp format is Year/Month/Date/24-hour time/Second/Millisecond.\nTherefore, in this example, the file was captured on December 31, 2006, at 5:30 PM and 20 seconds and 500 milliseconds. Note that if you configure the camera to adjust its time setting for Daylight Saving Time/Summer Time (see 5.4 Setting the Date and Time), an “s” will be inserted between the date and time of the time stamp.\n \n • The date and time is also used as the sent file name (i.e., 20061231173020500.jpg).\n \n \n \n f. Enter the text*2 that will be displayed in the body of E-mail messages sent by the camera (max. 63 characters).\n • Line breaks cannot be entered.\n \n \n \n \n \n \n \n 2. Under [How to authenticate], select the authentication method your ISP requires for sending E-mail, and enter the appropriate settings if necessary.\n – [No authentication]: Select this option if the outgoing E-mail server does not require authentication when sending E-mail messages.\n \n – [POP before SMTP authentication]: Select this option if the outgoing E-mail server requires POP before SMTP authentication when sending E-mail messages. The following settings are also necessary. Enter the settings as you would for receiving E-mail.\n a. Enter the IP address or the host name*1 of the POP3 server (incoming mail server).\n • An IPv6 address can be entered.\n \n \n \n b. Enter the port number used by the server. (Port 110 is normally used for POP3.)\n \n c. Enter the login ID*2 (user name) required to access the server (max. 63 characters).\n \n d. Enter the password*2 required to access the server (max. 63 characters).\n \n \n \n – [SMTP authentication]: Select this option if the outgoing E-mail server requires SMTP authentication when sending E-mail messages. The following settings are also necessary. Enter the settings as you would for sending E-mail.\n a. Enter the login ID*2 (user name) required to access the server (max. 63 characters).\n \n b. Enter the password*2 required to access the server (max. 63 characters).\n • The camera supports LOGIN, PLAIN, and CRAM-MD5 authentication.\n \n \n \n \n \n \n \n 3. Follow the procedure below based on the settings you made when configuring the trigger.\n a. If you selected to not send notification when the camera is triggered, click [Save], then click [Go to Trigger page].\n \n b. If you selected to send notification when the camera is triggered, click [Next].\n • The appropriate notification settings page is displayed.\n – For E-mail notification, see 2.5.1 Sending Trigger Notifications by E-mail.\n \n – For HTTP notification, see 2.5.2 Sending Trigger Notifications by HTTP.\n \n \n \n \n \n \n \n \n \n \n *1 [Space], [\"], ['], [&], [<], and [>] cannot be entered.\n \n *2 [\"] cannot be entered.\n \n \n");

contentsDictionary["id_om01_0246"] = new ContentsDictionaryEntry("2.4.3 Transferring Images by HTTP", "2.4.3 Transferring Images by HTTP \n The following screen is displayed if you select to transfer images by HTTP while configuring a timer, external sensor, or motion detection trigger (see 2.1 Configuring a Timer Trigger or 2.2 Configuring an Alarm or Motion Detection Trigger). Follow the procedure below to configure the camera to transfer images to an HTTP site. Ask the HTTP server administrator for the appropriate settings.\n Note\n • If your camera’s network uses a proxy server, the appropriate proxy server settings must be made on the [Network (IPv4)] page in order for images to be transferred by HTTP (see 5.1.2 Proxy Server Settings).\n \n \n \n \n \n 1. Set the following parameters as desired.\n a. Enter the URL of the HTTP server (max. 255 characters).\n • An IPv6 address can be entered.\n \n \n \n b. Enter the port number used by the server. (Port 80 is normally used for HTTP.)\n \n c. Enter the login ID*1 (user name) required to access the server (max. 63 characters).\n \n d. Enter the password*1 required to access the server (max. 63 characters).\n \n e. Enter the desired name*1 for transferred files (max. 234 characters). Transferred files will be saved using this file name.\n • You can specify existing directories on the server by entering “\\” before the desired file name. For example, if you enter “CameraImages\\Image”, the camera will upload files to the directory “CameraImages” and save the files using the name “Image”.\n \n \n \n f. Select the desired setting for [Overwrite setting].\n – [Overwrite File]: The file on the server is replaced by the file uploaded by the camera, i.e., only 1 file is saved on the server.\n \n – [Save as New File with Time Stamp]: A time stamp is added to the end of the file name, allowing multiple files to be saved on the server. For example, if you set the file name as “Image”, an uploaded file may be saved as “Image20061231173020500”.\nThe time stamp format is Year/Month/Date/24-hour time/Second/Millisecond.\nTherefore, in this example, the file was captured on December 31, 2006, at 5:30 PM and 20 seconds and 500 milliseconds. Note that if you configure the camera to adjust its time setting for Daylight Saving Time/Summer Time (see 5.4 Setting the Date and Time), an “s” will be inserted between the date and time of the time stamp.\n \n \n \n \n \n 2. Follow the procedure below based on the settings you made when configuring the trigger.\n a. If you selected to not send notification when the camera is triggered, click [Save], then click [Go to Trigger page].\n \n b. If you selected to send notification when the camera is triggered, click [Next].\n • The appropriate notification settings page is displayed.\n – For E-mail notification, see 2.5.1 Sending Trigger Notifications by E-mail.\n \n – For HTTP notification, see 2.5.2 Sending Trigger Notifications by HTTP.\n \n \n \n \n \n \n \n \n \n \n *1 [\"] cannot be entered.\n \n \n");

contentsDictionary["id_om01_0247"] = new ContentsDictionaryEntry("2.5 Configuring the Camera to Send Trigger Notifications", "2.5 Configuring the Camera to Send Trigger Notifications \n When configuring the camera to buffer or transfer images by external sensor, or by the motion detection feature, you can configure the camera to send notifications by E-mail (see 2.5.1 Sending Trigger Notifications by E-mail) or HTTP (see 2.5.2 Sending Trigger Notifications by HTTP) when the camera is triggered.\n Note\n • Notifications cannot be sent when buffering or transferring images by timer.\n \n • You can also send a log of trigger notifications once a day (see 2.10 Sending Alarm Log Information).\n \n \n \n");

contentsDictionary["id_om01_0248"] = new ContentsDictionaryEntry("2.5.1 Sending Trigger Notifications by E-mail", "2.5.1 Sending Trigger Notifications by E-mail \n The following screen is displayed while configuring the camera to buffer or transfer images by external sensor, or by motion detection (see 2.2 Configuring an Alarm or Motion Detection Trigger) if you select [Send E-mail Notification]. Follow the procedure below to send trigger notifications by E-mail. Ask your Internet Service Provider (ISP) or network administrator for the appropriate settings.\n Note\n • To prevent trigger notifications from being sent to the wrong party, make sure you enter the desired destination e-mail addresses correctly.\n \n \n \n \n \n 1. Set the following parameters as desired.\n a. Under [E-mail Notification When Triggered], enter the IP address or the host name*1 of the SMTP server (outgoing mail server).\n • An IPv6 address can be entered.\n \n • This feature cannot transfer images to web-based mail servers, such as Hotmail.\n \n \n \n b. Enter the port number used by the server. (Port 25 is normally used for sending E-mail.)\n \n c. Enter the reply E-mail address*2 that will be shown to the recipient as the sender of the E-mail.\n • In an effort to reduce spam, many ISPs block E-mail sent through the SMTP server from an E-mail address that is not associated with the SMTP server, therefore, we recommend entering the E-mail address assigned to you by your ISP.\n \n \n \n d. Enter the destination E-mail address*2. Up to 3 addresses can be entered.\n \n e. Enter the subject*2 that will be displayed in E-mail messages sent by the camera (max. 44 characters).\n • The date and time (24-hour format) is automatically attached to the subject.\nFor example, if you enter “CameraNotification” as the subject, an E-mail may be sent with the subject “CameraNotification:20061231173020500”.\nThe time stamp format is Year/Month/Date/24-hour time/Second/Millisecond.\nTherefore, in this example, the camera was triggered on December 31, 2006, at 5:30 PM and 20 seconds and 500 milliseconds. Note that if you configure the camera to adjust its time setting for Daylight Saving Time/Summer Time (see 5.4 Setting the Date and Time), an “s” will be inserted between the date and time of the time stamp.\n \n \n \n f. Enter the text*2 that will be displayed in the body of E-mail messages sent by the camera (max. 63 characters).\n • Line breaks cannot be entered.\n \n \n \n \n \n \n \n 2. Under [How to authenticate], select the authentication method your ISP requires for sending E-mail, and enter the appropriate settings if necessary.\n – [No authentication]: Select this option if the outgoing E-mail server does not require authentication when sending E-mail messages.\n \n – [POP before SMTP authentication]: Select this option if the outgoing E-mail server requires POP before SMTP authentication when sending E-mail messages. The following settings are also necessary. Enter the settings as you would for receiving E-mail.\n a. Enter the IP address or the host name*1 of the POP3 server (incoming mail server).\n • An IPv6 address can be entered.\n \n \n \n b. Enter the port number used by the server. (Port 110 is normally used for POP3.)\n \n c. Enter the login ID*2 (user name) required to access the server (max. 63 characters).\n \n d. Enter the password*2 required to access the server (max. 63 characters).\n \n \n \n – [SMTP authentication]: Select this option if the outgoing E-mail server requires SMTP authentication when sending E-mail messages. The following settings are also necessary. Enter the settings as you would for sending E-mail.\n a. Enter the login ID*2 (user name) required to access the server (max. 63 characters).\n \n b. Enter the password*2 required to access the server (max. 63 characters).\n • The camera supports LOGIN, PLAIN, and CRAM-MD5 authentication.\n \n \n \n \n \n \n \n 3. Click [Save], then click [Go to Trigger page].\n \n \n \n \n *1 [Space], [\"], ['], [&], [<], and [>] cannot be entered.\n \n *2 [\"] cannot be entered.\n \n \n");

contentsDictionary["id_om01_0249"] = new ContentsDictionaryEntry("2.5.2 Sending Trigger Notifications by HTTP", "2.5.2 Sending Trigger Notifications by HTTP \n The following screen is displayed while configuring the camera to buffer or transfer images by external sensor, or by motion detection (see 2.2 Configuring an Alarm or Motion Detection Trigger) if you select [Send HTTP Notification]. Follow the procedure below to send trigger notifications by HTTP.\n Note\n • If your camera’s network uses a proxy server, the appropriate proxy server settings must be made on the [Network (IPv4)] page in order for images to be transferred by HTTP (see 5.1.2 Proxy Server Settings).\n \n \n \n \n \n 1. Set the following parameters as desired.\n a. Enter the URL of the HTTP server (max. 255 characters).\n • An IPv6 address can be entered.\n \n \n \n b. Enter the port number used by the server. (Port 80 is normally used for HTTP.)\n \n c. Enter the login ID*1 (user name) required to access the server (max. 63 characters).\n \n d. Enter the password*1 required to access the server (max. 63 characters).\n \n e. Enter the path*1 to the desired CGI file on the server.\n \n \n \n 2. Click [Save], then click [Go to Trigger page].\n \n \n \n \n *1 [\"] cannot be entered.\n \n \n");

contentsDictionary["id_om01_0141"] = new ContentsDictionaryEntry("2.6 Viewing Buffered Images", "2.6 Viewing Buffered Images \n If you have configured the camera to buffer images (see 2.1 Configuring a Timer Trigger or 2.2 Configuring an Alarm or Motion Detection Trigger), you can access the camera and view the buffered images.\n Note\n • If you have configured the camera to transfer images by FTP, E-mail, or HTTP, images are deleted once they have been successfully transferred and you cannot view the images using the procedure described in this section.\n \n • When buffering MPEG-4 videos, the videos cannot be viewed until buffering has ended. Buffering ends in the following situations.\n – When the camera has buffered images by alarm or motion detection for the length of time set for [Image Buffer Frequency].\n \n – When the memory is full (up to 1 minute when buffering images to the internal memory).\n \n – When the buffered file size reaches 20 MB (when buffering images by timer to an SD memory card). When the 20 MB limit is reached, a new file is created. Note that it may take 20 minutes or more for a 20 MB file to be buffered.\n \n \n \n \n \n 1. Click the [Buffered Image] tab.\n • The oldest buffered image for triggers 1–5 are displayed.\n \n • If an image was buffered in MPEG-4 format, a black screen is displayed.\n \n • If a trigger is disabled, or if the trigger has not yet buffered images, a gray screen is displayed.\n \n • Date and time overlays, status overlays, and text overlays may be displayed on buffered images according to the [Overlay Setting] (see 7.1 Changing Image Display Settings). See The single camera page (JPEG) for an example of a camera image overlays.\n \n \n \n \n \n 2. Click the trigger title corresponding to buffered images you want to view.\n \n \n Viewing and downloading buffered JPEG images (videos and still images)\n \n \n A. Start and end date and time when the image was buffered\n \n B. Camera image\n \n C. Date and time when the displayed image was buffered, current image number, and total number of images buffered\n \n D. Playback controls (explained below)\n \n E. Click to select how many images will be downloaded when [Download] is clicked\n \n F. Click to download the selected number of images\n \n \n Playing images\n [Play]: All buffered images are played back in sequence beginning with the current image\n [First] or [Last]: The first or last image is displayed\n [<10000], [<1000], [<100], [<10], [<1]: “Rewinds” by the corresponding number of frames\n [10000>], [1000>], [100>], [10>], [1>]: “Fast-forwards” by the corresponding number of frames\n \n Note\n • Date, time and image number are not displayed during playback.\n \n • The 10× digital zoom feature (see 1.2.7 Zooming) can be used during playback.\n \n • Screen content varies by model number.\n \n \n \n Downloading images\n Select the number of frames you want to download, click [Download], and specify a location on your PC to save the images. The selected number of frames will be downloaded, beginning with the frame currently displayed. You can save every frame beginning with the current frame to the last frame by selecting [remaining]. Images are saved in PNC format. You can view them conveniently using the Network Camera SD Viewer software. This software can be found on the included CD-ROM, and can be installed by following the instructions in the “Read Me” file (CD-ROM Drive:\\NCV\\SDVIEWER_README.txt). You can also download this software from the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html). \n You can also download a still image by right-clicking in the image area and selecting [Save Picture As...].\n \n Note\n • If a large number of images are downloaded from an SD memory card to the PC, it may take several hours for the download process to be completed.\n \n • The number of simultaneous viewing sessions is limited. When the maximum number of accesses has been exceeded (refer to the tables in 1.4 Maximum Number of Viewing Sessions), additional users will see a gray screen.\n \n \n \n \n Viewing and downloading buffered MPEG-4 videos\n \n \n A. Start and end date and time when the image was buffered\n \n B. Camera image\n \n C. Windows Media® Player controls (refer to the Windows Media Player help file for details)\n \n D. Playback controls (explained below)\n \n E. Download button\n \n \n Playing videos\n [Play]: All buffered MPEG-4 files are played back in sequence beginning with the current file\n [First] or [Last]: The first or last file is played back\n [<10000], [<1000], [<100], [<10], [<1]: “Rewinds” by the corresponding number of files\n [10000>], [1000>], [100>], [10>], [1>]: “Fast-forwards” by the corresponding number of files\n \n Note\n • A video file cannot be played back while it is still being recorded.\n \n • When buffering MPEG-4 videos by timer to an SD memory card, the videos can be quite long (several minutes, or even hours, in length). Because it may take a long time to download the video from the camera to your PC, it may take a long time before you are able to play back the buffered video.\n \n • The G.726 audio codec must be downloaded and installed on your PC in order to view buffered videos. Click the link below [If images are not displayed or audio cannot be heard, click here.] to view information and download the codec.\n \n • Date, time and file number are not displayed during playback.\n \n • If you click [Play] to play all MPEG-4 files, playback may stop in the middle of a file when using Windows Vista. In this case, click the play button in Windows Media Player to resume playback.\n \n • Screen content varies by model number.\n \n \n \n Downloading videos\n Click [Download], and specify a location on your PC to save the file. The current video file will be saved on your PC in ASF (Advanced Streaming Format) format, which is a file format used by Windows Media. You can view video files later using Windows Media Player.\n \n Note\n • The maximum length of videos that can be buffered in the memory, as well as the total number of videos that can be buffered in the memory, varies on image resolution, MPEG-4 frame rate and bit rate settings, and the content of the videos being buffered.\n \n • See the Panasonic Network Camera support site (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) for more information about viewing or downloading buffered MPEG-4 videos.\n \n \n \n \n");

contentsDictionary["id_om01_0142"] = new ContentsDictionaryEntry("2.7 Deleting Buffered Images Manually", "2.7 Deleting Buffered Images Manually \n You can delete all images in the memory buffered by a specific trigger.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Buffer/Transfer], click [Trigger].\n \n \n \n 3. Click a trigger number (1–5).\n \n \n \n 4. Click [Delete Buffered Images].\n \n 5. Click [OK].\n \n \n Note\n • The following operations also delete all images buffered in the internal memory.\n – Turning off the camera.\n \n – Saving the Date and Time page.\n \n – Restarting, updating firmware or resetting the camera to factory default.\n \n \n \n \n \n");

contentsDictionary["id_om01_0448"] = new ContentsDictionaryEntry("2.8 Understanding How the Camera Manages Buffered Images", "2.8 Understanding How the Camera Manages Buffered Images \n When images are buffered in the camera’s internal memory\n The camera’s internal memory is divided between the number of triggers that are configured. For example, if 5 triggers are set, each trigger can use 1/5 of the camera’s internal memory, and if 3 triggers are set, each trigger can use 1/3 of the camera’s internal memory, etc. See 14.3 Internal Memory Capacity for Buffered Images for information about the camera’s internal memory capacity.\n For example, when buffering JPEG images at 320 × 240 resolution and standard quality:\n Number of triggers\n 1\n 2\n 3\n 4\n 5\n Maximum number of JPEG images that can be buffered by each trigger (approximate)\n 970\n 480\n 320\n 240\n 190\n \n When you change settings for a trigger, all images buffered in the internal memory for the selected trigger are deleted. Additionally, images buffered for other triggers may also be deleted. When configuring a trigger to buffer or transfer images, it is important to understand how the camera manages buffered images.\n All images for the selected trigger are deleted when:\n – You change the settings for a trigger (image buffer frequency, transfer method, transfer settings, etc.)\n \n – You click [Delete Buffered Images] on the trigger page\n \n \n All images for all triggers are deleted when:\n – You disable or enable a trigger (see 2.3 Disabling and Enabling a Trigger)\n \n – You configure a new trigger (see 2.1 Configuring a Timer Trigger or 2.2 Configuring an Alarm or Motion Detection Trigger)\n \n – You restart the camera (see 9.4 Restarting the Camera)\n \n – You update the camera’s firmware (see 9.5 Updating the Camera’s Firmware and Updating a camera’s firmware)\n \n – You reset the camera to its default settings (see 9.8 Resetting the Camera)\n \n – You change the date and time setting (see 5.4 Setting the Date and Time) \n \n \n When selecting [No Transfer, Memory Overwrite] for buffering JPEG images using alarm or motion detection triggers\n If you want to configure the camera to buffer pre-trigger and post-trigger images, please note the following recommended settings when selecting [No Transfer, Memory Overwrite] for buffering JPEG images using alarm or motion detection triggers.\n When buffering JPEG images at 320 × 240 resolution and standard quality:\n Number of triggers\n 1\n 2\n 3\n 4\n 5\n Maximum number of JPEG images that can be buffered by each trigger (approximate) (“A”) \n 970\n 480\n 320\n 240\n 190\n Recommended maximum number of pre-trigger images (“B”) \n 300\n 160\n 100\n 80\n 60\n Recommended maximum number of post-trigger images (when the number of pre-trigger images shown above is set) (“C”) \n 370\n 160\n 120\n 80\n 70\n Approximate number of images buffered when using the above settings (“D”) \n 670\n 320\n 220\n 160\n 130\n \n Note\n • As a general guideline, the recommended maximum number of pre-trigger images is about 1/3 of the maximum number of images that can be buffered by the trigger.\n(“B” equals or is less than “A”×1/3, as shown above).\n \n • As a general guideline, the number of post-trigger images should not exceed the total number of images that can be buffered by the trigger minus 2 times the number of pre-trigger images.\n(“C” equals or is less than “A”-(2×“B”), as shown above).\n \n • Note that when using the above settings, the actual number of images buffered (“D”) is less than the maximum number of images that can be buffered by the trigger (“A”).\n \n • If the value set for post-trigger images is set too high, pre-trigger images may be overwritten.\n \n • If the value set for pre-trigger images is set too high, images may not be buffered as expected.\n \n \n \n \n \n When images are buffered to an SD memory card\n SD memory card is divided between the number of triggers that are configured. For example, if 5 triggers are set, each trigger can use 1/5 of SD memory card, and if 3 triggers are set, each trigger can use 1/3 of SD memory card, etc. See 14.4 SD Memory Card Capacity for Buffered Images for information about an SD memory capacity. \n All images for the selected trigger are deleted when:\n – You click [Delete Buffered Images] on the trigger page\n \n – You change the image format (JPEG or MPEG-4) setting on the trigger page\n \n \n All images for all triggers are deleted when:\n – You format the SD memory card (see 8.2 Formatting an SD Memory Card)\n \n – You disable or enable a trigger (see 2.3 Disabling and Enabling a Trigger)\n \n – You configure a new trigger (see 2.1 Configuring a Timer Trigger or 2.2 Configuring an Alarm or Motion Detection Trigger)\n \n \n \n");

contentsDictionary["id_om01_0250"] = new ContentsDictionaryEntry("2.9 Adjusting Motion Detection Sensitivity", "2.9 Adjusting Motion Detection Sensitivity \n If using the motion detection feature to buffer or transfer camera images, you may want to adjust the motion detection sensitivity for optimal results.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Buffer/Transfer], click [Motion Detection].\n \n 3. Observe the [Preview] area to confirm how the current settings detect motion.\n • Any changes you make on this page will not be reflected in the [Preview] area until you click [Save].\n \n • You can click on the image in the [Preview] area to use the click to center feature and aim the lens in the desired direction when confirming the current sensitivity settings. \n \n \n \n 4. If necessary, adjust the detection threshold by clicking the appropriate block.\n \n 5. If necessary, adjust the motion sensitivity by clicking the appropriate block.\n \n 6. Click [Save], and then click [Go to Motion Detection page].\n \n 7. Observe the [Preview] area to confirm how the new settings detect motion, and repeat from step 4 if necessary.\n \n \n Understanding [Threshold] and [Sensitivity]\n Motion detection threshold and sensitivity can be adjusted. Understanding how threshold and sensitivity interact will help you adjust the motion detection feature to suit your needs.\n [Threshold]: Determines at what point the motion detection feature is triggered. A lower threshold means less motion is needed to trigger the motion detection feature. A higher threshold means more motion is needed to trigger the motion detection feature. Threshold is indicated in the [Preview] area by the light green area.\n [Sensitivity]: Determines how easily the camera detects motion. Lower sensitivity means the camera is less likely to detect motion. Higher sensitivity means the camera is more likely to detect motion. Motion is indicated in the [Preview] area in dark green when it has not exceeded the detection threshold, and is indicated in dark red when it has exceeded the detection threshold.\n [Preview]: Refer to this area to see how the current settings (effective after clicking [Save]) detect motion.\n The following examples show how [Threshold] and [Sensitivity] are represented in the [Preview] area.\n Example 1\n Parameter\n Display\n Meaning\n [Threshold]\n \n \n Low threshold (A)\n [Sensitivity]\n \n \n Moderate sensitivity (B)\n [Preview]\n \n \n Low threshold (A), no motion is detected \n [Preview]\n \n \n Low threshold (A), low motion (C), motion detection is not triggered \n [Preview]\n \n \n Low threshold (A), moderate (D), motion detection is triggered \n \n Example 2\n Parameter\n Display\n Meaning\n [Threshold]\n \n \n High threshold (A)\n [Sensitivity]\n \n \n Moderate sensitivity (B)\n [Preview]\n \n \n High threshold (A), no motion is detected \n [Preview]\n \n \n High threshold (A), moderate motion (C), motion detection is not triggered \n [Preview]\n \n \n High threshold (A), high motion (D), motion detection is triggered \n \n Note\n • Motion is detected by changes in the outline of objects and changes in object brightness, however, in some cases the camera may detect rapid brightness changes by artificial light sources (such as fluorescent lights) as motion.\n \n • The camera’s motion detection feature detects motion differently than the Network Camera Recorder software (sold separately).\n \n • Motion may not be detected as desired if the object’s color is similar to the color of the background.\n \n • The motion detection feature is disabled when panning, tilting, or using the 4.6× zoom, i.e., moving the camera lens will not trigger the motion detection feature.\n \n • Motion detection can vary by the object, image resolution, or image quality. Refer to the [Preview] area to see how the current settings detect motion.\n \n \n \n \n");

contentsDictionary["id_om01_0220"] = new ContentsDictionaryEntry("2.10 Sending Alarm Log Information", "2.10 Sending Alarm Log Information \n You can configure the camera to send a daily log by E-mail that reports the status of the external sensor and motion detection triggers. This allows you to be notified by E-mail once a day and know whether or not there were any events that triggered the camera. Ask your Internet Service Provider (ISP) or network administrator for the appropriate settings.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Buffer/Transfer], click [Alarm Log].\n \n \n \n 3. Set the following parameters as desired.\n a. Under [A setup of operation], select the desired setting.\n – [Never send alarm logs]: Alarm logs will not be sent.\n \n – [Always send alarm logs]: Alarm logs will be sent, even if the camera was not triggered.\n \n – [Send alarm logs only when the camera was triggered]: Alarm logs will be sent if the camera was triggered.\n \n – [Send alarm logs only when the camera was not triggered]: Alarm logs will be sent only if the camera was not triggered.\n \n \n \n b. Under [Active Time], select the days and the time you want the camera to send alarm logs.\n \n c. Under [Notice setup of an alarm log], enter the IP address or the host name*1 of the SMTP server (outgoing mail server).\n • An IPv6 address can be entered.\n \n • This feature cannot transfer images to web-based mail servers, such as Hotmail.\n \n \n \n d. Enter the port number used by the server. (Port 25 is normally used for sending E-mail.)\n \n e. Enter the reply E-mail address*2 that will be shown to the recipient as the sender of the E-mail.\n • In an effort to reduce spam, many ISPs block E-mail sent through the SMTP server from an E-mail address that is not associated with the SMTP server, therefore, we recommend entering the E-mail address assigned to you by your ISP.\n \n \n \n f. Enter the destination E-mail address*2. Up to 3 addresses can be entered.\n \n g. Enter the subject*2 that will be displayed in E-mail messages sent by the camera (max. 44 characters).\n \n \n \n \n \n 4. Under [How to authenticate], select the authentication method your ISP requires for sending E-mail, and enter the appropriate settings if necessary.\n – [No authentication]: Select this option if the outgoing E-mail server does not require authentication when sending E-mail messages.\n \n – [POP before SMTP authentication]: Select this option if the outgoing E-mail server requires POP before SMTP authentication when sending E-mail messages. The following settings are also necessary. Enter the settings as you would for receiving E-mail.\n a. Enter the IP address or the host name*1 of the POP3 server (incoming mail server).\n • An IPv6 address can be entered.\n \n \n \n b. Enter the port number used by the server. (Port 110 is normally used for POP3.)\n \n c. Enter the login ID*2 (user name) required to access the server (max. 63 characters).\n \n d. Enter the password*2 required to access the server (max. 63 characters).\n \n \n \n – [SMTP authentication]: Select this option if the outgoing E-mail server requires SMTP authentication when sending E-mail messages. The following settings are also necessary. Enter the settings as you would for sending E-mail.\n a. Enter the login ID*2 (user name) required to access the server (max. 63 characters).\n \n b. Enter the password*2 required to access the server (max. 63 characters).\n • The camera supports LOGIN, PLAIN, and CRAM-MD5 authentication.\n \n \n \n \n \n \n \n 5. Click [Save], then click [Go to Alarm Log page].\n \n \n Note\n • When the settings are saved, the number of new alarm logs becomes 0.\n \n \n \n \n \n *1 [Space], [\"], ['], [&], [<], and [>] cannot be entered.\n \n *2 [\"] cannot be entered.\n \n \n");

contentsDictionary["id_om01_0468"] = new ContentsDictionaryEntry("2.11 Recording to an SD Memory Card Without Using a PC", "2.11 Recording to an SD Memory Card Without Using a PC \n You can record camera images to an SD memory card without connecting the camera to a network and without configuring the camera using a PC. 6 preprogrammed image recording triggers are available, allowing you to choose the conditions during which images will be recorded. You can view recorded images by removing the SD memory card from the camera and accessing it with a PC.\n For more information, see the Stand-alone SD Memory Card Recording Guide on the included CD-ROM.\n");

contentsDictionary["id_om01_0252"] = new ContentsDictionaryEntry("Section 3 Mobile Phone Features", "Section 3 Mobile Phone Features \n This section describes the features available when using a mobile phone that is compatible with Panasonic Network Cameras. Before using any of these features, please read the following notes.\n • Certain mobile phones are not compatible with Panasonic Network Cameras.\n \n • Mobile phones that only allow the use of port number 80 or mobile phones that do not support password authentication are not compatible with Panasonic Network Cameras.\n \n • Certain mobile phones may not display images correctly.\n \n • Video images cannot be displayed on mobile phones.\n \n • The camera’s audio features are not available with mobile phones.\n \n \n");

contentsDictionary["id_om01_0253"] = new ContentsDictionaryEntry("3.1 Accessing the Camera from Your Mobile Phone", "3.1 Accessing the Camera from Your Mobile Phone \n 1. Enter http:// followed by the IP address of the camera and /mobile, then access the camera.\n Example: http://***.***.***.***/mobile \n • If the camera’s port number is a port number other than 80, enter “:” and the port number after the IP address.\n Example: http://***.***.***.***:50001/mobile \n \n • If you have registered with a DNS service, such as Viewnetcam.com (see 4.2.1 Configuring the Camera to Use Viewnetcam.com), enter the URL instead of the IP address.\n Example: http://***.viewnetcam.com \n \n • If the camera is configured to use HTTPS (see 5.2 HTTPS Settings), enter https:// followed by the IP address or host name and the port number of the camera. Note, however, that certain mobile phones do not support HTTPS connections.\n Example: https://***.***.***.***:80/mobile \n Example: https://***.viewnetcam.com:80/mobile \n \n \n \n 2. If an authentication dialog is displayed, enter the user name and password.\n • A still image from the camera is displayed.\n \n • If the camera image is not displayed properly, try accessing the camera by entering one of the following instead of /mobile.\n – /mobileh (for HTML)\n \n – /mobilex (for XHTML)\n \n \n \n \n \n \n Note\n • If the camera is configured to allow access from guest users (i.e, anonymous users; see 6.4 Guest Users), users can access the camera’s mobile phone pages using a mobile phone or PC without entering a user name or password.\n \n \n \n");

contentsDictionary["id_om01_0223"] = new ContentsDictionaryEntry("3.2 Viewing Still Images on Your Mobile Phone", "3.2 Viewing Still Images on Your Mobile Phone \n Still images from the camera can be viewed with a compatible mobile phone.\n \n \n A. Press [4] or [6] to pan the lens left or right, respectively, or press [2] or [8] to tilt the lens up or down, respectively. When the lens has reached the end of its pan or tilt range, the corresponding number will not be displayed.\n \n B. Press [*] or [#] to use the 4.6× zoom feature to zoom in or out, respectively. When the lens has reached the end of its zoom range, the corresponding character will not be displayed.\n \n C. Press [5] to refresh the image.\n \n D. Press [0] to toggle between the available image resolutions (192 × 144 and 320 × 240). You can set the default image resolution for when viewing with your mobile phone (see 7.1 Changing Image Display Settings).\n \n E. Select [Home Position] to move the lens to the home position.\n \n F. Press [1], [3], [7] or [9] to move the lens to the first four presets (presets 1–4).\n \n G. For presets 5–20, select the corresponding preset name to move the lens to the desired position.\n \n H. Controls the output signals of the external I/O interface (see 7.4 Controlling the External Output Terminal).\n \n I. Select [Alarm Log] to view the last 50 external sensor and motion detection trigger logs (see 3.3 Viewing Alarm Logs on Your Mobile Phone).\n • You must be logged in to the camera as an administrator to use this feature.\n \n \n \n J. Select [Buffer/Transfer] to view the image buffer and transfer control page (see 3.4 Enabling and Disabling Image Buffering Using Your Mobile Phone).\n • You must be logged in to the camera as an administrator to use this feature.\n \n \n \n \n \n Note\n • When accessing the camera as a general user or as a guest user, certain features may be disabled according to the [Access Level] set for the user (see Creating or modifying a general user account and Changing the features available to guest users).\n \n • If the camera is configured to allow access from guest users (i.e, anonymous users; see 6.4 Guest Users), users can access the camera’s mobile phone pages using a mobile phone or PC without entering a user name or password. If guest user access is permitted, you can log in as the administrator by selecting [Alarm Log] and [Buffer/Transfer], and then entering the user name and password when the authentication dialog is displayed.\n \n \n \n");

contentsDictionary["id_om01_0224"] = new ContentsDictionaryEntry("3.3 Viewing Alarm Logs on Your Mobile Phone", "3.3 Viewing Alarm Logs on Your Mobile Phone \n While accessing the camera from your mobile phone, select [Alarm Log] to view a record of the last 50 trigger events (external sensor and motion detection). These logs allow you to confirm the date, time, and type (external sensor 1, external sensor 2, or motion detection) of the last 50 times the camera was triggered.\n Note\n • You must be logged in to the camera as an administrator to use this feature.\n \n \n \n 1. Access the camera with your mobile phone (see 3.1 Accessing the Camera from Your Mobile Phone).\n \n 2. Select [Alarm Log].\n \n 3. Confirm the alarm logs as necessary.\n \n 4. Select [Control Page] when finished to return to the previous screen.\n \n \n \n \n A. Returns to the previous screen.\n \n B. The number of new alarm logs is displayed.\n \n C. The date and time of each log, and the type of each trigger is displayed.\n • The date is displayed in MM/DD format.\n \n • The time is displayed in 24-hour format.\n \n • [MD] indicates a motion detection.\n \n • [A1] indicates an external sensor 1 detection.\n \n • [A2] indicates an external sensor 2 detection.\n \n • [R] indicates [Rising: GND to Open (High).] signal type.\n \n • [F] indicates [Falling: Open (High) to GND.] signal type.\n \n \n \n \n \n");

contentsDictionary["id_om01_0225"] = new ContentsDictionaryEntry("3.4 Enabling and Disabling Image Buffering Using Your Mobile Phone", "3.4 Enabling and Disabling Image Buffering Using Your Mobile Phone \n While accessing the camera from your mobile phone, select [Buffer/Transfer] to display the image buffer and transfer control page on your mobile phone.\n Note\n • You must be logged in to the camera as an administrator to use this feature.\n \n \n \n 1. Access the camera with your mobile phone (see 3.1 Accessing the Camera from Your Mobile Phone).\n \n 2. Select [Buffer/Transfer].\n \n 3. Select the desired trigger number to turn the trigger on or off.\n \n \n \n 4. Select [Save] to turn the selected trigger on or off.\n \n \n • All images buffered in the memory are deleted when you click [Save].\n \n \n \n 5. Select [Control Page] when finished to return to the previous screen.\n \n \n");

contentsDictionary["id_om01_0276"] = new ContentsDictionaryEntry("Section 4 Configuring the Camera for Access from the Internet", "Section 4 Configuring the Camera for Access from the Internet \n You can configure the camera to be accessed over the Internet, allowing you to view camera images and change camera settings from anywhere—even using your mobile phone. This section explains the concepts and procedures for configuring your camera (and other network devices) to allow you to view camera images over the Internet.\n Before you can configure the camera for access from the Internet, it is necessary to understand how IP addresses and Internet connections work.\n Note\n • To configure the camera to be accessed over the Internet using IPv6, see 11.5 Allowing IPv6 Access from the Internet.\n \n \n \n Understanding local addresses\n Each device connected to your computer network (PCs, router, network printers, network cameras, etc.) has an IP address. It probably looks something like this: 192.168.0.100. Each IP address on your network must be unique, as shown in the example below.\n In this example, you would enter 192.168.0.253 or 192.168.0.252 in your web browser’s address bar to access your cameras with your PC.\n \n \n A\n Internet\n B\n Modem\n C\n Router\n \n Although each IP address on your network must be unique, the addresses are unique only to your network. In other words, your cameras and your neighbor’s cameras may have the same IP addresses. In the example below, the addresses of your devices (on the left) and the addresses of your neighbor’s devices (on the right) are the same, but this is not a problem because the cameras are not connected to the same network.\n \n \n IP addresses that distinguish different devices on the same LAN (local area network, i.e., personal network) are called local IP addresses. The IP addresses in the examples above are local IP addresses.\n So how can you access your camera when you are away from home if other people are using the same IP address as your camera?\n \n Understanding global addresses\n The answer is to access the camera by entering the unique IP address assigned to you by your Internet Service Provider (ISP). This address is called a global address, or a WAN (wide area network) address. In the example below, your global IP address is aaa.aaa.aaa.aaa and your neighbor’s global IP address is zzz.zzz.zzz.zzz.\n • Note that an actual IP address is made of numbers, not letters. \n \n \n \n \n When you are away from home, you can access your router by entering aaa.aaa.aaa.aaa. But now you have another problem—you don’t want to access your router, you want to access the cameras connected to your routers.\n \n Understanding port numbers\n Data is sent between devices on a network using different ports depending on what kind of data is being sent. A port is not a physical object; it is a piece of information in the data that helps the data be directed to the intended device. In the example below, the port numbers 50000 and 50001 are assigned to your cameras.\n \n \n By assigning unique port numbers to your cameras, you can access your cameras when you are away from home by entering aaa.aaa.aaa.aaa:50000 or aaa.aaa.aaa.aaa:50001 in the web browser of a PC. When your router receives information via its global IP address, it passes it on to one of your cameras depending on which port number you entered after the global IP address.\n But how does your router know which camera to pass information to?\n \n Understanding port forwarding\n If your router supports a feature called port forwarding (sometimes it’s called address translation, static IP masquerade, virtual server, port mapping, or other names, depending on the router manufacturer), the router can be set up to take information it receives on specific ports and pass it on to a specific IP address.\n The port forwarding settings needed for the example above would look something like this:\n Port No. of Incoming Access\n Forwarding Destination\n 50000 \n 192.168.0.253:50000 \n 50001 \n 192.168.0.252:50001 \n \n Now you may be thinking, “do I have to do this programming by myself?”\n \n Understanding UPnP™\n If your router does not support a feature called UPnP™ (Universal Plug and Play), you will have to manually configure your router for port forwarding. Refer to the operating instructions included with your router for more information.\n If your router does support UPnP™, your cameras and router can communicate with each other so that the router knows which ports are used by which camera. This means you will be able to access your cameras from the Internet without having to configure your router manually.\n \n Understanding Dynamic DNS services\n There is one last problem to solve. How do you find out the global address your ISP has assigned to you? The answer is to first contact them. If your provider has assigned you a static IP address (i.e., an IP address that never changes), you can use that static address to access your cameras from the Internet as long as your router is set up for port forwarding.\n But most service providers use dynamic addresses, which means your global address may change monthly, weekly, or maybe even every day. If your provider uses dynamic addresses, you will need to register with a Dynamic DNS service in order to access your camera from the Internet.\n A Dynamic DNS service allows you to use an easy-to-remember address (such as ***.viewnetcam.com) to access your camera from the Internet. If you have subscribed to a Dynamic DNS service and configured your camera to use that Dynamic DNS service, your camera will notify the Dynamic DNS service each time your provider changes your global IP address. This means your Dynamic DNS service always knows your current global address, so whenever you enter your easy-to-remember address, the Dynamic DNS service automatically passes the information on to your router, and ultimately, your camera.\n Example of how a Dynamic DNS service helps you access your camera over the Internet\n \n \n A\n Internet\n B\n ISP\n C\n Dynamic DNS Service\n D\n DNS Server\n \n 1. Your ISP assigns a new global IP address to your Internet access account.\n \n 2. The camera notifies your Dynamic DNS service of its new global IP address.\n \n 3. The Dynamic DNS service notifies the DNS server of your new global IP address. The DNS server updates its information so that your URL (for example, ***.viewnetcam.com) is registered to your new global IP address.\n \n 4. You try to access your camera from outside (i.e., over the Internet) by entering ***.viewnetcam.com.\n \n 5. The computer contacts the DNS server and requests the global IP address registered to ***.viewnetcam.com. The DNS server looks up the global IP address of your URL.\n \n 6. The computer receives your current global IP address from the DNS server and accesses the camera.\n \n \n \n Summary\n In order to access your camera over the Internet, you need to do the following.\n 1. Configure your router for port forwarding. If your router supports UPnP™, this can be done automatically. Refer to the operating instructions included with your router for information on UPnP™ support (the router’s UPnP™ feature may be turned off by default) or for information on setting port forwarding.\n \n 2. If your ISP has assigned you a dynamic global IP address, register with a Dynamic DNS service. We recommend using Viewnetcam.com, a Dynamic DNS service that is designed for use with Panasonic Network Cameras. (For more information, refer to the Viewnetcam.com website at http://www.viewnetcam.com.)\n \n 3. After you have registered with a Dynamic DNS service, configure the camera to use that service.\n \n \n \n");

contentsDictionary["id_om01_0331"] = new ContentsDictionaryEntry("4.1 Configuring Port Forwarding", "4.1 Configuring Port Forwarding \n In order to access your camera from the Internet, you will need to configure your router for port forwarding. If your router supports UPnP™ (Universal Plug and Play), the camera and router can communicate with each other and set port forwarding automatically. This can be done during initial configuration (as explained in the Setup Guide), or by following one of the procedures below.\n There are two methods you can use to configure port forwarding via UPnP™.\n – Using the [Internet] tab (recommended)\n Using this method, the camera’s current port number may change. The camera will be assigned a port number that is not currently used by another device on the network. If port 80 is unavailable, the camera will be assigned the first available port number between 50000 and 50050.\n To use this method, see Enabling [Auto Port Forwarding] using the [Internet] tab.\n \n – Using the [UPnP] page\n Using this method, the camera’s port number will not change.\n To use this method, see Enabling [Auto Port Forwarding] using the [UPnP] page.\n \n \n Note\n • If your router does not support UPnP™, you need to configure the router’s port forwarding feature manually. See Configuring port forwarding without using UPnP™.\n \n • If your router’s UPnP™ feature is turned off (most routers have UPnP™ turned off by default), you need to turn it on in order to configure port forwarding automatically. Refer to the operating instructions included with your router and the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) for more information.\n \n • If you have a PPPoE or PPTP connection to your Internet Service Provider, disable your router’s maximum idle time setting. Refer to the operating instructions included with your router for more information.\n \n • UPnP™ features are available when using the camera in IPv4. The camera does not support UPnP™ for IPv6 connections.\n \n \n \n Enabling [Auto Port Forwarding] using the [Internet] tab\n 1. Click the [Internet] tab.\n \n \n \n 2. Under [Auto Port Forwarding (IPv4)], select [Enable].\n \n 3. Click [Save].\n • A notice is displayed informing you that the camera’s port number may change.\n \n \n \n 4. Click [OK].\n • [Router configuration in progress to allow access from the Internet.] is displayed.\n \n • If you want to register with Viewnetcam.com (visit http://www.viewnetcam.com for details), select [Register with Viewnetcam.com] before clicking [Save]. Click [Go to Viewnetcam.com Registration page] when this button is displayed. The Viewnetcam.com website will open in a new window. Follow the on-screen instructions to register with Viewnetcam.com.\n \n • When [Setup completed] is displayed, the addresses for accessing the camera over the LAN and over the Internet are displayed.\n \n \n \n 5. Click [To Single Camera page].\n \n 6. Confirm that port forwarding was configured correctly (see Confirming that UPnP™ port forwarding is configured correctly).\n \n \n Note\n • If you have multiple cameras connected to the same network, only one of the cameras needs to be registered with Viewnetcam.com. All cameras connected to the network can be accessed from the Internet using your Viewnetcam.com URL (for example, ***.viewnetcam.com) and adding the desired camera’s port number after the URL. Example: http://***.viewnetcam.com:50000, http://***.viewnetcam.com:50001, etc. Note, however, if the camera that is registered to Viewnetcam.com is turned off and your ISP-provided global IP address changes, you will not be able to access any of the cameras.\n \n • To disable Viewnetcam.com service for this camera later, access the Viewnetcam.com website (http://www.viewnetcam.com) and cancel your registration.\n \n • If auto port forwarding is enabled or disabled on this page, it is also enabled or disabled on the [UPnP] page.\n \n \n \n \n Enabling [Auto Port Forwarding] using the [UPnP] page\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [UPnP].\n \n \n \n 3. Under [Auto Port Forwarding], select [Enable].\n \n 4. Click [Save].\n • When setup is complete, [Success!] is displayed.\n \n \n \n 5. Confirm that port forwarding was configured correctly (see Confirming that UPnP™ port forwarding is configured correctly).\n \n \n Note\n • If auto port forwarding is enabled or disabled on this page, it is also enabled or disabled on the [Internet] tab.\n \n \n \n \n Confirming that UPnP™ port forwarding is configured correctly\n To confirm that the UPnP™ port forwarding has been successfully configured, follow the procedure below.\n 1. Click the [Maintenance] tab.\n \n 2. On the left side of the screen, click [Status].\n \n 3. Under [UPnP], confirm that the status is [Enabled].\n • If [Enabled] is not displayed, refer to the UPnP™ related items in 1.3 Camera Setup Issues and 1.4 Camera Access Issues in the Troubleshooting Guide.\n \n \n \n \n \n Configuring port forwarding without using UPnP™\n If your router does not support UPnP™, you need to configure the router’s port forwarding feature manually.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [Network (IPv4)].\n \n 3. Under [Connection Mode], click [Static].\n \n 4. Make a note of the IP address and port number displayed here. You will need to know these settings when configuring the router for port forwarding.\n \n 5. Click [Save].\n \n 6. Click [Restart].\n \n 7. While referring to the operating instructions included with your router, configure the router’s port forwarding feature.\n • When configuring port forwarding, store the camera’s IP address and port number that you noted above.\n \n \n \n 8. Register the camera to use a Dynamic DNS service, such as Viewnetcam.com (see 4.2.1 Configuring the Camera to Use Viewnetcam.com).\n \n \n \n");

contentsDictionary["id_om01_0326"] = new ContentsDictionaryEntry("4.2 Configuring the Camera to Use a Dynamic DNS Service", "4.2 Configuring the Camera to Use a Dynamic DNS Service \n You can configure the camera to use Viewnetcam.com (see 4.2.1 Configuring the Camera to Use Viewnetcam.com) or a third-party Dynamic DNS service (see 4.2.2 Configuring the Camera to Use a Third-party Dynamic DNS Service).\n A Dynamic DNS service is a service that allows you to assign an easy-to-remember URL (web address) to the camera, such as ***.viewnetcam.com, allowing you to access the camera from the Internet using your personalized URL. A Dynamic DNS service also allows you to easily access the camera, even when your Internet Service Provider changes your IP address, because the camera periodically contacts the Dynamic DNS service and notifies the service of its current address.\n If you are interested in accessing your camera over the Internet, we recommend using a Dynamic DNS service, such as Viewnetcam.com. For more information about Viewnetcam.com, please visit http://www.viewnetcam.com for details.\n");

contentsDictionary["id_om01_0327"] = new ContentsDictionaryEntry("4.2.1 Configuring the Camera to Use Viewnetcam.com", "4.2.1 Configuring the Camera to Use Viewnetcam.com \n If you are interested in accessing your camera over the Internet, we recommend using Viewnetcam.com. Viewnetcam.com is a Dynamic DNS service designed for use with Panasonic Network Cameras. For more information about Viewnetcam.com, please visit http://www.viewnetcam.com for details.\n There are two methods you can use to configure the camera to use Viewnetcam.com.\n – Using the [Internet] tab (recommended)\n To use this method, see Configuring the camera to use Viewnetcam.com from the [Internet] tab.\n \n – Using the [DynamicDNS] page\n To use this method, see Configuring the camera to use Viewnetcam.com from the [DynamicDNS] page.\n \n \n Note\n • If your router supports UPnP™ and you want to enable auto port forwarding as well as use Viewnetcam.com, use the procedure described in Enabling [Auto Port Forwarding] using the [Internet] tab.\n \n • If you have multiple cameras connected to the same network, only one of the cameras needs to be registered with Viewnetcam.com. All cameras connected to the network can be accessed from the Internet using your Viewnetcam.com URL (for example, ***.viewnetcam.com) and adding the desired camera’s port number after the URL. Example: http://***.viewnetcam.com:50000, http://***.viewnetcam.com:50001, etc. Note, however, if the camera that is registered to Viewnetcam.com is turned off and your ISP-provided global IP address changes, you will not be able to access any of the cameras.\n \n • To disable Viewnetcam.com service for this camera later, access the Viewnetcam.com website (http://www.viewnetcam.com) and cancel your registration.\n \n • It may take up to 30 minutes before the camera can be accessed over the Internet.\n \n \n \n Configuring the camera to use Viewnetcam.com from the [Internet] tab\n 1. Click the [Internet] tab.\n \n \n \n 2. Under [Viewnetcam.com Registration], select [Register with Viewnetcam.com].\n \n 3. Click [Save].\n \n 4. When [Setup completed] is displayed, click [Go to Viewnetcam.com Registration page].\n • The Viewnetcam.com website is displayed. Follow the on-screen instructions to register with Viewnetcam.com.\n \n • When [Setup completed] is displayed, the addresses for accessing the camera over the LAN and over the Internet are displayed.\n \n \n \n 5. Click [To Single Camera page].\n \n \n \n Configuring the camera to use Viewnetcam.com from the [DynamicDNS] page\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [DynamicDNS].\n \n \n \n 3. Select [Viewnetcam.com], then click [Next].\n \n \n \n 4. Click [Save].\n • When setup is complete, [Success!] is displayed.\n \n \n \n 5. Click [Go to Viewnetcam.com page].\n \n \n \n 6. Click [Your Account Link].\n \n 7. The Viewnetcam.com website is displayed. Follow the on-screen instructions to register with Viewnetcam.com.\n • If the Viewnetcam.com website is not displayed, confirm that your PC can access the Internet, then click your web browser’s refresh button.\n \n • When registration is complete, you can access the camera using the Viewnetcam.com URL you selected during registration. Note that you can access the camera using this URL only from a PC that is not connected to the same network (LAN) as the camera.\n \n \n \n \n Note\n • If you have already registered with Viewnetcam.com, your personalized URL is displayed. This is the address you can use to access the camera over the Internet. You can also access the URL displayed next to [Your Account Link] to view your Viewnetcam.com registration information.\n \n • If [Your Account Link] is not displayed, confirm that you have registered with Viewnetcam.com and that your PC can access the Internet, then click your web browser’s refresh button.\n \n • Typically [Global IP Address Notification Method] should be set to [Normal]. If you cannot access the camera using the registered URL 30 minutes after registering with Viewnetcam.com, select [Advanced]. In this case, UPnP must be enabled for the camera and for the router.\n \n \n \n \n Confirming your Viewnetcam.com registration\n You can confirm that the camera has been successfully registered to Viewnetcam.com.\n 1. Click the [Maintenance] tab.\n \n 2. On the left side of the screen under [Maintenance], click [Status].\n \n 3. Under [Viewnetcam.com], confirm that [Enabled (2)] is displayed.\n \n \n Note\n • If the status is displayed as [Expired], confirm that you have registered with Viewnetcam.com, or restart the camera and access this page again.\n \n \n \n \n Changing the Viewnetcam.com address update time\n You can select how often the camera notifies the Viewnetcam.com server of its current global IP address.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [DynamicDNS].\n \n 3. Select [Viewnetcam.com], then click [Next].\n \n 4. Select the desired setting for [Updating time].\n \n 5. Click [Save].\n \n \n \n");

contentsDictionary["id_om01_0339"] = new ContentsDictionaryEntry("4.2.2 Configuring the Camera to Use a Third-party Dynamic DNS Service", "4.2.2 Configuring the Camera to Use a Third-party Dynamic DNS Service \n Before configuring the camera to use a third-party Dynamic DNS service, you will first need to subscribe to the desired service. Ask the Dynamic DNS service provider for the settings required to use that service.\n Note\n • Certain third-party Dynamic DNS services may not be compatible with your camera. We cannot guarantee that your camera will be compatible with third-party Dynamic DNS services, and therefore we cannot take responsibility for any damage or performance issues that may occur when using a Dynamic DNS service other than Viewnetcam.com (see 4.2.1 Configuring the Camera to Use Viewnetcam.com).\n \n • Please direct any questions you may have regarding the settings required to use a third-party Dynamic DNS service to the Dynamic DNS service provider.\n \n • After configuring the camera to use a third-party Dynamic DNS service, it may take several minutes before the camera can be accessed over the Internet.\n \n \n \n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [DynamicDNS].\n \n \n \n 3. Select [User-specified DynamicDNS], then click [Next].\n \n \n \n 4. Enter the URL (including http://)*1 provided or required by your Dynamic DNS service provider (max. 255 characters).\n \n 5. Select how often the camera notifies the Dynamic DNS service of its current global IP address.\n \n 6. Enter the user name*2 provided by the Dynamic DNS service provider (max. 63 characters).\n \n 7. Enter the password*2 provided by the Dynamic DNS service provider (max. 63 characters).\n \n 8. Click [Save].\n \n \n \n \n *1 [Space] and [\"] cannot be entered.\n \n *2 [\"] and [:] cannot be entered.\n \n \n Canceling the camera’s access to the Dynamic DNS service\n Use the following procedure to stop the camera from notifying the Dynamic DNS service when your global IP address changes. Note that if you intend to stop using the Dynamic DNS service altogether, you may need to contact the Dynamic DNS service provider in order to cancel your subscription. \n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [DynamicDNS].\n \n \n \n 3. Select [Disable], then click [Save].\n \n \n \n");

contentsDictionary["id_om01_0333"] = new ContentsDictionaryEntry("4.3 Confirming Internet Access", "4.3 Confirming Internet Access \n After configuring the camera to use a Dynamic DNS service and configuring your router for port forwarding, confirm that the camera can be accessed over the Internet.\n Most routers will not allow you to access a camera over the Internet using a PC connected to the same LAN as the camera. To confirm that the camera can be accessed over the Internet, try accessing the camera using a PC connected to a different network or by using your mobile phone (see 3.1 Accessing the Camera from Your Mobile Phone).\n");

contentsDictionary["id_om01_0254"] = new ContentsDictionaryEntry("Section 5 Changing Camera Settings", "Section 5 Changing Camera Settings \n");

contentsDictionary["id_om01_0255"] = new ContentsDictionaryEntry("5.1 Network Settings", "5.1 Network Settings \n The camera’s network settings are made when configuring the camera according to the instructions provided in the Setup Guide. You can change these settings later if necessary using the procedures described in this section.\n Note\n • You must log in to the camera as the administrator in order to change these settings.\n \n • After changing network settings and clicking [Save], the camera must be restarted. All images buffered in the internal memory are deleted when the camera is restarted.\n \n • Ask your Internet Service Provider or network administrator for the appropriate network settings.\n \n • If you cannot access the camera after changing certain network settings, use the Setup Program to confirm the camera’s IP address (see Finding cameras on the LAN) or reconfigure the camera as explained in the Setup Guide.\n \n • If your network uses the IPv6 protocol, see Section 11 Using IPv6.\n \n \n \n");

contentsDictionary["id_om01_0329"] = new ContentsDictionaryEntry("5.1.1 Network (IPv4) Settings", "5.1.1 Network (IPv4) Settings \n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [Network (IPv4)].\n \n \n \n 3. Select the desired connection mode, then make the appropriate settings as described in this section.\n – [Automatic Setup]: Allows the camera to automatically obtain the appropriate network settings from your broadband router or from your Internet Service Provider (ISP). The camera also searches for an unused IP address on your network.\n \n – [Static]: Allows you to set all network settings manually.\n \n – [DHCP]: Allows you to specify your network settings (if necessary), after which the camera obtains an IP address automatically from the DHCP feature of your broadband router or from your ISP.\n \n \n \n \n [Automatic Setup]\n \n \n 1. Set the following parameters as desired.\n a. Under [Max. Bandwidth Usage], select the maximum bandwidth you want to allow the camera to use.\n \n b. Under [Connection Type], select the appropriate connection type.\n • Normally you can leave this setting at [Auto Negotiation].\n \n \n \n \n \n 2. Click [Save].\n \n 3. When the [New settings are saved.] message is displayed, click [Restart].\n \n \n Note\n • If the camera’s IP address was changed as a result of changing the network settings, use the Setup Program on the CD-ROM to find the camera’s new IP address (see Finding cameras on the LAN).\n \n • The current network settings can be confirmed on the [Status] page (see 9.1 Confirming Camera Status).\n \n \n \n \n [Static]\n \n \n 1. Set the following parameters as desired.\n a. Under [Network Configuration from Setup Program], select whether or not you want to allow the camera to be configured using the Setup Program on the CD-ROM.\n \n b. Under [Internet Connection], enter the port number to be assigned to the camera.\n • The default port number is 80, however, note that some ISPs do not allow access from the Internet using port 80. Ask your ISP or network administrator about which port numbers are available for access over the Internet.\n \n • Do not use the following port numbers:\n – 20 and 21: used for FTP\n \n – 23: used for Telnet\n \n – 25: used for SMTP\n \n – 53: used for DNS\n \n – 110: used for POP3\n \n – 443: used for HTTPS\n \n – 4000: used for ICQ\n \n – 6661–6667: used for IRC\n \n \n \n • If you are connecting multiple cameras and plan on using port forwarding to allow Internet access to the cameras, assign a different port number to each camera. We recommend using port numbers in the 50000–50050 range.\n \n \n \n c. Enter the IP address to be assigned to the camera.\n • Assign an IP address that belongs to the same class as other network devices (router, PCs, etc.) on the local area network. For example, if your router’s address is 192.168.0.1, you can assign an IP address between 192.168.0.2 and 192.168.0.254 as long as the assigned address is not used by another network device.\n \n \n \n d. Enter the appropriate subnet mask.\n • Confirm the subnet mask assigned to your router or PC. You can enter the same value here.\n \n \n \n e. Under [Default Gateway], enter the IP address of your router or the default gateway IP address provided by your ISP or network administrator.\n \n f. Under [DNS], enter the IP addresses of the primary and secondary DNS servers provided by your ISP or network administrator.\n \n g. Under [Max. Bandwidth Usage], select the maximum bandwidth you want to allow the camera to use.\n • This setting is effective for both IPv4 and IPv6 connections.\n \n • Refer to the following file size information when restricting the maximum bandwidth. Note that these are estimated file sizes; the actual file size may vary depending on image quality, image brightness, etc.\n – 192 × 144: 7 KB (56 Kbit)\n \n – 320 × 240: 16 KB (128 Kbit)\n \n – 640 × 480: 35 KB (280 Kbit)\n \n \n \n \n \n h. Under [Connection Type], select the appropriate connection type.\n • Normally you can leave this setting at [Auto Negotiation].\n \n • This setting is effective for both IPv4 and IPv6 connections.\n \n \n \n \n \n 2. Click [Save].\n \n 3. When the [New settings are saved.] message is displayed, click [Restart].\n • All images buffered in the internal memory are deleted when the camera is restarted.\n \n \n \n \n Note\n • To access the camera again, use the IP address you assigned to the camera in this procedure.\n \n • The current network settings can be confirmed on the [Status] page (see 9.1 Confirming Camera Status).\n \n \n \n \n [DHCP]\n \n \n 1. Set the following parameters as desired.\n a. Under [Network Configuration from Setup Program], select whether or not you want to allow the camera to be configured using the Setup Program on the CD-ROM.\n \n b. Under [Internet Connection], enter the port number to be assigned to the camera.\n • The default port number is 80, however, note that some ISPs do not allow access from the Internet using port 80. Ask your ISP or network administrator about which port numbers are available for access over the Internet.\n \n • Do not use the following port numbers:\n – 20 and 21: used for FTP\n \n – 23: used for Telnet\n \n – 25: used for SMTP\n \n – 53: used for DNS\n \n – 110: used for POP3\n \n – 443: used for HTTPS\n \n – 4000: used for ICQ\n \n – 6661–6667: used for IRC\n \n \n \n • If you are connecting multiple cameras and plan on using port forwarding to allow Internet access to the cameras, assign a different port number to each camera. We recommend using port numbers in the 50000–50050 range.\n \n \n \n c. Enter the host name*1 if required by your ISP or network administrator.\n • If the camera is connected to a router, you can usually leave this field blank.\n \n \n \n d. Under [Default Gateway], enter the default gateway IP address if required by your ISP or network administrator.\n • This field can normally be left empty.\n \n \n \n e. Under [DNS], enter the IP addresses of the primary and secondary DNS servers if required by your ISP or network administrator.\n • These fields can normally be left empty.\n \n \n \n f. Under [Max. Bandwidth Usage], select the maximum bandwidth you want to allow the camera to use.\n • This setting is effective for both IPv4 and IPv6 connections.\n \n • Refer to the following file size information when restricting the maximum bandwidth. Note that these are estimated file sizes; the actual file size may vary depending on image quality, image brightness, etc.\n – 192 × 144: 3.5 KB (28 Kbit)\n \n – 320 × 240: 10 KB (80 Kbit)\n \n – 640 × 480: 18 KB (144 Kbit)\n \n \n \n \n \n g. Under [Connection Type], select the appropriate connection type.\n • Normally you can leave this setting at [Auto Negotiation].\n \n • This setting is effective for both IPv4 and IPv6 connections.\n \n \n \n \n \n 2. Click [Save].\n \n 3. When the [New settings are saved.] message is displayed, click [Restart].\n • All images buffered in the internal memory are deleted when the camera is restarted.\n \n \n \n \n \n \n *1 [Space], [\"], ['], [&], [<], and [>] cannot be entered.\n \n \n Note\n • If the camera’s IP address was changed as a result of changing the network settings, use the Setup Program on the CD-ROM to find the camera’s new IP address (see Finding cameras on the LAN).\n \n • The current network settings can be confirmed on the [Status] page (see 9.1 Confirming Camera Status).\n \n \n \n \n");

contentsDictionary["id_om01_0386"] = new ContentsDictionaryEntry("5.1.2 Proxy Server Settings", "5.1.2 Proxy Server Settings \n The following settings are necessary if your network uses a proxy server and you want to transfer images by HTTP or send trigger notifications by HTTP. If you do not use a proxy server, these settings are unnecessary.\n Note\n • Consult your Internet Service Provider (ISP) or network administrator to find out if your network uses a proxy server.\n \n • The camera does not use encryption when sending the login ID and password to access the proxy server. Use caution as necessary to prevent disclosure of this information.\n \n • For added security, we recommend periodically changing the login ID and password that are required to access your proxy server.\n \n \n \n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [Network (IPv4)].\n \n \n \n 3. Under [Proxy Server Settings], enter the address*1 port no., login ID*2 and password*2 that are to use the proxy server.\n • Ask your ISP or network administrator for the correct settings.\n \n \n \n 4. Click [Save].\n \n \n \n \n *1 [Space], [\"], ['], [&], [<], and [>] cannot be used.\n \n *2 [\"] cannot be used.\n \n \n");

contentsDictionary["id_om01_0471"] = new ContentsDictionaryEntry("5.2 HTTPS Settings", "5.2 HTTPS Settings \n The camera supports HTTPS connections. When accessing the camera using HTTPS, data sent between the computer and camera is encrypted, providing increased security. To access the camera using HTTPS, see Accessing the camera using HTTPS.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [HTTPS].\n \n \n \n 3. Set the following parameters as desired.\n a. Under [HTTPS], select [Use HTTPS] if you want to use the HTTPS feature.\n \n b. If [HTTPS] is set to [Use HTTPS], enter the IP address or host name of the server that contains the SSL key under [Certificate Information].*1 \n • Generally the camera’s IP address can be entered here.\n \n \n \n \n \n 4. Click [Save].\n • It may take up to 5 minutes to receive the SSL key. The camera cannot be accessed using HTTPS until the SSL key is received.\n \n \n \n 5. When the [Success!] message is displayed, click [Restart].\n • All images buffered in the internal memory are deleted when the camera is restarted.\n \n \n \n \n Note\n • When the camera is configured for HTTPS access, it cannot be accessed using HTTP. Similarly, when the camera is configured for HTTP access (i.e., when [HTTPS] is set to [Use HTTP]), it cannot be accessed using HTTPS.\n \n • When configuring the camera for access from the Internet, enter the IP address or host name used to access the camera over the Internet next to [Camera IP Address or Host Name]. In this case a security warning will be displayed when accessing the camera over the local network.\n \n • When accessing the camera using HTTPS, frame rate decreases and camera response time increases.\n \n \n \n \n \n *1 [Space], [\"], ['], [&], [<], and [>] cannot be entered.\n \n \n Accessing the camera using HTTPS\n If the camera is configured for HTTPS access, it can only be accessed using HTTPS; HTTP access is not possible. Use the following address format when accessing the camera using HTTPS.\n 1. Start your PC’s web browser.\n \n 2. In the browser’s address bar, enter https:// followed by the IP address or host name and the port number of the camera, then press [Enter] on the keyboard.\n Example: https://192.168.0.253:80 \n • If you have registered with a Dynamic DNS service, such as Viewnetcam.com (see 4.2.1 Configuring the Camera to Use Viewnetcam.com), enter the URL instead of the IP address. Note that accessing the camera this way may only work when you are accessing the camera from outside, i.e., from a PC that is not connected to the same network as the camera.\n Example: https://***.viewnetcam.com:80 \n \n \n \n 3. When the authentication dialog is displayed, enter the user name and password, then click [OK]. The top page is displayed.\n Note\n • If the authentication dialog is not displayed, click the [Login] tab after the camera’s top page is displayed. For more information, see 6.5 The Login Tab.\n \n \n \n \n \n \n Installing security certificates\n When accessing the camera using HTTPS, a security warning is displayed if there is a security certificate that corresponds to the camera is not installed on the PC. To prevent this dialog from being displayed, follow the procedure below and install a security certificate.\n Note\n • The value entered next to [Camera IP Address or Host Name] on the [HTTPS] screen must match the IP address or host name used to access the camera. If this value does not match, a security warning will be displayed when accessing the camera.\n \n • If the IP address or host name used to access the camera changes after installing the security certificate, a security warning will be displayed when accessing the camera. To prevent the security warning from being displayed, a new security certificate must be installed.\n \n • When configuring the camera for access from the Internet, enter the IP address or host name used to access the camera over the Internet next to [Camera IP Address or Host Name]. In this case a security warning will be displayed when accessing the camera over the local network.\n \n \n \n For Internet Explorer 7 and Windows Vista/Windows XP\n Note\n • Screens displayed when using Windows XP vary slightly from those shown below.\n \n \n \n 1. Access the camera using HTTPS.\n \n 2. When the security warning is displayed, click [Continue to this website (not recommended).].\n • Installing security certificates for unknown devices or sites can lead to security risks. Confirm the origin of the security certificates before installing them for devices or sites other than the camera.\n \n \n \n \n \n 3. When the authentication dialog is displayed, enter the user name and password, then click [OK].\n • The top page is displayed.\n \n \n \n 4. Click [Certificate Error] in the address bar, then click [View certificates].\n \n \n \n 5. Click [Install Certificate...].\n \n \n Note\n • If the [Install Certificate...] button is not displayed, exit Internet Explorer, then start Internet Explorer using the [Run as administrator] option. Click [Start]→[All Programs]→right-click [Internet Explorer], then click [Run as administrator].\n \n \n \n \n 6. After the wizard is displayed, click [Next].\n \n \n \n 7. Select [Place all certificates in the following store], then click [Browse...].\n \n \n \n 8. Click [Trusted Root Certification Authorities], then click [OK].\n \n \n \n 9. Click [Next].\n \n \n \n 10. Click [Finish].\n \n \n \n 11. Click [Yes].\n \n \n \n 12. After [The import was successful.] is displayed, click [OK].\n \n \n \n \n Note\n • After you restart the browser and access the camera using HTTPS, the security warning will not be displayed.\n \n \n \n \n For Internet Explorer 6 and Windows XP\n 1. Access the camera using HTTPS.\n \n 2. Click [View Certificate].\n • Installing security certificates for unknown devices or sites can lead to security risks. Confirm the origin of the security certificates before installing them for devices or sites other than the camera.\n \n \n \n \n \n 3. Click [Install Certificate...].\n \n \n \n 4. After the wizard is displayed, click [Next].\n \n \n \n 5. Select [Automatically select the certificate store based on the type of certificate], then click [Next].\n \n \n \n 6. Click [Finish].\n \n \n \n 7. Click [Yes].\n \n \n \n 8. After [The import was successful.] is displayed, click [OK].\n \n \n \n \n \n \n");

contentsDictionary["id_om01_0355"] = new ContentsDictionaryEntry("5.3 UPnP™ Settings", "5.3 UPnP™ Settings \n The camera supports UPnP™ (Universal Plug and Play) features, which allow you to do the following:\n – Configure your router’s port forwarding feature. (A UPnP™ compatible router is required.) This is useful if you want to access your camera from the Internet or using a mobile phone. See Section 4 Configuring the Camera for Access from the Internet for more information.\n \n – Create a shortcut to the camera in your computer’s [My Network Places] folder that will be automatically updated even if the camera’s IP address changes. (Windows 2000 does not support this feature.)\n \n \n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [UPnP].\n \n \n \n 3. Set the following parameters as desired.\n a. Under [Auto Port Forwarding], select [Enable] if you want to configure your router’s port forwarding feature.\n • In order to use this feature, your router must support UPnP™ and have its UPnP™ feature turned on.\n \n \n \n b. Under [Display Shortcut Icon in My Network Places], select [Enable] if you want to create a shortcut to the camera in your computer’s [My Network Places] folder.\n • In order to use this feature, your computer’s UPnP™ feature must be enabled. See 12.2 Creating a Shortcut to the Camera for more information.\n \n \n \n \n \n 4. Click [Save].\n \n \n Note\n • You can also configure your UPnP™ compatible router for port forwarding from the [Internet] tab (see 4.1 Configuring Port Forwarding).\n \n \n \n");

contentsDictionary["id_om01_0102"] = new ContentsDictionaryEntry("5.4 Setting the Date and Time", "5.4 Setting the Date and Time \n Set the camera’s date and time settings to ensure image buffering, image transferring, camera operation time, and time stamp features function as expected.\n Note\n • All images buffered in the internal memory are deleted when you click [Save] at the end of this procedure.\n \n \n \n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [Date and Time].\n \n \n \n 3. Set the following parameters as desired.\n a. Under [Time Setting], select the current month, day, and year.\n \n b. Select whether you want to use 12-hour or 24-hour time format.\n \n c. Select the current time.\n \n d. Under [Automatic Time Adjustment], select whether you want to enable automatic date and time adjustment.\n i. If you select to enable this feature, enter the IP address or host name of the desired NTP (network time protocol) server*1 (max. 255 characters) that the camera will use to adjust its date and time.\n • An IPv6 address can be entered.\n \n \n \n ii. Select your time zone.\n \n \n \n e. Under [Adjust Clock for Daylight Saving Time/Summer Time], select whether you want the camera to automatically adjust its date and time for Daylight Saving Time/Summer Time.\n i. If you select to enable this feature, enter the month, day, and time when Daylight Saving Time/Summer Time begins. (The camera’s clock moves forward one hour at the set date and time.)\n \n ii. Enter the month, day, and time when Daylight Saving Time/Summer Time ends. (The camera’s clock moves back one hour at the set date and time.)\n \n \n \n \n \n 4. Click [Save].\n • All images buffered in the internal memory are deleted when you click [Save].\n \n \n \n \n *1 [Space], [\"], ['], [&], [<], and [>] cannot be entered.\n \n \n \n \n Note\n • The camera will not synchronize to the NTP server if there is more than an 1 hour difference between the NTP server time and the camera’s current time. This is to protect the camera’s time setting from fraudulent NTP server tampering, incorrect time information, etc.\n \n • The camera’s clock becomes less accurate over time and can be affected when the camera’s temperature changes. Using the [Automatic Time Adjustment] feature is recommended.\n \n • Screen content varies by model number.\n \n \n \n");

contentsDictionary["id_om01_0103"] = new ContentsDictionaryEntry("5.5 Changing Basic Camera Settings", "5.5 Changing Basic Camera Settings \n The [Camera] page of the [Setup] tab allows you to adjust basic camera features.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [Camera].\n \n \n \n 3. Set the following parameters as desired.\n a. Under [AC Power Source Frequency], select the desired setting.\n – [50 Hz]: Select this item if your AC power source operates at 50 Hz.\n \n – [60 Hz]: Select this item if your AC power source operates at 60 Hz.\n \n \n Note\n • Screen content varies by model number.\n \n \n \n \n b. Under [Return to Specified Position], select whether you want the camera to move the lens to a specific preset position after a specified period of inactivity.\n i. Select the length of time (inactivity) that passes before the camera moves the lens. If this setting is too short, you may have difficulty registering presets because the lens will return to the specified position before you have saved your new preset.\n \n ii. Select the desired preset position (see 1.2.10 Registering and Changing Presets).\n \n \n \n c. Under [Shutter Speed/Color Night View], select whether the camera’s shutter speed is fixed, or whether the color night view mode feature automatically adjusts the shutter speed when the camera image is dark.\n i. To set the shutter speed, select [Shutter Speed], then select the desired speed from the pull-down menu.\n • The available shutter speeds depend on the [AC Power Source Frequency] setting, as follows:\n 50 Hz: 1/15 s, 1/50 s, 1/100 s, 1/250 s, 1/500 s, 1/1000 s\n 60 Hz: 1/15 s, 1/30 s, 1/60 s, 1/120 s, 1/250 s, 1/500 s, 1/1000 s\n \n • When [Shutter Speed] is set to [1/15 s], the actual shutter speed may increase when viewing bright objects. In this situation, the actual shutter speed varies depending on the [AC Power Source Frequency] setting, as follows:\n 50 Hz: 1/50 s\n 60 Hz: 1/30 s\n \n • Note that when the shutter speed is faster, flicker noise may be seen depending on the light source. This is not a malfunction.\n \n \n \n ii. To enable the color night view mode feature, select [Color Night View].\n • When the camera image becomes dark (e.g., when the lights in a room are turned off), the shutter speed is reduced.\n \n • When viewing bright objects, the shutter speed depends on the [AC Power Source Frequency] setting.\n When set to [50 Hz]: 1/50 s\n When set to [60 Hz]: 1/30 s\n \n • This feature is disabled by default.\n \n • Note that when this feature is activated:\n – Refresh rate decreases and images become blurry when the object is moving.\n \n – White or colored dots or horizontal lines may be displayed in the camera image. This is a characteristic of the camera’s image sensor, and is not a malfunction.\n \n \n \n \n \n \n \n \n \n 4. Click [Save].\n \n \n");

contentsDictionary["id_om01_0318"] = new ContentsDictionaryEntry("5.6 Changing Audio Settings", "5.6 Changing Audio Settings \n The [Audio] page of the [Setup] tab allows you to adjust audio feature-related settings.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [Audio].\n \n \n \n 3. Set the following parameters as desired.\n a. Under [Output], select whether the external speaker connected to the camera is enabled or disabled.\n \n b. Under [Volume], select the external speaker output volume.\n \n c. Under [PC Audio Input Timeout], select the maximum time the talk feature can be used. \n • After the set amount of time passes, the talk feature is automatically turned off.\n \n \n \n d. Under [Input], select whether the camera’s microphone is enabled or disabled.\n \n e. Under [Camera Microphone Sensitivity], select the desired setting.\n – [Minimum]: Sets the microphone to minimum sensitivity. Less sound is picked up by the microphone.\n \n – [Standard]: Sets the microphone to standard sensitivity.\n \n – [Maximum]: Sets the microphone to maximum sensitivity. More sound is picked up by the microphone.\n \n \n \n f. Under [Mute during Pan/Tilt/Zoom], select whether the camera’s microphone is automatically muted when the camera is panning, tilting, or zooming.\n • This feature is enabled by default.\n \n • When this feature is set to [Disable], the microphone will be enabled when the camera pans, tilts, or zooms. The sound of the lens moving may be picked up by the microphone.\n \n \n \n \n \n 4. Click [Save].\n \n \n");

contentsDictionary["id_om01_0354"] = new ContentsDictionaryEntry("5.7 Changing Video Streaming Settings", "5.7 Changing Video Streaming Settings \n The [Video Streaming] page of the [Setup] tab allows you to adjust video streaming feature-related settings.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [Video Streaming].\n \n \n \n 3. Set the following parameters as desired.\n a. Under [MPEG-4 Max. Frame Rate], select the number of frames per second the camera streams for each resolution setting.\n \n b. Under [MPEG-4 Bit Rate], select the minimum and maximum bit rate for each resolution setting.\n \n c. Under [RTSP], enter the port number used for RTSP. (Usually port number 554 is used.)\n \n d. Under [RTP], enter the first port number used for RTP.\n • The port number above RTP is used for RTCP. For example, when port number 33000 is used for RTP, port number 33001 is used for RTCP.\n \n \n \n e. Under [Multicast], check [Multicast settings screen is displayed.] to configure the camera for multicasting, otherwise click [Save] to finish.\n • When [Use] is checked under [Multicast (IPv4)] or [Multicast (IPv6)], [Multicast] becomes available in the [Streaming Method] selector on the single camera page.\n \n \n \n \n \n \n \n 4. Set the following parameters as desired.\n a. Under [Packet Availability Time], enter the desired setting.\n \n b. Under [Multicast (IPv4)], check [Use] to enable multicasting for IPv4. If used, the following settings are also necessary.\n i. Enter the IP address of the multicast.\n \n ii. Enter the first port number to be used for MPEG-4 streaming. This port number must be an even number.\n \n iii. Enter the port number to be used for audio streaming. This port number must be an even number.\n \n \n \n c. Under [Multicast (IPv6)], check [Use] to enable multicasting for IPv6. If used, the following settings are also necessary.\n i. Enter the IP address of the multicast. This address must be an IPv6 address.\n \n ii. Enter the first port number to be used for MPEG-4 streaming. This port number must be an even number.\n \n iii. Enter the port number to be used for audio streaming. This port number must be an even number.\n \n \n \n \n \n 5. Click [Save].\n \n \n Note\n • Streaming MPEG-4 video by multicast may increase the traffic on your network. Consult your network administrator before enabling this feature.\n \n • If video streaming settings are saved while users are viewing MPEG-4 images, the video stream may stop. Users can start the stream again by clicking the refresh button in their web browsers.\n \n • To increase image quality when streaming MPEG-4 images, decrease the frame rate.\n \n • To increase the frame rate, increase the setting for minimum bit rate.\n \n • If MPEG-4 images are unstable, reduce the setting for maximum bit rate and set the streaming method to HTTP.\n \n • If the network has little bandwidth or if MPEG-4 images break up, set the streaming method to HTTP.\n \n • In order to stream MPEG-4 images using unicast over the Internet, the port numbers used by RTP must be configured for the port forwarding feature of your router.\n \n \n \n");

contentsDictionary["id_om01_0299"] = new ContentsDictionaryEntry("Section 6 User Accounts", "Section 6 User Accounts \n");

contentsDictionary["id_om01_0290"] = new ContentsDictionaryEntry("6.1 Understanding User Accounts", "6.1 Understanding User Accounts \n The camera supports 3 different types of users. Each type of user can use the camera in different ways, and the administrator can control which features each user can have access to.\n User Type\n No. of Users\n Camera Configuration\n Feature Access\n [Administrator]\n 1\n Can access all pages and change all settings.\n All features can be used.\n [General Users]\n 50 different users can be registered.\n Cannot configure the camera.\n The administrator controls which features each general user can access (see Creating or modifying a general user account).\n [Guest User]\n(Anonymous users)\n –\n Cannot configure the camera.\n The administrator controls which features guest user can access, and can limit guest user access to the mobile phone page only (see Changing the features available to guest users).\n \n");

contentsDictionary["id_om01_0106"] = new ContentsDictionaryEntry("6.2 Changing the Administrator User Name and Password", "6.2 Changing the Administrator User Name and Password \n For security, we recommend setting a user name and password that uses many characters and is difficult to guess. Change the password periodically for added security.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Account], click [Administrator].\n \n \n \n 3. Under [Administrator Authentication], enter the user name and password, then re-enter the password for verification.\n • See 14.2 ASCII Character Table for a list of valid characters. Note that [Space], [\"], ['], [&], [<], [>], and [:] cannot be entered.\n \n \n \n 4. Click [Save].\n \n \n");

contentsDictionary["id_om01_0109"] = new ContentsDictionaryEntry("6.3 General Users", "6.3 General Users \n Up to 50 general user accounts can be created. Each user has his or her own user name and password, and you can control the camera features that are available to general users.\n Note\n • For security, we recommend setting user names and passwords that are difficult to guess. Change the passwords periodically for added security.\n \n • When general users access the camera, the [Internet], [Setup], and [Maintenance] tabs are never displayed. The [Multi] and [Buffered Image] tabs will be displayed if you allow general users to access those pages.\n \n \n \n Creating or modifying a general user account\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Account], click [General User].\n \n 3. Under [User ID List], click [Create].\n • Up to 50 general user accounts can be created.\n \n • To modify an existing user account, select the general user account you want to modify, then click [Modify].\n \n \n \n \n \n 4. Under [Input User Name and Password], enter the user name and password, then re-enter the password for verification.\n • See 14.2 ASCII Character Table for a list of valid characters. Note that [Space], [\"], ['], [&], [<], [>], and [:] cannot be entered.\n \n \n \n \n \n 5. Set the following parameters as desired.\n a. Under [Access Level], select the desired setting for [Video Display Time].\n – [Unlimited]: The user can view video images ([MPEG-4] or [MJPEG]) from the camera without restriction.\n \n – [Not permitted]: The user can view only still images.\n \n – [10 s]–[60 min]: The user can view video images for the selected amount of time, after which the user can view only still images.\n \n \n \n b. Select the desired setting for [Refresh Rate]. Still images viewed by the user will be refreshed at this rate.\n \n c. Select the features the user is allowed to use.\n • You can select features individually, or click [Level 1], [Level 2], or [Level 3] to enable the corresponding group of features.\n \n \n \n \n \n 6. Click [Save].\n \n \n Note\n • Users can click to center when using the 10× digital zoom feature, even if the click to center and the 4.6× zoom features are disabled. Users can click to center the image within the zoomed area, but the lens will not pan or tilt.\n \n \n \n \n Deleting a general user account\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Account], click [General User].\n \n 3. Under [User ID List], select the general user account you want to delete, then click [Delete].\n \n 4. Confirm that you have selected the desired general user account to be deleted, then click [Delete].\n \n 5. Click [OK].\n \n \n \n");

contentsDictionary["id_om01_0297"] = new ContentsDictionaryEntry("6.4 Guest Users", "6.4 Guest Users \n Guest users are anonymous users, and they do not need to enter a user name or password to access the camera. You can control the camera features that are available to guest users, and you can restrict guest user access altogether.\n IMPORTANT\n To prevent unauthorized access to the camera, it is important to manage who can access the camera through the use of user names and passwords. Because the camera can be accessed from the Internet, it is possible that the camera may be accessed by unknown individuals, including those who are commonly known as “hackers”, to whom you do not want to allow access. If you choose to allow guest access (i.e., anonymous access), there is a risk that unknown individuals will access the camera and view camera images. You have the option of allowing guest access, but it is strongly recommended that you do not allow guest access, and rather create general user accounts and assign secret user names and passwords for use by known individuals only.\n \n Allowing/restricting guest users to access the camera\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Account], click [Administrator].\n \n \n \n 3. Under [General Authentication], select the desired setting.\n – [Permit access from guest users]: Guest users can access the camera.\n \n – [Permit access from guest users (mobile only)]: Guest users can access the camera’s mobile phone page only.\n \n – [Do not permit access from guest users]: Guest users cannot access the camera.\n \n \n \n 4. Click [Save].\n \n \n Note\n • When [Permit access from guest users] is selected, no authentication dialog is displayed when you access the camera, and the [Login] tab is displayed on the top page. Click this tab to log in to the camera as the administrator or as a general user. For more information, see 6.5 The Login Tab.\n \n \n \n \n Changing the features available to guest users\n 1. Make sure you configured the camera to allow guest users to access the camera (explained above).\n \n 2. Click the [Setup] tab.\n \n 3. On the left side of the screen under [Account], click [General User].\n \n 4. Under [User ID List], select [Guest User], then click [Modify].\n \n \n \n 5. Set the following parameters as desired.\n a. Under [Access Level], select the desired setting for [Video Display Time].\n – [Unlimited]: The user can view video images ([MPEG-4] or [MJPEG]) from the camera without restriction.\n \n – [Not permitted]: The user can view only still images.\n \n – [10 s]–[60 min]: The user can view video images for the selected amount of time, after which the user can view only still images.\n \n \n \n b. Select the desired setting for [Refresh Rate]. Still images viewed by the user will be refreshed at this rate.\n \n c. Select the features the user is allowed to use.\n • You can select features individually, or click [Level 1], [Level 2], or [Level 3] to enable the corresponding group of features.\n \n \n \n \n \n 6. Click [Save].\n \n \n Note\n • Users can click to center when using the 10× digital zoom feature, even if the click to center and the 4.6× zoom features are disabled. Users can click to center the image within the zoomed area, but the lens will not pan or tilt.\n \n \n \n \n");

contentsDictionary["id_om01_0296"] = new ContentsDictionaryEntry("6.5 The Login Tab", "6.5 The Login Tab \n When guest users are allowed to access the camera (see Allowing/restricting guest users to access the camera), no authentication dialog is displayed when you access the camera, and the [Login] tab is displayed on the top page. Click this tab to log in to the camera as the administrator or as a general user.\n \n \n");

contentsDictionary["id_om01_0268"] = new ContentsDictionaryEntry("Section 7 Advanced Settings", "Section 7 Advanced Settings \n");

contentsDictionary["id_om01_0110"] = new ContentsDictionaryEntry("7.1 Changing Image Display Settings", "7.1 Changing Image Display Settings \n You can change the camera name and the way camera images are displayed each time the camera is accessed. Use the procedure below to change the following settings:\n – Camera name\n \n – Refresh rate, image resolution, and image quality for the single camera page and for the multi camera page\n \n – Default image resolution for when viewing with your mobile phone\n \n – Overlay settings (control whether the date and time, a text message, the camera’s trigger status, and backlight correction status are displayed)\n \n – Default display language\n \n – Banner settings (control whether a banner is displayed on the single camera page, and the properties of the banner)\n \n \n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Advanced], click [Image Display].\n \n \n \n 3. Set the following parameters as desired.\n a. Under [Camera Name], change the camera name as desired (max. 15 characters).\n • See 14.2 ASCII Character Table for a list of valid characters. Note that [Space], [\"], ['], [&], [<], and [>] cannot be entered.\n \n \n \n b. Under [Single Camera], select the desired default refresh rate, image resolution, and image quality (for when viewing MJPEG or still images) and streaming method (for when viewing MPEG-4 images).\n \n c. Under [Multi-Camera], select the desired default refresh rate, image resolution, and image quality (for when viewing MJPEG or still images).\n \n d. Under [Mobile Phone], select the desired default image resolution for when viewing still images with your mobile phone.\n \n e. Under [Overlay Setting], select what information is displayed in the overlay displayed on the single camera page, multi camera page, and buffered images page. See The single camera page (JPEG) for an example of a camera image overlays. Screen content varies by model number.\n i. Select whether you want to display a time stamp in the upper left corner of camera images, then select the desired format for the time stamp. To select 12-hour or 24-hour time format, see 5.4 Setting the Date and Time.\n \n ii. Select whether you want to display a text message in the lower left corner of camera images, then enter the desired text (max. 20 characters).\n • See 14.2 ASCII Character Table for a list of valid characters. Note that [\"], ['], [&], [<], and [>] are not available.\n \n \n \n iii. Select whether you want to display trigger status and backlight correction status in the upper right corner of camera images.\n • [M] will be displayed when the motion detection feature has been triggered.\n \n • [1] or [2] will be displayed when external sensor 1 or 2, respectively, has been triggered.\n \n • When the backlight correction feature is on, \n is displayed.\n \n \n Note\n • If the external sensor uses a ground to open signal (i.e., if you select [Rising: GND to Open (High).] when configuring the alarm trigger), the corresponding alarm number is displayed when the sensor is not being triggered. While the sensor is being triggered, the alarm number disappears from the overlay.\n \n \n \n \n \n \n f. Under [Language], select the camera’s display language.\n • The user can change the display language on the top page if desired.\n \n • If you select [Korean], Korean is displayed as the initial language when clicking the [Top], [Single], [Multi], and [Buffered Image] tabs. All other pages are displayed in English.\n \n \n \n g. Under [Banner Display], select the desired parameters for the banner displayed on the single camera page.\n i. Select whether you want to display a banner.\n \n ii. Select which users the banner is displayed for.\n \n iii. Enter the URL (max. 127 characters*1), including http:// if necessary, of the banner image file. This specifies the location of the image file that is displayed as the banner.\n Note\n • If authentication is required to display the image URL, an authentication window will be displayed when you access the single camera page.\n \n • Each time the single camera page is accessed, the camera accesses the URL of the banner image file and reads the file. Be aware that the computer/server that contains the banner image file may become burdened if the single camera page is accessed or refreshed frequently.\n \n \n \n \n iv. Enter the URL (max. 127 characters*1), including http:// if necessary, of the banner’s link. This specifies the web page or image that is displayed when the user clicks the banner.\n \n \n \n \n \n 4. Click [Save].\n \n \n \n \n *1 [Space], [\"], ['], [&], [<], and [>] cannot be entered.\n \n \n");

contentsDictionary["id_om01_0111"] = new ContentsDictionaryEntry("7.2 Registering Multiple Cameras", "7.2 Registering Multiple Cameras \n You can register other Panasonic Network Cameras to this camera’s [Multi] tab. This allows you to view images from up to 16 cameras by simply accessing this camera and clicking the [Multi] tab.\n Registering other cameras to this camera\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Advanced], click [Multi-Camera].\n \n \n \n 3. Click [Add].\n \n \n \n 4. Under [Add Camera], check [Display].\n \n 5. Check [HTTPS] if the corresponding camera is configured to use HTTPS.\n • If this setting does not match the camera’s setting, the camera cannot be accessed from the [Multi] page.\n \n \n \n 6. Enter the IP address or host name of the other camera.\n • To allow users to view cameras over the Internet, enter the camera’s global IP address or host name here (i.e., the IP address or host name needed to access the other camera over the Internet).\n \n • To allow users to view cameras over the LAN, enter the local IP address of the other camera here (i.e., the IP address needed to access the other camera over the LAN).\n \n • When entering an IPv6 address, the IPv6 address must be enclosed in brackets as shown below.\n Example: [****::***:****:****:***] \n \n • See 14.2 ASCII Character Table for a list of valid characters. Note that [Space], [\"], ['], [&], [<], [>], [#], [%], [=], [+], and [?] cannot be entered.\n \n • You can register this camera to the multi camera page by simply clicking [Clicking this link, enters this camera's settings.].\n \n \n \n 7. Enter the port number of the other camera.\n \n 8. Enter the camera’s name (max. 15 characters). This is the camera name that is displayed on the [Multi] page and does not need to match the camera name set on the other camera.\n • Only ASCII characters are available (see 14.2 ASCII Character Table). Note that [Space], [\"], ['], [&], [<], [>], [#], [%], [=], [+], [?], and [:] cannot be entered.\n \n \n \n 9. Click [Save].\n \n \n \n Modifying previously registered cameras\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Advanced], click [Multi-Camera].\n \n 3. Click the desired camera number.\n \n \n \n 4. Change the settings as desired.\n \n 5. Click [Save].\n \n \n \n Deleting previously registered cameras\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Advanced], click [Multi-Camera].\n \n 3. Click the desired camera number.\n \n 4. Click [Delete].\n \n 5. Click [OK].\n \n \n \n Changing the order of cameras on the [Multi] tab\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Advanced], click [Multi-Camera].\n \n \n \n 3. Under [Change Camera Order], select the number of the camera you would like to move, and select the number you would like to move the camera to. The 2 cameras will switch places in the list.\n • For example, to switch camera 2 and camera 1, select [Switch No.] 2 [with No.] 1. \n \n \n \n 4. Click [Execute].\n \n \n \n");

contentsDictionary["id_om01_0283"] = new ContentsDictionaryEntry("7.3 Specifying Operation Times", "7.3 Specifying Operation Times \n You can specify the days and times during which general users and guest users can view camera images (the administrator can always view camera images). When the camera is accessed outside of the operation time, the camera image on the single camera page, multi camera page, and buffered image page is displayed as a gray screen. Additionally, [The operation time has ended.] is displayed on the single camera page. Up to 7 different operation times can be set.\n Note\n • Your privacy may be compromised if you set this feature incorrectly. To confirm that you have made the correct settings, access the camera as a general user or guest user during a time the camera is outside of the operational time to confirm that camera images cannot be seen.\n \n • Make sure the camera’s date and time setting is correct in order for this feature to function as desired.\n \n \n \n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Advanced], click [Operation Time].\n \n \n \n 3. Select the desired operation time setting number.\n • If No. 1–7 are disabled, camera images can always be seen.\n \n \n \n \n \n 4. Check [Enable] to enable this operating time setting number, then set the desired operation days and times.\n • Click [Always] to allow camera images to be seen at any time of day on the days which have a check mark under them.\n \n \n \n 5. Click [Save].\n \n \n Note\n • If 2 operating time settings overlap, the [Enable] setting takes priority.\nIn the example below, the camera is set to be disabled on Mondays (in setting No. 1) and is set to be disabled on Tuesdays (in setting No. 2). However, the camera can be accessed on both Mondays and Tuesdays because these days are each enabled by one of the settings.\n \n \n \n \n \n");

contentsDictionary["id_om01_0393"] = new ContentsDictionaryEntry("7.4 Controlling the External Output Terminal", "7.4 Controlling the External Output Terminal \n If a device is connected to the output terminals of the external I/O interface (see the Installation Guide for connection information), follow the procedure below to configure the camera to interact with the device properly and to rename the external output buttons displayed in the operation bar.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Advanced], click [External Output].\n \n \n \n 3. Under [External Device Control Output], select the appropriate setting.\n – [Open]: The camera’s internal transistor turns off and the camera sends a high impedance signal when it turns on.\n \n \n – [Short to GND]: The camera’s internal transistor turns on and is shorted to the GND pin, and the camera sends a low impedance (0 V) signal when it turns on.\n \n \n \n 4. Under [Button name modification], modify the names of the external output buttons displayed in the operation bar if necessary. Note that [Space], [\"], ['], [&], [<], and [>] cannot be entered.\n \n 5. Click [Save].\n \n \n");

contentsDictionary["id_om01_0396"] = new ContentsDictionaryEntry("7.5 Controlling the Analog Video Output Signal", "7.5 Controlling the Analog Video Output Signal \n If a TV or other video device is connected to the analog video output terminal, follow the procedure below to enable or disable the analog video output and to change the format of the signal.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Advanced], click [Analog Video Output].\n \n \n \n 3. Under [Analog Video Output], select the desired setting.\n • This feature is disabled by default.\n \n \n \n 4. Under [Analog Video Output Signal Type], select signal format that corresponds to the type of video device connected to the camera.\n • NTSC is the standard format used in North America.\n \n \n \n 5. Click [Save].\n \n 6. When the [New settings are saved.] message is displayed, click [Go to Analog Video Output page]. \n • If [Restart] is displayed after changing the [Analog Video Output Signal Type], click [Restart]. All images buffered in the internal memory are deleted when the camera is restarted.\n \n \n \n \n Note\n • When [Analog Video Output] is set to [Enable], frame rate will decrease. \n \n • The analog video signal is degraded during to analog conversion. Camera images viewed on an external video device are not as clear as when viewed using a PC.\n \n \n \n");

contentsDictionary["id_om01_0116"] = new ContentsDictionaryEntry("7.6 Changing the Indicator Display", "7.6 Changing the Indicator Display \n The camera’s indicator can be used to indicate when the camera is being accessed, however you can set the camera so that the indicator is:\n – Always on (green) during normal operation\n \n – On (green) only when the camera is being accessed\n \n – Always off during normal operation\n \n \n \n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Advanced], click [Indicator Control].\n \n \n \n 3. Select the desired setting.\n \n 4. Click [Save].\n \n \n Note\n • If the indicator lights in any color other than green, refer to 1.2 Camera Indicator Issues in the Troubleshooting Guide.\n \n \n \n");

contentsDictionary["id_om01_0269"] = new ContentsDictionaryEntry("Section 8 Using SD Memory Cards", "Section 8 Using SD Memory Cards \n Images can be buffered to an optional SD memory card instead of the internal memory. The camera supports Panasonic SD memory cards from 64 MB to 2 GB in capacity, as well as Panasonic SDHC memory cards.\n Note\n • Format the SD memory card (see 8.2 Formatting an SD Memory Card) before buffering images to the card.\n \n • JPEG images that have been buffered on an SD memory card can be viewed on your PC using the Network Camera SD Viewer software. This software can be found on the included CD-ROM, and can be installed by following the instructions in the “Read Me” file (CD-ROM Drive:\\NCV\\SDVIEWER_README.txt). You can also download this software from the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html).\n \n • MPEG-4 images that have been buffered on an SD memory card are saved in ASF format. You view them using Windows Media Player.\n \n \n \n");

contentsDictionary["id_om01_0277"] = new ContentsDictionaryEntry("8.1 Inserting and Removing an SD Card", "8.1 Inserting and Removing an SD Card \n Inserting an SD memory card\n 1. Remove the ceiling mounting cover.\n \n 2. BB-HCM547 only: Open the SD memory card cover on the inner cover. \n \n 3. Insert the SD memory card as shown. The label should be faced up. Push the SD memory card with your finger until it clicks. When removing the card, push the card lightly to release it, then remove it from the slot.\n \n \n Note\n • If the camera’s indicator turns red, remove the SD memory card and confirm that the card is not write-protected. If the indicator is still red, the card must be formatted before it can be used (see 8.2 Formatting an SD Memory Card).\n \n \n \n \n 4. Replace the ceiling mounting cover.\n \n \n \n Removing an SD memory card\n 1. Remove the ceiling mounting cover.\n \n 2. BB-HCM547 only: Open the SD memory card cover on the inner cover. \n \n 3. Press the FUNCTION button. \n \n 4. Confirm that the FUNCTION indicator is not lit, then push the card slightly to eject it.\n \n 5. Remove the card.\n \n 6. BB-HCM547 only: Close the SD memory card cover on the inner cover. \n \n 7. Replace the ceiling mounting cover.\n \n \n Note\n • Make sure that SD memory card recording has stopped and that the card is not being accessed before removing the card. (The FUNCTION indicator will light while images are being recorded to the card.) Press the FUNCTION button to stop SD memory card recording before ejecting the card. If the SD memory card is removed while it is being recorded to or accessed, the card may become unreadable and may need to be formatted (i.e., erased) again before use.\n \n \n \n \n");

contentsDictionary["id_om01_0278"] = new ContentsDictionaryEntry("8.2 Formatting an SD Memory Card", "8.2 Formatting an SD Memory Card \n Before you record the camera image, you need to format the SD memory card. You can format the card without accessing the camera by using the SD Memory Card Formatting Software. See the Panasonic Network Camera support site (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) for more information.\n Note\n • You can confirm the SD memory card capacity on the [Status] page.\n \n \n \n 1. Insert the SD memory card.\n \n 2. Click the [Setup] tab.\n \n 3. On the left side of the screen under [Buffer/Transfer], click [Trigger].\n \n \n \n 4. Under [SD memory card], click [Format].\n \n 5. Click [OK].\n \n \n");

contentsDictionary["id_om01_0279"] = new ContentsDictionaryEntry("8.3 Starting and Stopping SD Memory Card Recording", "8.3 Starting and Stopping SD Memory Card Recording \n You can start and stop SD memory card recording. When SD memory card recording is started, buffered images will be stored on the card. When SD memory card recording is stopped, images will be buffered to the camera’s internal memory. Before removing the card, stop SD memory card recording using the procedure below.\n Note\n • You can confirm the SD memory card capacity on the [Status] page.\n \n • If the camera is restarted, the SD memory recording starts again.\n \n • If you remove the SD memory card and insert it again, the SD memory recording starts again.\n \n \n \n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Buffer/Transfer], click [Trigger].\n \n \n \n 3. Under [SD memory card], click [SD video recording start] or [SD video recording stop].\n \n \n Note\n • You can also stop SD memory card recording by pressing the FUNCTION button on the side of the camera.\n \n \n \n");

contentsDictionary["id_om01_0270"] = new ContentsDictionaryEntry("Section 9 Camera Administration and Maintenance", "Section 9 Camera Administration and Maintenance \n");

contentsDictionary["id_om01_0307"] = new ContentsDictionaryEntry("9.1 Confirming Camera Status", "9.1 Confirming Camera Status \n You can confirm various camera status information on the [Status] page such as:\n – Detailed camera information, including the firmware version number and MAC address\n \n – SD memory card status (whether or not a card is inserted, the amount of used memory, and the amount of available memory)\n \n – Detailed network information\n \n – Dynamic DNS status\n \n – UPnP™ status\n \n – The status of various protocols (such as FTP, HTTP, SMTP, etc.) and whether or not there have been any errors \n \n \n The information displayed on this page can help you when the camera is not functioning as you expect it to. Refer to this information for troubleshooting assistance.\n \n 1. Click the [Maintenance] tab.\n \n 2. On the left side of the screen under [Maintenance], click [Status].\n \n 3. Confirm the desired information.\n \n \n Note\n • See the Panasonic Network Camera support site (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) for details about the information displayed on this page.\n \n \n \n");

contentsDictionary["id_om01_0303"] = new ContentsDictionaryEntry("9.2 Confirming Session Status", "9.2 Confirming Session Status \n You can confirm various client session information on the [Session Status] page such as:\n – The number of active video (MPEG-4 and MJPEG) and audio sessions\n \n – Multicast session status\n \n \n \n 1. Click the [Maintenance] tab.\n \n 2. On the left side of the screen under [Maintenance], click [Session Status].\n \n 3. Confirm the desired information.\n \n \n Note\n • Information for the following session types is not displayed:\n – Mobile phone access\n \n – Still image viewing\n \n – Accessing the [Top], [Setup], [Internet], [Maintenance], and [Support] pages\n \n \n \n \n \n");

contentsDictionary["id_om01_0304"] = new ContentsDictionaryEntry("9.3 Confirming Alarm Logs", "9.3 Confirming Alarm Logs \n You can view information about the last 50 sensor and motion detections on the [Alarm Log] page.\n \n 1. Click the [Maintenance] tab.\n \n 2. On the left side of the screen under [Maintenance], click [Alarm Log].\n \n 3. Confirm the desired information.\n \n \n Note\n • When the camera is restarted, the alarm log content is deleted.\n \n • You can configure the camera to send a daily log by E-mail that reports the status of triggers 1–5 (see 2.10 Sending Alarm Log Information).\n \n \n \n");

contentsDictionary["id_om01_0160"] = new ContentsDictionaryEntry("9.4 Restarting the Camera", "9.4 Restarting the Camera \n You can restart the camera from the [Restart] page.\n Note\n • When the camera is restarted, all images buffered in the internal memory are deleted.\n \n • When the camera is restarted, the alarm log content is deleted.\n \n \n \n \n 1. Click the [Maintenance] tab.\n \n 2. On the left side of the screen under [Maintenance], click [Restart].\n \n \n \n 3. Click [Restart].\n \n \n Automatically restarting the camera\n You can set the camera restart itself automatically periodically.\n 1. Click the [Maintenance] tab.\n \n 2. On the left side of the screen under [Maintenance], click [Restart].\n \n \n \n 3. Under [Scheduled Restart], click [Enable].\n \n 4. Select the days and times you would like the camera to automatically restart.\n \n 5. Click [Save].\n \n \n \n Restarting the camera using the RESTART button\n You can also restart the camera by pressing the RESTART button for about one second with a pointed object.\n \n \n Note\n • Make sure that SD memory card recording has stopped and that the card is not being accessed before pressing the RESTART button. (The FUNCTION indicator will light while images are being recorded to the card.) We recommend pressing the FUNCTION button to stop SD memory card recording before pressing the RESTART button. If the SD memory card is removed while it is being recorded to or accessed, the card may become unreadable and may need to be formatted (i.e., erased) again before use.\n \n \n \n \n");

contentsDictionary["id_om01_0161"] = new ContentsDictionaryEntry("9.5 Updating the Camera’s Firmware", "9.5 Updating the Camera’s Firmware \n You can update the camera’s firmware from the [Update Firmware] page.\n \n 1. Download the latest firmware from the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) and save it on your PC.\n \n 2. Click the [Maintenance] tab.\n \n 3. On the left side of the screen under [Maintenance], click [Update Firmware].\n \n 4. Click [Update Firmware]. The camera will automatically restart.\n \n 5. After the camera restarts, a dialog prompts you to select the firmware file.\n \n 6. Click [Browse...]. A dialog prompts you to specify the location of the firmware file.\n \n 7. Select the firmware file you downloaded from the Panasonic Network Camera website and click [Open]. The selected file name is displayed.\n \n 8. Confirm the file name, then click [Update Firmware].\n • The [Updating firmware.] screen is displayed, and then the [Restarting now...] screen is displayed. When the firmware update is complete, the camera’s top page is displayed.\n \n \n Note\n • The firmware update may take 10 minutes or longer depending on the network environment.\n \n \n \n \n 9. Confirm the camera’s new firmware version on the top page.\n \n \n Note\n • Do not turn off the power during a firmware update.\n \n • All images buffered in the internal memory are deleted when the firmware is updated.\n \n • All alarm logs are deleted when the firmware is updated.\n \n • You can also use the Setup Program to update the camera’s firmware (see Section 13 Using the Setup Program).\n \n • The camera’s current firmware version can be confirmed on the [Top] page and the [Status] page.\n \n • The camera can only be accessed using HTTP while updating the firmware. If HTTPS was used to begin the firmware update, the camera will switch to HTTP during the update, and then return to HTTPS when the update is completed.\n \n \n \n");

contentsDictionary["id_om01_0162"] = new ContentsDictionaryEntry("9.6 Saving Settings in a Configuration File", "9.6 Saving Settings in a Configuration File \n You can save a configuration file (i.e., a backup of the camera’s settings) on your PC and restore the settings later if desired (see 9.7 Restoring Settings from a Configuration File).\n \n 1. Click the [Maintenance] tab.\n \n 2. On the left side of the screen under [Maintenance], click [Save Settings].\n \n 3. Click [Save]. A dialog prompts you to specify a location to save the configuration file.\n \n 4. Specify a location to save the file, then click [Save].\n \n \n Note\n • The saved configuration file contains user names, passwords, and other private information. You are responsible for storing the configuration file in a safe place where it cannot be retrieved by unauthorized parties.\n \n • You can also use the Setup Program to save a configuration file (see Section 13 Using the Setup Program).\n \n • Buffered images are not saved in the configuration file.\n \n • The configuration file’s extension (.dat) must not be changed. If you change it, the saved settings cannot be restored.\n \n \n • If you save a configuration file and then update the camera’s firmware later, the configuration file may not be able to be restored properly. If you regularly save a configuration file of the camera’s settings, remember to save a configuration file after you update the camera’s firmware.\n \n \n \n");

contentsDictionary["id_om01_0163"] = new ContentsDictionaryEntry("9.7 Restoring Settings from a Configuration File", "9.7 Restoring Settings from a Configuration File \n If you have saved a configuration file (i.e., a backup of the camera’s settings) on your PC, you can restore the settings later. If you reset the camera to factory default, the camera can load its settings from the configuration file.\n \n 1. Click the [Maintenance] tab.\n \n 2. On the left side of the screen under [Maintenance], click [Load Settings].\n \n 3. Click [Browse...]. A dialog prompts you to specify the location of the saved configuration file.\n \n 4. Specify the configuration file and click [Open].\n \n 5. Confirm the file name and click [Load].\n \n 6. Click [Restart]. The camera will restart and the saved settings will be restored.\n \n \n Note\n • The configuration file saves the camera’s network settings. When the settings are loaded, the settings are restored as they were saved, therefore the camera’s IP address may change. If you cannot access the camera after loading the configuration file, use the Setup Program to confirm the camera’s IP address (see Section 13 Using the Setup Program).\n \n • The configuration file saves the camera’s user names and passwords. When the settings are loaded, the settings are restored as they were saved, therefore the administrator user name and password may change. If you cannot remember the administrator user name or password, you will need to reset the camera and set the user name and password again.\n \n • You can also use the Setup Program to restore a configuration file (see Section 13 Using the Setup Program). Network settings and the administrator user name and password are not changed when you restore a configuration file using the Setup Program.\n \n • Buffered images will be deleted when you load the saved configuration file and restart the camera.\n \n • Alarm logs will be deleted when you load the saved configuration file and restart the camera.\n \n • If you have updated the camera’s firmware, you may not be able to restore a configuration file correctly if the configuration file was saved with the old camera firmware version.\n \n \n \n");

contentsDictionary["id_om01_0164"] = new ContentsDictionaryEntry("9.8 Resetting the Camera", "9.8 Resetting the Camera \n You can reset all of the camera’s settings to their factory default settings.\n \n 1. Click the [Maintenance] tab.\n \n 2. On the left side of the screen under [Maintenance], click [Reset to Factory Default].\n \n \n \n 3. Click [Execute].\n • The indicator flashes orange, and then turns off for a few seconds.\n \n \n \n \n Note\n • Do not turn off the camera while the camera is being reset. When the lens finishes panning and tilting, it is safe to turn off the camera.\n \n • When the camera is reset, the following information will be deleted:\n – All images buffered in the internal memory\n \n – All alarm logs\n \n – All camera settings (including the user name, password, IP address, subnet mask etc.) \nThe network connection mode changes to [Automatic Setup]. Reconfigure the camera by referring to the Setup Guide.\n \n \n \n • When the camera is reset, the internal clock will not be reset, but the time format will be set to AM/PM mode. Change the setting if necessary (see 5.4 Setting the Date and Time).\n \n • See 14.5 Default Setting List for a list of the camera’s default settings.\n \n \n \n Resetting the camera using the FACTORY DEFAULT RESET button\n You can also reset all of the camera’s settings to their factory default settings by pressing the FACTORY DEFAULT RESET button for about one second with a pointed object. The camera must be turned on in order to reset it.\n \n \n \n");

contentsDictionary["id_om01_0271"] = new ContentsDictionaryEntry("Section 10 The [Support] Tab", "Section 10 The [Support] Tab \n The [Support] tab can be accessed by all users and provides access to the following pages.\n The [Help] page\n Displays basic help information.\n \n The [Product Information] page\n Displays a link to the Panasonic Network Camera website where you can view product information.\n \n The [Support Information] page\n Displays a link to the Panasonic Network Camera website, where you can view technical information, download the latest firmware, etc.\n \n");

contentsDictionary["id_om01_0272"] = new ContentsDictionaryEntry("Section 11 Using IPv6", "Section 11 Using IPv6 \n Your Panasonic Network Camera supports IPv6 (Internet Protocol Version 6). IPv6 is a next generation protocol and is expected to eventually replace IPv4, the current standard Internet protocol. As the Internet continues to expand and more and more IP-compatible devices are being introduced, the number of IP addresses supported by IPv4 is running out. While IPv4 supports just over 4 billion unique addresses, the number of addresses supported by IPv6 is virtually unlimited.\n Although several Internet Service Providers (ISPs) do not support IPv6 yet, your Network Camera will be ready as IPv6 services become more widespread.\n For more information regarding IPv6, visit http://www.ipv6.org/.\n Note\n • The following restrictions apply when using the camera in an IPv6-native network.\n – Viewnetcam.com service cannot be used\n \n – The Setup Program can be used to search for cameras only (other Setup Program features cannot be used)\n \n \n \n \n \n Requirements for accessing the camera using IPv6\n The following hardware and software is required to access the camera using IPv6.\n • Windows Vista, Windows XP Service Pack 1 or later\n \n • Internet Explorer 6.0 or later\n \n • An IPv6-compatible router\n \n • An IPv6-compatible Internet connection\nSubscribe to your Internet Service Provider’s “IPv4/IPv6 Dual-Stack” or “IPv6 over IPv4 Tunneling” service.\n \n • For Internet Explorer 6 users: A subscription to an IPv6-compatible domain name service or Dynamic DNS service\nYou cannot access the camera by entering its IPv6 address in your web browser, therefore, you need to subscribe to an IPv6-compatible domain name service or Dynamic DNS service. We recommend using Viewnetcam.com, a Dynamic DNS service designed for use with Panasonic Network Cameras. For more information about IPv6 access, ask your ISP about IPv6-compatible services.\n \n \n \n Preparations for accessing the camera using IPv6\n The following procedures are required before you can access the camera using IPv6.\n 1. Configure your router for IPv6 (see 11.1 Configuring Your Router for IPv6).\n \n 2. Configure your PC for IPv6 (see 11.2 Configuring Your PC for IPv6).\n \n 3. Configure the camera for IPv6 (see 11.3 Configuring Your Camera for IPv6).\n \n \n \n");

contentsDictionary["id_om01_0336"] = new ContentsDictionaryEntry("11.1 Configuring Your Router for IPv6", "11.1 Configuring Your Router for IPv6 \n Refer to your Internet Service Provider and the operating instructions included with your router for information on configuring the router for IPv6. If outside access (WAN access) is disabled on the router, use the router’s packet filtering feature to allow the router to receive the desired TCP and UDP packets from the WAN side. See the Panasonic Network Camera website at http://panasonic.co.jp/pcc/products/en/netwkcam/ for information about the recommended routers.\n");

contentsDictionary["id_om01_0280"] = new ContentsDictionaryEntry("11.2 Configuring Your PC for IPv6", "11.2 Configuring Your PC for IPv6 \n IPv6 is supported by Windows Vista and Windows XP Service Pack 1 or later. If using Windows XP, use the procedure below to enable your PC for IPv6.\n 1. Click [Start]→[All Programs]→[Accessories]→[Command Prompt].\n \n 2. When the [Command Prompt] is displayed, enter ipv6 install. When installation is complete, [Succeeded.] will be displayed.\n \n 3. Confirm that IPv6 was successfully enabled, enter ipconfig. If IPv6 addresses are displayed, installation was successful.\n \n \n For Windows XP Service Pack 2 users\n If you use Windows XP Service Pack 2, the following procedure is also necessary.\n 1. Click [Start]→[Control Panel]→[Security Center]→[Windows Firewall]→[Advanced] tab.\n \n 2. Click the [Settings...] button under [ICMP].\n \n 3. Check [Allow incoming router request], then click [OK].\n \n \n \n");

contentsDictionary["id_om01_0338"] = new ContentsDictionaryEntry("11.3 Configuring Your Camera for IPv6", "11.3 Configuring Your Camera for IPv6 \n When the [Connection Mode] on the [Network (IPv6)] page is set to [Automatic Setup], an IPv6 address is automatically assigned to the camera. To assign a static IPv6 address, follow the procedure below.\n 1. Click the [Setup] tab.\n \n 2. On the left side of the screen under [Basic], click [Network (IPv6)].\n \n \n \n 3. Select the desired connection mode, then make the appropriate settings as described in this section.\n – [Automatic Setup]: The camera is automatically assigned an IPv6 prefix from the IPv6 router, and produces an original IPv6 address based on the IPv6 prefix.\n \n – [Static]: Allows you to set all network settings manually.\n \n \n \n \n [Automatic Setup]\n \n \n 1. Set the following parameters as desired.\n a. Under [DNS], enter the IP addresses of the primary and secondary DNS servers provided by your ISP.\n \n b. Under [Max. Bandwidth Usage], select the maximum bandwidth you want to allow the camera to use.\n \n c. Under [Connection Type], select the appropriate connection type.\n • Normally you can leave this setting at [Auto Negotiation].\n \n \n \n \n \n 2. Click [Save].\n \n 3. When the [New settings are saved.] message is displayed, click [Restart].\n \n \n Note\n • The current network settings can be confirmed on the [Status] page (see 9.1 Confirming Camera Status). You can also confirm the camera’s IPv6 address using the Setup Program.\n \n \n \n \n [Static]\n \n \n 1. Set the following parameters as desired.\n a. Under [Internet Connection], enter the port number to be assigned to the camera.\n • The default port number is 80, however, note that some ISPs do not allow access from the Internet using port 80. Ask your ISP or network administrator about which port numbers are available for access over the Internet.\n \n \n \n b. Enter the IP address to be assigned to the camera.\n • Ask your ISP or network administrator for the correct settings.\n \n \n \n c. Under [Default Gateway], enter the IP address of your router or the default gateway IP address provided by your ISP.\n \n d. Under [DNS], enter the IP addresses of the primary and secondary DNS servers provided by your ISP.\n \n e. Under [Max. Bandwidth Usage], select the maximum bandwidth you want to allow the camera to use.\n • This setting is effective for both IPv4 and IPv6 connections.\n \n • Refer to the following file size information when restricting the maximum bandwidth. Note that these are estimated file sizes; the actual file size may vary depending on image quality, image brightness, etc.\n – 192 × 144: 7 KB (56 Kbit)\n \n – 320 × 240: 16 KB (128 Kbit)\n \n – 640 × 480: 35 KB (280 Kbit)\n \n \n \n \n \n f. Under [Connection Type], select the appropriate connection type.\n • Normally you can leave this setting at [Auto Negotiation].\n \n • This setting is effective for both IPv4 and IPv6 connections.\n \n \n \n \n \n 2. Click [Save].\n \n 3. When the [New settings are saved.] message is displayed, click [Restart].\n \n \n Note\n • The current network settings can be confirmed on the [Status] page (see 9.1 Confirming Camera Status). You can also confirm the camera’s IPv6 address using the Setup Program.\n \n \n \n \n");

contentsDictionary["id_om01_0342"] = new ContentsDictionaryEntry("11.4 Accessing the Camera in IPv6 Mode", "11.4 Accessing the Camera in IPv6 Mode \n You will need to know the following information to access the camera in IPv6 mode.\n For Internet Explorer 6 users:\n • The URL assigned to you by the domain name service or Dynamic DNS service you registered the camera to (e.g., ***.viewnetcam.com).\n \n • The port number of the camera, if it is not 80.\n \n • The user name and password required to access the camera, which were set during camera setup.\n \n \n For Internet Explorer 7 users:\n • The camera’s IPv6 address, or the URL assigned to you by the domain name service or Dynamic DNS service you registered the camera to (e.g., ***.viewnetcam.com).\n \n • The port number of the camera, if it is not 80.\n \n • The user name and password required to access the camera, which were set during camera setup.\n \n \n Accessing the camera in IPv6 mode\n 1. Start your PC’s web browser.\n \n 2. In the browser’s address bar, enter http:// followed by the host name and port number (if it is not 80) of the camera, then press [Enter] on the keyboard.\n Example: http://***.viewnetcam.com \n • If using Internet Explorer 7, you can also access the camera by entering http:// followed by the IPv6 address and port number (if it is not 80) of the camera. Note that the IPv6 address must be enclosed in brackets as shown below.\n Example: http://[****::***:****:****:***]:50000 \n \n • If the camera is configured to use HTTPS (see 5.2 HTTPS Settings), enter https:// followed by the host name and port number of the camera.\n \n \n \n 3. When the authentication dialog is displayed, enter the user name and password, then click [OK]. The top page is displayed.\n Note\n • For general information on accessing the camera, see 1.1 Accessing the Camera.\n \n \n \n \n \n \n");

contentsDictionary["id_om01_0422"] = new ContentsDictionaryEntry("11.5 Allowing IPv6 Access from the Internet", "11.5 Allowing IPv6 Access from the Internet \n You can configure the camera to allow or restrict IPv6 access from the Internet.\n 1. Click the [Internet] tab.\n \n \n \n 2. Under [Allow Access from the Internet (IPv6)], select [Yes] to allow IPv6 access to the camera from the Internet, or [No] to limit IPv6 access to the camera.\n • If [No] is selected, IPv6 access to the camera is only possible from an address of the same prefix as the camera’s IPv6 address. The camera will not be able to be accessed from the Internet using IPv6.\n \n \n \n 3. Click [Save].\n \n \n");

contentsDictionary["id_om01_0273"] = new ContentsDictionaryEntry("Section 12 PC Settings", "Section 12 PC Settings \n");

contentsDictionary["id_om01_0191"] = new ContentsDictionaryEntry("12.1 Proxy Server Settings", "12.1 Proxy Server Settings \n A proxy server is used to protect computers when connecting to the Internet. If your computer network uses a proxy server (many corporate networks do; most home networks do not) and you are accessing the camera from a PC connected to the same LAN as the camera, you may experience the following issues.\n – Camera cannot be accessed\n \n – Slow image refresh rate\n \n – Camera images cannot be seen\n \n – Audio features cannot be used\n \n \n If your network uses a proxy server, we recommend setting your web browser to bypass the proxy server when accessing the camera from a PC connected to the same LAN as the camera.\n Note\n • Consult your Internet Service Provider or network administrator to find out if your network uses a proxy server and consult your network administrator before changing your PC’s proxy server settings.\n \n • The video and audio features cannot be used when the camera is accessed through a proxy server requiring authentication.\n \n \n \n How to bypass the proxy server when accessing the camera\n 1. Start Internet Explorer.\n \n 2. From the [Tools] menu, select [Internet Options...].\n \n \n \n 3. Click the [Connections] tab, then click [LAN Settings...].\n \n \n \n 4. If there is a check next to [Use a proxy server for your LAN], click [Advanced...].\n • If there is no check next to [Use a proxy server for your LAN], click [Cancel]. You do not need to change any settings.\n \n \n \n \n \n 5. Enter the camera’s IP address in the field under [Do not use proxy server for addresses beginning with:].\n \n \n \n 6. Click [OK].\n \n \n \n");

contentsDictionary["id_om01_0193"] = new ContentsDictionaryEntry("12.2 Creating a Shortcut to the Camera", "12.2 Creating a Shortcut to the Camera \n You can create a shortcut to the camera in your computer’s [My Network Places] folder that will be automatically updated even if the camera’s IP address changes. In order to use this feature, you must first enable the UPnP™ component of Windows using the following procedure.\n Note\n • Windows 2000 does not support this feature.\n \n • This feature is enabled for the camera by default. You can confirm the setting on the [UPnP] page if necessary (see 5.3 UPnP™ Settings).\n \n \n \n When using Windows XP (Service Pack 2)\n [Start]→([Settings])→[Control Panel]→[Add or Remove Programs]→\n[Add/Remove Windows Components]→Select [Networking Services]→[Details]→\nCheck [Internet Gateway Device Discovery and Control Client] and [UPnP User Interface]→\n[OK]→[Next]→Complete\n \n When using previous versions of Windows XP\n [Start]→([Settings])→[Control Panel]→[Add or Remove Programs]→\n[Add/Remove Windows Components]→Select [Networking Services]→\n[Details]→Check [UPnP User Interface]→[OK]→[Next]→Complete\n \n When using Windows Vista\n [Start]→[Control Panel]→[Network and Internet]→[Network and Sharing Center]→Click the arrow button to expand [Network discovery] under [Sharing and Discovery]→Select [Turn on network discovery]→Click [Apply]→Complete\n \n");

contentsDictionary["id_om01_0194"] = new ContentsDictionaryEntry("12.3 Changing the [Temporary Internet files] Setting", "12.3 Changing the [Temporary Internet files] Setting \n If old images are displayed when you access the camera, change the [Temporary Internet files] setting using the following procedure.\n \n Start Internet Explorer→[Tools]→[Internet Options...]→[General] tab→\nClick [Settings...] under [Temporary Internet files]→\nCheck [Every visit to the page] under [Check for newer versions of stored pages:]→\n[OK]→[OK]→Complete\n");

contentsDictionary["id_om01_0389"] = new ContentsDictionaryEntry("12.4 About the MPEG-4 Viewer Program", "12.4 About the MPEG-4 Viewer Program \n The MPEG-4 viewer program is an ActiveX Control that is used to play MPEG-4 files within Internet Explorer. This software is installed automatically the first time you view MPEG-4 videos.\n A software license for the MPEG-4 decoder is included with the MPEG-4 viewer program, and the license is valid for 1 PC. Please read the included End-User License Agreement before installing the viewer program. When installing the MPEG-4 viewer program on additional PCs, please purchase additional licenses (Model No. BB-HCA5A for BB-HCM527A/BB-HCM547A, BB-HCA5CE for BB-HCM527CE/BB-HCM547CE).\n Uninstalling the MPEG-4 viewer program\n Follow the procedure below to uninstall the MPEG-4 viewer program.\n \n 1. Confirm that Internet Explorer is not running→Start Internet Explorer→[Tools]→\n[Internet Options...]→[General] tab→Click [Settings...] under [Temporary Internet files]→\nClick [View Objects...]→Right-click on [pmpeg4cam Class]→[Remove]→[Yes]\n \n 2. Open the [ocx] folder on the CD-ROM→Open the [MPEG-4] folder→Double-click [uninstall.bat]\n \n \n Note\n • When using Windows Vista, you must be logged into your PC as a user with Administrator privileges. For more information, open the [ocx] folder on the CD-ROM, then open the [MPEG-4] folder on the CD-ROM and double-click [ReadmeEng.txt].\n \n • Refer to the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) for more information.\n \n \n \n \n");

contentsDictionary["id_om01_0274"] = new ContentsDictionaryEntry("Section 13 Using the Setup Program", "Section 13 Using the Setup Program \n The Setup Program, found on the included CD-ROM, can be used to:\n – Find cameras on the LAN and confirm information (IP address, firmware version, status, etc.) as needed (see Finding cameras on the LAN).\n \n – Configure a camera’s network settings (see Configuring a camera’s network settings).\n \n – Update a camera’s firmware (see Updating a camera’s firmware).\n \n – Save a configuration file of a camera’s settings to your PC (see Saving settings in a configuration file).\n \n – Restore the settings saved in a configuration file on your PC (see Restoring settings from a configuration file).\n \n \n Note\n • Although the above can be performed by accessing a camera directly, using the Setup Program is convenient when you want to configure several cameras because there is no need to access each camera individually with your web browser.\n \n • When the camera is connected in IPv6 mode, the Setup Program can be used only to find and confirm cameras on the LAN (other Setup Program features are not available).\n \n • If you are using firewall or antivirus software on your PC, the Setup Program may not be able to find any cameras on your network. If you cannot disable your firewall or antivirus software, you can find the camera by entering its MAC address. Click [Search by MAC Address], then enter the camera’s MAC address. (The MAC address is printed on a label affixed to the camera.)\n \n \n \n Finding cameras on the LAN\n 1. Insert the included CD-ROM into the CD-ROM drive of your PC.\n • The Setup Program starts. If the program does not start, double-click Setup.exe found on the CD-ROM.\n \n \n \n 2. Click [Search for Cameras].\n \n 3. Wait for the Setup Program to find all cameras on the network and display their information.\n • If the desired camera is not displayed, confirm it is turned on and connected to the network.\n \n • If the desired camera is not displayed, you can find the camera by entering its MAC address. Click [Search by MAC Address], then enter the camera’s MAC address. (The MAC address is printed on a label affixed to the camera.)\n \n \n \n 4. Confirm the information as needed.\n \n \n \n Configuring a camera’s network settings\n 1. Find the camera on the LAN (see Finding cameras on the LAN).\n \n 2. Select the desired camera.\n \n 3. Click [Network Settings].\n • If more than 20 minutes have passed since the selected camera was turned on, you cannot configure the camera. Turn off the camera, then turn it on again. This restriction does not apply to cameras which have not been configured yet or have been reset to their factory default settings.\n \n \n \n 4. Change the camera name as desired (max. 15 characters).\n • See 14.2 ASCII Character Table for a list of valid characters. Note that [Space], [\"], ['], [&], [<], and [>] cannot be entered.\n \n \n \n 5. Select the desired connection mode, and enter the appropriate settings. See 5.1.1 Network (IPv4) Settings for details about each setting.\n – [Automatic Setup]: Configures the camera automatically based on your network’s settings.\n \n – [Specify an IP Address]: Allows you to assign a static IP address. Refer to your ISP or network administrator for more information.\n a. Specify an IP address corresponding to your network’s settings.\n \n b. Specify the subnet mask of your network.\n \n c. Enter the default gateway (the IP address of your router).\n \n d. Enter the IP address of the DNS server(s).\n \n e. Specify the maximum bandwidth the camera is allowed to use.\n \n \n \n – [DHCP]: Allows the camera to be configured automatically by your network’s DHCP server (usually your router). Refer to your ISP or network administrator for more information.\n a. Enter the host name if required by your ISP or network administrator.\n \n b. Enter the default gateway if required by your ISP or network administrator.\n \n c. Enter the IP address of the DNS server(s). Refer to your ISP or network administrator for more information.\n \n d. Specify the maximum bandwidth the camera is allowed to use.\n \n \n \n \n \n 6. Click [Save].\n \n 7. Follow the on-screen prompts.\n \n \n \n Updating a camera’s firmware\n 1. Download the latest firmware from the Panasonic Network Camera website (http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html) and save it on your PC.\n \n 2. Insert the included CD-ROM into the CD-ROM drive of your PC.\n • The Setup Program starts. If the program does not start, double-click Setup.exe found on the CD-ROM.\n \n \n \n 3. Click [Update Firmware]. A dialog prompts you to specify the location of the firmware file.\n \n 4. Select the firmware file you downloaded from the Panasonic Network Camera website and click [Open].\n \n 5. Select the camera you would like to update.\n • Only cameras which are compatible with the selected firmware file are displayed.\n \n • You can select multiple cameras if desired.\n \n \n \n 6. Enter the administrator user name and password when prompted, then click [OK].\n \n 7. Click [Execute].\n • [Firmware updated successfully.] is displayed when the firmware has been updated.\n \n \n \n 8. Click [Save Log] to save a log of the firmware revision.\n \n 9. Click [OK] when finished.\n \n \n \n Saving settings in a configuration file\n 1. Insert the included CD-ROM into the CD-ROM drive of your PC.\n • The Setup Program starts. If the program does not start, double-click Setup.exe found on the CD-ROM.\n \n \n \n 2. Click [Save Settings to PC/Save Settings to Camera].\n \n 3. Select the desired camera, enter the camera’s administrator user name and password when prompted, then click [OK].\n \n 4. Click [Save Settings to PC].\n \n 5. Specify a location to save the file, then click [Save].\n \n 6. When [Settings were saved on the PC.] is displayed, click [OK].\n \n \n Note\n • Buffered images are not saved in the configuration file.\n \n • The configuration file’s extension (.dat) must not be changed. If you change it, the saved settings cannot be restored.\n \n \n • If you save a configuration file and then update the camera’s firmware later, the configuration file may not be able to be restored properly. If you regularly save a configuration file of the cameras settings, remember to save a configuration file after you update the camera’s firmware.\n \n \n \n \n Restoring settings from a configuration file\n 1. Insert the included CD-ROM into the CD-ROM drive of your PC.\n • The Setup Program starts. If the program does not start, double-click Setup.exe found on the CD-ROM.\n \n \n \n 2. Click [Save Settings to PC/Save Settings to Camera].\n \n 3. Click [Save Settings to Camera]. A dialog prompts you to specify the location of the saved configuration file.\n \n 4. Specify the configuration file and click [Open].\n \n 5. Select the desired camera, enter the camera’s administrator user name and password when prompted, then click [OK].\n \n 6. Click [Execute]. A dialog displays the status.\n \n 7. After the settings have been restored to the camera, the camera will restart automatically.\n \n 8. Click [OK] when finished.\n \n \n Note\n • Network settings and the administrator user name and password are not changed when you restore a configuration file using the Setup Program.\n \n \n \n \n");

contentsDictionary["id_om01_0275"] = new ContentsDictionaryEntry("Section 14 Technical Information", "Section 14 Technical Information \n");

contentsDictionary["id_om01_0182"] = new ContentsDictionaryEntry("14.1 Cleaning the Camera", "14.1 Cleaning the Camera \n For best performance, we recommend cleaning the camera periodically. Turn the camera off before cleaning it.\n Cleaning the main unit\n Clean the main unit with a dry and soft cloth.\n \n \n Note\n • Do not use alcohol, polishing powder, cleanser, benzine, thinner, wax, petroleum products, pesticides, glass cleaners, hair spray, or hot water when cleaning the camera, as they may cause a change in the shape or color of the camera.\n \n • Do not directly touch the lens cover. Fingerprints may cause the image to be out of focus.\n \n • BB-HCM547 only: The BB-HCM547 features a splash-resistant body, but it is not waterproof. Do not pour water directly on the camera or get it wet, such as with a hose.\n \n \n \n \n");

contentsDictionary["id_om01_0398"] = new ContentsDictionaryEntry("14.2 ASCII Character Table", "14.2 ASCII Character Table \n [Space]\n 0\n @\n P\n `\n p\n !\n 1\n A\n Q\n a\n q\n \"\n 2\n B\n R\n b\n r\n #\n 3\n C\n S\n c\n s\n $\n 4\n D\n T\n d\n t\n %\n 5\n E\n U\n e\n u\n &\n 6\n F\n V\n f\n v\n '\n 7\n G\n W\n g\n w\n (\n 8\n H\n X\n h\n x\n )\n 9\n I\n Y\n i\n y\n *\n :\n J\n Z\n j\n z\n +\n ;\n K\n [\n k\n {\n ,\n <\n L\n \\\n l\n |\n -\n =\n M\n ]\n m\n }\n .\n >\n N\n ^\n n\n ~\n /\n ?\n O\n _\n o\n  \n \n");

contentsDictionary["id_om01_0399"] = new ContentsDictionaryEntry("14.3 Internal Memory Capacity for Buffered Images", "14.3 Internal Memory Capacity for Buffered Images \n The camera’s internal memory can buffer images according to the table below.\n Note\n • All values are approximate.\n \n \n \n JPEG images (videos and still images)\n Resolution\n Specification\n Snapshot\n Image Quality\n Favor Clarity\n Standard\n Favor Motion\n 640 × 480\n File Size\n 50 KB\n 50 KB\n 35 KB\n 27 KB\n No. of Images\n (Saved to PC)\n 300\n 440\n 570\n 320 × 240\n File Size\n 25 KB\n 25 KB\n 16 KB\n 10 KB\n No. of Images\n (Saved to PC)\n 620\n 970\n 1500\n 192 × 144\n File Size\n 10 KB\n 10 KB\n 7 KB\n 5 KB\n No. of Images\n (Saved to PC)\n 1500\n 2200\n 3100\n \n Note\n • The maximum number of images that can be buffered depends on image resolution and image quality.\n \n \n \n \n MPEG-4 videos\n For information about MPEG-4 image capacity, see the Panasonic Network Camera website at http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html.\n Note\n • The maximum amount of video that can be buffered depends on image resolution, network bandwidth, and the frame rate and bit rate set for the streaming method.\n \n \n \n \n");

contentsDictionary["id_om01_0404"] = new ContentsDictionaryEntry("14.4 SD Memory Card Capacity for Buffered Images", "14.4 SD Memory Card Capacity for Buffered Images \n The camera supports the following Panasonic SD/SDHC memory cards.\n SD memory cards:\n • 2 GB: RP-SDV02G\n \n • 1 GB: RP-SDV01G\n \n • 512 MB: RP-SDR512\n \n • 256 MB: RP-SDR256\n \n • 128 MB: RP-SD128B\n \n • 64 MB: RP-SD064B\n \n \n SDHC memory cards:\n • 4 GB or higher\n \n \n For information about SD/SDHC memory card capacity, see the Panasonic Network Camera website at http://panasonic.co.jp/pcc/products/en/netwkcam/support/info.html.\n Note\n • The maximum number of JPEG images that can be buffered depends on image resolution and image quality.\n \n • The maximum amount of MPEG-4 video that can be buffered depends on image resolution, network bandwidth, and the frame rate and bit rate set for the streaming method.\n \n \n \n");

contentsDictionary["id_om01_0400"] = new ContentsDictionaryEntry("14.5 Default Setting List", "14.5 Default Setting List \n Single\n Parameter\n Default\n Value Range\n Pan/Tilt Range\n Pan: -175° – +175°\nTilt: 0° – +82°\n Pan: -175° – +175°\nTilt: 0° – +82°\n Preset\n –\n Presets 1–20, Home Position, Alarm1, Alarm2\n Brightness\n STD\n 9 levels\n Backlight\n –\n On, Off\n White Balance\n Auto\n Auto, Indoor, Fluorescent (White), Fluorescent (Daylight), Outdoor, Hold\n Output\n Open\nShort\n –\n Refresh Rate\n MJPEG\n MPEG-4, MJPEG, 3 s, 5 s, 10 s, 30 s, 60 s\n Resolution\n 320 × 240\n 640 × 480, 320 × 240, 192 × 144\n Image Quality\n Standard\n Favor Clarity, Standard, Favor Motion\n Streaming Method\n Auto\n Auto, Multicast, Unicast, HTTP\n \n \n Multi\n Parameter\n Default\n Value Range\n Layout\n 4 Screens\n 4 Screens, 9 Screens, 16 Screens\n View Type\n 1–4\n 1–4, 5–8, 9–12, 13–16\n Refresh Rate\n MJPEG\n MPEG-4, MJPEG, 3 s, 5 s, 10 s, 30 s, 60 s\n Resolution\n 320 × 240\n 320 × 240, 192 × 144\n \n \n Network (IPv4)\n Parameter\n Default\n Value Range\n Connection Mode\n Connection Mode\n Automatic Setup\n Automatic Setup, Static, DHCP\n Proxy Server Settings\n  \n Address\n –\n –\n Port No.\n 8080\n 1–65535\n Login ID\n –\n –\n Password\n –\n –\n Network Configuration from Setup Program\n Network Configuration from Setup Program (Available for Static and DHCP connection only)\n Enable\n Enable, Disable\n Internet Connection\n Port No. (Available for Static and DHCP connection only)\n 80\n 1–65535\n IP Address (Available for Static connection only)\n 192.168.0.253\n –\n Subnet Mask (Available for Static connection only)\n 255.255.255.0\n –\n Host Name (Available for DHCP connection only)\n –\n –\n Default Gateway\n Default Gateway (Available for Static and DHCP connection only) \n –\n –\n DNS\n Primary Server Address (Available for Static and DHCP connection only)\n –\n –\n Secondary Server Address (Available for Static and DHCP connection only)\n –\n –\n Max. Bandwidth Usage\n Max. Bandwidth Usage (Mbps)\n Unlimited\n Unlimited, 0.1, 0.2, 0.3, 0.5, 1, 2, 3 Mbps\n Connection Type\n Connection Type\n Auto Negotiation\n Auto Negotiation, 100 Mbps/Full Duplex, 100 Mbps/Half Duplex, 10 Mbps/Full Duplex, 10 Mbps/Half Duplex\n \n \n Network (IPv6)\n Parameter\n Default\n Value Range\n Connection Mode\n Connection Mode\n Automatic Setup\n Automatic Setup,Static\n Internet Connection\n Port No. (Available for Static connection only)\n 80\n 1–65535\n IP Address (Available for Static connection only)\n –\n –\n Default Gateway\n Default Gateway (Available for Static connection only)\n –\n –\n DNS\n Primary Server Address\n –\n –\n Secondary Server Address\n –\n –\n Max. Bandwidth Usage\n Max. Bandwidth Usage (Mbps)\n Unlimited\n Unlimited, 0.1, 0.2, 0.3, 0.5, 1, 2, 3 Mbps\n Connection Type\n Connection Type\n Auto Negotiation\n Auto Negotiation, 100 Mbps/Full Duplex, 100 Mbps/Half Duplex, 10 Mbps/Full Duplex, 10 Mbps/Half Duplex\n \n \n HTTPS\n Parameter\n Default\n Value Range\n HTTPS\n Use HTTP\n Use HTTPS, Use HTTP\n Certificate Information\n Camera IP Address or Host Name \n –\n –\n \n \n UPnP\n Parameter\n Default\n Value Range\n Auto Port Forwarding\n Disable\n Enable, Disable\n Display Shortcut Icon in My Network Places\n Enable\n Enable, Disable\n \n \n DynamicDNS \n Parameter\n Default\n Value Range\n DynamicDNS\n Disable\n Viewnetcam.com, User-specified DynamicDNS, Disable\n User-specified DynamicDNS\n DynamicDNS Server URL \n –\n –\n Updating time\n 10 min\n At the time of starting, 10 min, 30 min, 1 h, 3 h, 6 h, 12 h, 24 h\n Input User Name and Password\n User Name\n –\n –\n Password\n –\n –\n Viewnetcam.com configuration\n Updating time\n 60 min\n 10 min, 20 min, 30 min, 40 min, 50 min, 60 min\n Global IP Address Notification Method\n Normal\n Normal, Advanced\n \n \n Date and Time\n Parameter\n Default\n Value Range\n Time Setting\n Date\n –\n –\n Format\n AM/PM\n AM/PM, 24H\n Time\n –\n –\n Automatic Time Adjustment\n Enable\n Disable\n –\n NTP Server Address or Host Name\n –\n –\n Time Zone\n BB-HCM527A/BB-HCM547A:\n GMT -05:00 Eastern Time\n BB-HCM527CE/BB-HCM547CE:\n GMT 00:00 Western Europe Time\n –\n Adjust Clock for Daylight Saving Time/Summer Time\n Enable\n Disable\n –\n Start Day\n BB-HCM527A/BB-HCM547A:\n Mar Second Sunday 2 AM\n BB-HCM527CE/BB-HCM547CE:\n Mar Last Sunday 1 AM\n –\n End Day\n BB-HCM527A/BB-HCM547A:\n Nov First Sunday 2 AM\n BB-HCM527CE/BB-HCM547CE:\n Oct Last Sunday 1 AM\n –\n \n \n Camera\n Parameter\n Default\n Value Range\n AC Power Source Frequency\n BB-HCM527A/BB-HCM547A:\n 60 Hz\n BB-HCM527CE/BB-HCM547CE:\n 50 Hz\n 50 Hz, 60 Hz\n Return to Specified Position\n Time\n Do not move\n Do not move, 10 s, 20 s, 30 s, 1 min, 5 min, 10 min, 30 min, 1 h\n Specified Position\n Home Position\n Home Position, Alarm No.1, Alarm No.2, Presets 1–20\n Shutter Speed/Color Night View\n Shutter Speed 1/15 s\n 50 Hz:\n 1/15 s, 1/50 s, 1/100 s, 1/250 s, 1/500 s, 1/1000 s\n Color Night View\n 60 Hz:\n 1/15 s, 1/30 s, 1/60 s, 1/120 s, 1/250 s, 1/500 s, 1/1000 s\n Color Night View\n \n \n Audio\n Parameter\n Default\n Value Range\n Output\n Enable\n Enable, Disable\n Volume\n Standard\n Minimum, Standard, Maximum\n PC Audio Input Timeout\n 1 min\n 1 min, 2 min, 3 min, 5 min, 10 min, 20 min, 30 min, 60 min\n Input\n Enable\n Enable, Disable\n Camera Microphone Sensitivity\n Standard\n Minimum, Standard, Maximum\n Mute during Pan/Tilt/Zoom\n Enable\n Enable, Disable\n \n \n Video Streaming\n Parameter\n Default\n Value Range\n MPEG-4 Max. Frame Rate\n 640 × 480\n 30 Frames/Sec.\n 5, 10, 15, 20, 25, 30 frames/sec.\n 320 × 240\n 30 Frames/Sec.\n 5, 10, 15, 20, 25, 30 frames/sec.\n 192 × 144\n 30 Frames/Sec.\n 5, 10, 15, 20, 25, 30 frames/sec.\n MPEG-4 Bit Rate\n 640 × 480\n 192 Kbps–768 Kbps\n 192, 256, 384, 512, 768, 1024, 1536, 2048\n 320 × 240\n 64 Kbps–384 Kbps\n 64, 128, 192, 256, 384, 512, 768, 1024\n 192 × 144\n 32 Kbps–128 Kbps\n 32, 64, 128, 192, 256, 384, 512\n RTSP \n Port No.\n 554\n 1–65535\n RTP\n Port No.\n 33000\n 2–65400 (must be an even number)\n Multicast\n Multicast settings screen is displayed.\n Not checked\n –\n Packet Availability Time\n TTL\n 5\n 1–255\n Multicast (IPv4)\n Use\n Not checked\n –\n Address\n 231.244.244.241\n –\n MPEG-4 Port No.\n 30000–30006\n 2000–65520 (must be an even number)\n Audio Port No.\n 30020\n 2000–65520 (must be an even number)\n Multicast (IPv6)\n Use\n Not checked\n –\n Address\n ff1e::0010\n –\n MPEG-4 Port No.\n 30100–30106\n 2000–65520 (must be an even number)\n Audio Port No.\n 30120\n 2000–65520 (must be an even number)\n \n \n Administrator\n Parameter\n Default\n Value Range\n General Authentication\n Do not permit access from guest users\n Permit access from guest users, Permit access from guest users (mobile only), Do not permit access from guest users\n Administrator Authentication\n User Name\n –\n –\n Password\n –\n –\n Retype Password\n –\n –\n \n \n General User\n Parameter\n Default\n Value Range\n User ID List\n –\n –\n Input User Name and Password\n User Name\n –\n –\n Password\n –\n –\n Retype Password\n –\n –\n Access Level\n Video Display Time\n Not permitted\n Not permitted, Unlimited, 10 s, 30 s, 1 min, 5 min, 10 min, 30 min, 60 min\n Refresh Rate\n 3 s\n 3 s, 5 s, 10 s, 30 s, 60 s\n All Features\n All unchecked\n –\n \n \n Guest User\n Parameter\n Default\n Value Range\n Access Level\n Video Display Time\n Not permitted\n Not permitted, Unlimited, 10 s, 30 s, 1 min, 5 min, 10 min, 30 min, 60 min\n Refresh Rate\n 3 s\n 3 s, 5 s, 10 s, 30 s, 60 s\n All Features\n All unchecked\n –\n \n \n Trigger\n Parameter\n Default\n Value Range\n Trigger Setting\n Enable Image Buffer/Transfer\n Disable\n –\n Trigger\n No. 1: Motion Detection\n No. 2–5: Timer\n Timer, Alarm1, Alarm2, Motion Detection\n Alarm enable condition\n Rising: GND to Open (High).\n Rising: GND to Open (High).\nFalling: Open (High) to GND.\n Time\n Days\n All days checked\n –\n Active Time of Trigger\n Always\n –\n Image Setting\n Format\n JPEG\n JPEG, MPEG-4\n Image Resolution\n 320 × 240\n 640 × 480, 320 × 240,\n 192 × 144\n Image Quality\n Standard\n Favor Clarity, Standard, Favor Motion\n Lens Position When Triggered\n When triggered,\n Do not move\n Do not move, Home Position, Alarm No.1, Alarm No.2, Presets 1–20\n External Output\n Control Time\n None\n None, 1 s, 3 s, 5 s, 10 s, 30 s, 1 min, 3 min, 5 min, 10 min, 30 min, When Recording\n Image Buffer Frequency (for timer triggers)\n Image Buffer Frequency\n No. 1: Buffer 5 images every 1 second\n No. 2–5: Buffer 1 image every 1 second\n 1 image every hour–30 images every second\n Image Buffer Frequency (for alarm and motion detection triggers)\n Enable Pre-trigger Image Buffer\n No. 1: Enabled\n No. 2–5: Not enabled \n –\n Image Buffer Frequency\n No. 1: Buffer 5 images every 1 second, total of 5 images\n No. 2–5: Buffer 1 image every 1 second, total of 1 image\n 1 image every minute–30 images every second. Total 1–600 images. \n Enable Post-trigger Image Buffer\n Enabled\n –\n Image Buffer Frequency\n No. 1: Buffer 5 images every 1 second, total of 20 images\n No. 2–5: Buffer 1 image every 1 second, total of 1 image\n JPEG: 1 image every minute–30 images every second. Total 1–1500 images.\n MPEG-4: 1–10 (640 × 480), 1–20 (320 × 240), or 1–40 (192 × 144) seconds of video\n Sensor deactivation time setting\n Sensor deactivation time\n None\n None, 10 s, 30 s, 1 min, 3 min, 5 min, 10 min \n Transfer Method\n Transfer Method\n No. 1: No Transfer, Memory Overwrite\n No. 2–5: No Transfer, No Memory Overwrite\n No Transfer, No Memory Overwrite\nNo Transfer, Memory Overwrite\nFTP\nE-mail\nHTTP\n Send Notification When Triggered\n Send Notification When Triggered\n Disable\n Disable, Send E-mail Notification, Send HTTP Notification\n FTP\n Server IP Address or Host Name\n –\n –\n Port No.\n 21\n 1–65535\n Login ID\n –\n –\n Password\n –\n –\n Login Timing\n Every Time\n Every Time, One Time\n Upload File Name\n –\n –\n Overwrite setting\n Overwrite File\n Overwrite File, Save as New File with Time Stamp\n Data Transfer Method\n Passive Mode\n Passive Mode, Active Mode\n E-mail Transfer\n SMTP Server IP Address or Host Name\n –\n –\n Port No.\n 25\n 1–65535\n Reply E-mail Address\n –\n –\n Destination E-mail Address 1\n –\n –\n Destination E-mail Address 2\n –\n –\n Destination E-mail Address 3\n –\n –\n Subject\n –\n –\n Text\n –\n –\n How to authenticate\n No authentication\n Checked\n No authentication, POP before SMTP authentication, SMTP authentication\n POP before SMTP authentication\n POP3 Server IP Address or Host Name\n –\n –\n Port No.\n 110\n 1–65535\n Login ID\n –\n –\n Password\n –\n –\n SMTP authentication\n Login ID\n –\n –\n Password\n –\n –\n HTTP \n Host Name\n –\n –\n Port No.\n 80\n 1–65535\n Login ID\n –\n –\n Password\n –\n –\n Upload File Name\n –\n –\n Overwrite setting\n Overwrite File\n Overwrite File, Save as New File with Time Stamp\n E-mail Notification When Triggered\n SMTP Server IP Address or Host Name\n –\n –\n Port No.\n 25\n 1–65535\n Reply E-mail Address\n –\n –\n Destination E-mail Address 1\n –\n –\n Destination E-mail Address 2\n –\n –\n Destination E-mail Address 3\n –\n –\n Subject\n –\n –\n Text\n –\n –\n How to authenticate\n No authentication\n Checked\n No authentication, POP before SMTP authentication, SMTP authentication\n POP before SMTP authentication\n POP3 Server IP Address or Host Name\n –\n –\n Port No.\n 110\n 1–65535\n Login ID\n –\n –\n Password\n –\n –\n SMTP authentication\n Login ID\n –\n –\n Password\n –\n –\n HTTP Notification\n Host Name\n –\n –\n Port No.\n 80\n 1–65535\n Login ID\n –\n –\n Password\n –\n –\n File Path\n –\n –\n \n \n Motion Detection\n Parameter\n Default\n Value Range\n Threshold\n Third bar from the left\n –\n Sensitivity\n Center\n –\n \n \n Alarm Log \n Parameter\n Default\n Value Range\n A setup of operation\n A setup of operation\n Never send alarm logs\n Never send alarm logs,\nAlways send alarm logs,\nSend alarm logs only when the camera was triggered, Send alarm logs only when the camera was not triggered\n Active Time\n Days\n All days checked\n –\n Time\n PM12h 0min\n –\n Notice setup of an alarm log\n SMTP Server IP Address or Host Name\n –\n –\n Port No.\n 25\n 1–65535\n Reply E-mail Address\n –\n –\n Destination E-mail Address 1\n –\n –\n Destination E-mail Address 2\n –\n –\n Destination E-mail Address 3\n –\n –\n Subject\n Alarm Log\n –\n How to authenticate\n No authentication\n Checked\n No authentication, POP before SMTP authentication, SMTP authentication\n POP before SMTP authentication\n POP3 Server IP Address or Host Name\n –\n –\n Port No.\n 110\n –\n Login ID\n –\n –\n Password\n –\n –\n SMTP authentication\n Login ID\n –\n –\n Password\n –\n –\n \n \n Image Display \n Parameter\n Default\n Value Range\n Camera Name\n Camera Name\n NetworkCamera\n –\n Single Camera\n Refresh Rate\n MJPEG\n MPEG-4, MJPEG, 3 s, 5 s, 10 s, 30 s, 60 s\n Image Resolution\n 320 × 240\n 640 × 480, 320 × 240, 192 × 144\n Image Quality (MJPEG or still images only)\n Standard\n Favor Clarity, Standard, Favor Motion\n Streaming Method (MPEG-4 only)\n Auto\n Auto, Multicast, Unicast, HTTP\n Multi-Camera\n Refresh Rate\n MJPEG\n MPEG-4, MJPEG, 3 s, 5 s, 10 s, 30 s, 60 s\n Image Resolution\n 320 × 240\n 320 × 240, 192 × 144\n Image Quality\n Standard\n Favor Clarity, Standard, Favor Motion\n Mobile Phone\n Image Resolution\n 192 × 144\n 320 × 240, 192 × 144\n Overlay Setting\n Date and Time\n Not checked\n –\n Date Format\n BB-HCM527A/BB-HCM547A:\n MMM.DD,YY\n BB-HCM527CE/BB-HCM547CE:\n DD MMM,YY\n YY/MM/DD\n  \n MMM.DD,YY\n  \n DD MMM,YY\n Text\n Not checked\n –\n Text\n –\n –\n Status\n Not checked\n –\n Language\n Language\n English\n English, Japanese, French, German, Italian, Spanish, Simplified Chinese, Russian, Korean\n Banner Display\n Enable\n Not checked\n –\n Banner user\n All users\n All users, Administrator only, General user only\n Image URL\n –\n –\n Link URL\n –\n –\n \n \n Multi-Camera\n Parameter\n Default\n Value Range\n Multi-Camera\n –\n –\n Display\n On\n –\n HTTPS\n Do not use\n Use, Do not use\n IP Address or Host Name\n selfcamera\n –\n Port No.\n –\n 1–65535\n Camera Name\n (Camera’s model no.)\n –\n \n \n Operation Time\n Parameter\n Default\n Value Range\n Enable\n Not checked\n Enable, Disable\n Days\n All days checked\n –\n Operation Time\n Always\n Always, specified time\n \n \n External Output\n Parameter\n Default\n Value Range\n External Device Control Output\n Open\n Open, Short to GND\n Button name modification\n Open\nShort\n –\n \n \n Analog Video Output\n Parameter\n Default\n Value Range\n Analog Video Output\n Disable\n Enable, Disable\n Analog Video Output Signal Type\n NTSC\n NTSC, PAL\n \n \n Indicator Control\n Parameter\n Default\n Value Range\n Indicator Control\n Turn indicator on when camera is on.\n Turn indicator on when camera is on.\nTurn indicator on during camera access.\nNever turn indicator on.\n \n \n Internet\n Parameter\n Default\n Value Range\n Auto Port Forwarding (IPv4)\n Disable\n Enable, Disable\n Viewnetcam.com Registration\n Do not register with Viewnetcam.com\n Register with Viewnetcam.com, Do not register with Viewnetcam.com\n Allow Access from the Internet (IPv6)\n No\n Yes, No\n \n \n Restart\n Parameter\n Default\n Value Range\n Scheduled Restart\n Disable\n Enable, Disable\n Days\n All days checked\n –\n Time of Restart\n AM12h00min\n –\n \n \n Detection Notification Sound\n Parameter\n Default\n Value Range\n Play Sound on Detection\n Disable\n Enable, Disable\n Sound File\n –\n –\n Playback Time\n 5 s \n 1–10 s\n Motion Detection\n Not use\n Not use, Use\n Alarm1: Alarm enable condition\n Not use\n Not use\n  \n Rising: GND to Open (High).\n  \n Falling: Open (High) to GND.\n Alarm2: Alarm enable condition\n Not use\n Not use\n  \n Rising: GND to Open (High).\n  \n Falling: Open (High) to GND.\n \n * Settings are stored on the computer, and are therefore not reset to their default values when the camera is reset.\n \n");

contentsDictionary["id_om01_0197"] = new ContentsDictionaryEntry("14.6 Specifications", "14.6 Specifications \n Camera Specifications\n Items\n Specifications\n Zoom\n 4.6× zoom (2.3× optical zoom, 2× digital zoom)\n Pan/Tilt Angle\n Pan: -175 ° to +175 °\n Tilt: 0 ° to +82 °\n Number of Pixels\n 1/3.6 inch MOS sensor, 370,000 pixels\n Illuminance\n 2–100,000 lx (0.2–100,000 lx when in Color Night View mode)\n White Balance\n Auto/Manual/Hold\n Lens Brightness\n 9 levels\n Focus\n Fixed, 0.75 m–Infinity\n Minimum Object Distance\n 0.75 m (2 feet 6 inches)\n Aperture (F No.)\n Wide: F1.9\n Tele: F2.8\n Horizontal Viewing Angle\n Wide: 73 °\n Tele: 32 ° (2.3× optical zoom); 16 ° (4.6× zoom)\n Vertical Viewing Angle\n Wide: 55 °\n Tele: 24 ° (2.3× optical zoom); 12 ° (4.6× zoom)\n Exposure\n Auto\n \n \n Other Specifications\n Items\n Specifications\n Splash Resistant Standard(BB-HCM547 only)\n IPX4*1 \n Image Compression\n JPEG (3 levels), MPEG-4\n Image Resolution\n 640 × 480, 320 × 240, 192 × 144\n Buffered Images*2 \n About 970 frames (320 × 240, standard image quality) with time display (when SD memory card is not inserted)\n Audio Communication\n 2-way Half Duplex\n Audio Compression Format\n ADPCM 32 kbps\n Audio Bandwidth\n 300 Hz–3.4 KHz\n Audio Reception Method\n ActiveX\n Audio Reception Decoding\n ActiveX\n Audio Input\n Built-in microphone, external microphone input terminal\n External Microphone Input Terminal*3 \n 3.5 mm jack\n Audio Output\n Audio line output terminal for external speaker\n Audio Output Terminal*3 \n 3.5 mm stereo jack (output is mono)\n Video Output\n Analog composite (NTSC/PAL)\n Video Output Terminal*3 \n 3.5 mm jack\n External Input/Output Interface\n External sensor input ×  2\n External output ×  1\n SD Card Slot\n Full size\n Frame Rate*4 \n Max. 30 frames/second (640 × 480*5, 320 × 240, 192 × 144)\n Communication Protocols\n IPv4/IPv6 Dual-Stack \nIPv4: \nTCP, UDP, IP, HTTP, FTP, SMTP, DHCP, DNS, ARP, ICMP, POP3, NTP, UPnP™, SMTP Authentication, RTP, RTSP, RTCP, HTTPS, SSL, TLS\n IPv6: \nTCP, UDP, IP, HTTP, FTP, SMTP, DNS, ICMPv6, POP3, NDP, NTP, RTP, RTSP, RTCP, HTTPS, SSL, TLS\n Image Buffer/Transfer Triggers\n Timer, Alarm 1, Alarm 2, Motion Detection\n Image Transfer Method\n SMTP*6, FTP, HTTP\n LAN Interface\n 10Base-T/100Base-TX Ethernet RJ-45 connector\n Indicator Display\n Power\nCamera Operation\nEthernet Link\n Dimensions (W×H×D)\n 115 mm × 153 mm × 153 mm\n(4 1/2 inches × 6 inches × 6 inches)\n Weight (Main Unit Only)\n BB-HCM527: 670 g (1.48 lb)\n BB-HCM547: 690 g (1.52 lb)\n Power Supply\n Optional AC adaptor (Model No. BB-HCA3A)\n Input 100–120 V AC, 50/60 Hz\n Output 12 V DC, 750 mA\n Optional AC adaptor (Model No. BB-HCA3CE/BB-HCA3E)\n Input 100–240 V AC, 50/60 Hz\n Output 12 V DC, 750 mA\n PoE\n PoE standard IEEE802.3af-2003\n Power Consumption\n When Using an Optional AC Adaptor (Model No. BB-HCA3A)\nAbout 4.4 W (8.5 W during pan/tilt scan)\n When Using an Optional AC Adaptor (Model No. BB-HCA3CE/BB-HCA3E)\nAbout 4.4 W (8.5 W during pan/tilt scan)\n When Using PoE \nAbout 4.4 W (7.9 W during pan/tilt scan)\n Operating Temperature\n BB-HCM527:\n Operation: +0 °C (+32 °F) to +40 °C (+104 °F)\nStorage: +0 °C (+32 °F) to +50 °C (+122 °F)\n BB-HCM547:\n Operation: -20 °C (-4 °F) to +50 °C (+122 °F)\n Storage: -25 °C (-13 °F) to +60 °C (+140 °F)\n Operating Humidity\n BB-HCM527:\n Operation: 20 %–80 % (no condensation)\nStorage: 20 %–90 % (no condensation)\n BB-HCM547:\n Operation: 20 %–90 % (no condensation)\nStorage: 20 %–90 % (no condensation)\n \n *1 When the camera is installed according to the instructions provided in the included documentation, and the camera has been properly waterproofed.\n \n *2 See 14.3 Internal Memory Capacity for Buffered Images for details.\n \n *3 A customer-provided audio/video cable is needed to connect an external microphone, speaker, or TV.\n \n *4 Frame rate may slow down depending on the network environment, PC performance, image quality, SD memory recording, when viewing dark images, etc.\n \n *5 30 frames/second is not possible when viewing MJPEG images at 640 × 480 resolution.\n \n *6 The camera supports POP Before SMTP Authentication and SMTP Authentication. PLAIN, LOGIN, and CRAM-MD5 SMTP Authentication are supported.\n \n \n \n");

var dbArray = [];

dbArray[0] = [];

dbArray[0].manualTitle = "Troubleshooting Guide";

dbArray[0][0] = new DbEntry("gs01/id_gs01_0032.htm#id_gs01_0032", "Troubleshooting Guide", "id_gs01_0032", ["id_gs01_0032"]);

dbArray[0][1] = new DbEntry("gs01/id_gs01_0033.htm#id_gs01_0033", "Introduction", "id_gs01_0033", ["id_gs01_0033"]);

dbArray[0][2] = new DbEntry("gs01/id_gs01_0022.htm#id_gs01_0022", "1 Troubleshooting", "id_gs01_0022", ["id_gs01_0022"]);

dbArray[0][3] = new DbEntry("gs01/id_gs01_0038.htm#id_gs01_0038", "1.1 Understanding the Camera Indicator", "id_gs01_0038", ["id_gs01_0038"]);

dbArray[0][4] = new DbEntry("gs01/id_gs01_0023.htm#id_gs01_0023", "1.2 Camera Indicator Issues", "id_gs01_0023", ["id_gs01_0023"]);

dbArray[0][5] = new DbEntry("gs01/id_gs01_0024.htm#id_gs01_0024", "1.3 Camera Setup Issues", "id_gs01_0024", ["id_gs01_0024"]);

dbArray[0][6] = new DbEntry("gs01/id_gs01_0025.htm#id_gs01_0025", "1.4 Camera Access Issues", "id_gs01_0025", ["id_gs01_0025"]);

dbArray[0][7] = new DbEntry("gs01/id_gs01_0043.htm#id_gs01_0043", "1.5 Camera Image Display Issues", "id_gs01_0043", ["id_gs01_0043"]);

dbArray[0][8] = new DbEntry("gs01/id_gs01_0028.htm#id_gs01_0028", "1.6 Operation Bar Issues", "id_gs01_0028", ["id_gs01_0028"]);

dbArray[0][9] = new DbEntry("gs01/id_gs01_0039.htm#id_gs01_0039", "1.7 Audio Issues", "id_gs01_0039", ["id_gs01_0039"]);

dbArray[0][10] = new DbEntry("gs01/id_gs01_0029.htm#id_gs01_0029", "1.8 Image Buffer/Transfer Issues", "id_gs01_0029", ["id_gs01_0029"]);

dbArray[0][11] = new DbEntry("gs01/id_gs01_0044.htm#id_gs01_0044", "1.9 SD Memory Card Issues", "id_gs01_0044", ["id_gs01_0044"]);

dbArray[0][12] = new DbEntry("gs01/id_gs01_0030.htm#id_gs01_0030", "1.10 Miscellaneous Issues", "id_gs01_0030", ["id_gs01_0030"]);

dbArray[0][13] = new DbEntry("gs01/id_gs01_0037.htm#id_gs01_0037", "1.11 Connection Type Table", "id_gs01_0037", ["id_gs01_0037"]);

dbArray[1] = [];

dbArray[1].manualTitle = "Operating Instructions";

dbArray[1][0] = new DbEntry("om01/id_om01_0203.htm#id_om01_0203", "Operating Instructions", "id_om01_0203", ["id_om01_0203"]);

dbArray[1][1] = new DbEntry("om01/id_om01_0118.htm#id_om01_0118", "Main Features", "id_om01_0118", ["id_om01_0118"]);

dbArray[1][2] = new DbEntry("om01/id_om01_0207.htm#id_om01_0207", "Other Information", "id_om01_0207", ["id_om01_0207"]);

dbArray[1][3] = new DbEntry("om01/id_om01_0123.htm#id_om01_0123", "1 Camera Monitoring", "id_om01_0123", ["id_om01_0123"]);

dbArray[1][4] = new DbEntry("om01/id_om01_0124.htm#id_om01_0124", "1.1 Accessing the Camera", "id_om01_0124", ["id_om01_0124"]);

dbArray[1][5] = new DbEntry("om01/id_om01_0125.htm#id_om01_0125", "1.2 Viewing Live Camera Images", "id_om01_0125", ["id_om01_0125"]);

dbArray[1][6] = new DbEntry("om01/id_om01_0130.htm#id_om01_0130", "1.2.1 Using the Operation Bar", "id_om01_0130", ["id_om01_0130"]);

dbArray[1][7] = new DbEntry("om01/id_om01_0282.htm#id_om01_0282", "1.2.2 Aiming the Camera Lens", "id_om01_0282", ["id_om01_0282"]);

dbArray[1][8] = new DbEntry("om01/id_om01_0361.htm#id_om01_0361", "1.2.3 Limiting the Pan/Tilt Range", "id_om01_0361", ["id_om01_0361"]);

dbArray[1][9] = new DbEntry("om01/id_om01_0470.htm#id_om01_0470", "1.2.4 Backlight Correction", "id_om01_0470", ["id_om01_0470"]);

dbArray[1][10] = new DbEntry("om01/id_om01_0371.htm#id_om01_0371", "1.2.5 White Balance", "id_om01_0371", ["id_om01_0371"]);

dbArray[1][11] = new DbEntry("om01/id_om01_0372.htm#id_om01_0372", "1.2.6 Video Images (MJPEG and MPEG-4) and Image Refresh Rate", "id_om01_0372", ["id_om01_0372"]);

dbArray[1][12] = new DbEntry("om01/id_om01_0236.htm#id_om01_0236", "1.2.7 Zooming", "id_om01_0236", ["id_om01_0236"]);

dbArray[1][13] = new DbEntry("om01/id_om01_0129.htm#id_om01_0129", "1.2.8 Taking Snapshots", "id_om01_0129", ["id_om01_0129"]);

dbArray[1][14] = new DbEntry("om01/id_om01_0826.htm#id_om01_0826", "1.2.9 Detection Notification Sound", "id_om01_0826", ["id_om01_0826"]);

dbArray[1][15] = new DbEntry("om01/id_om01_0132.htm#id_om01_0132", "1.2.10 Registering and Changing Presets", "id_om01_0132", ["id_om01_0132"]);

dbArray[1][16] = new DbEntry("om01/id_om01_0208.htm#id_om01_0208", "1.2.11 Audio Features", "id_om01_0208", ["id_om01_0208"]);

dbArray[1][17] = new DbEntry("om01/id_om01_0137.htm#id_om01_0137", "1.3 Viewing Multiple Camera Images", "id_om01_0137", ["id_om01_0137"]);

dbArray[1][18] = new DbEntry("om01/id_om01_0476.htm#id_om01_0476", "1.4 Maximum Number of Viewing Sessions", "id_om01_0476", ["id_om01_0476"]);

dbArray[1][19] = new DbEntry("om01/id_om01_0095.htm#id_om01_0095", "2 Using Triggers to Buffer and Transfer Images", "id_om01_0095", ["id_om01_0095"]);

dbArray[1][20] = new DbEntry("om01/id_om01_0131.htm#id_om01_0131", "2.1 Configuring a Timer Trigger", "id_om01_0131", ["id_om01_0131"]);

dbArray[1][21] = new DbEntry("om01/id_om01_0210.htm#id_om01_0210", "2.2 Configuring an Alarm or Motion Detection Trigger", "id_om01_0210", ["id_om01_0210"]);

dbArray[1][22] = new DbEntry("om01/id_om01_0242.htm#id_om01_0242", "2.3 Disabling and Enabling a Trigger", "id_om01_0242", ["id_om01_0242"]);

dbArray[1][23] = new DbEntry("om01/id_om01_0243.htm#id_om01_0243", "2.4 Configuring the Camera to Transfer Images", "id_om01_0243", ["id_om01_0243"]);

dbArray[1][24] = new DbEntry("om01/id_om01_0244.htm#id_om01_0244", "2.4.1 Transferring Images by FTP", "id_om01_0244", ["id_om01_0244"]);

dbArray[1][25] = new DbEntry("om01/id_om01_0245.htm#id_om01_0245", "2.4.2 Transferring Images by E-mail", "id_om01_0245", ["id_om01_0245"]);

dbArray[1][26] = new DbEntry("om01/id_om01_0246.htm#id_om01_0246", "2.4.3 Transferring Images by HTTP", "id_om01_0246", ["id_om01_0246"]);

dbArray[1][27] = new DbEntry("om01/id_om01_0247.htm#id_om01_0247", "2.5 Configuring the Camera to Send Trigger Notifications", "id_om01_0247", ["id_om01_0247"]);

dbArray[1][28] = new DbEntry("om01/id_om01_0248.htm#id_om01_0248", "2.5.1 Sending Trigger Notifications by E-mail", "id_om01_0248", ["id_om01_0248"]);

dbArray[1][29] = new DbEntry("om01/id_om01_0249.htm#id_om01_0249", "2.5.2 Sending Trigger Notifications by HTTP", "id_om01_0249", ["id_om01_0249"]);

dbArray[1][30] = new DbEntry("om01/id_om01_0141.htm#id_om01_0141", "2.6 Viewing Buffered Images", "id_om01_0141", ["id_om01_0141"]);

dbArray[1][31] = new DbEntry("om01/id_om01_0142.htm#id_om01_0142", "2.7 Deleting Buffered Images Manually", "id_om01_0142", ["id_om01_0142"]);

dbArray[1][32] = new DbEntry("om01/id_om01_0448.htm#id_om01_0448", "2.8 Understanding How the Camera Manages Buffered Images", "id_om01_0448", ["id_om01_0448"]);

dbArray[1][33] = new DbEntry("om01/id_om01_0250.htm#id_om01_0250", "2.9 Adjusting Motion Detection Sensitivity", "id_om01_0250", ["id_om01_0250"]);

dbArray[1][34] = new DbEntry("om01/id_om01_0220.htm#id_om01_0220", "2.10 Sending Alarm Log Information", "id_om01_0220", ["id_om01_0220"]);

dbArray[1][35] = new DbEntry("om01/id_om01_0468.htm#id_om01_0468", "2.11 Recording to an SD Memory Card Without Using a PC", "id_om01_0468", ["id_om01_0468"]);

dbArray[1][36] = new DbEntry("om01/id_om01_0252.htm#id_om01_0252", "3 Mobile Phone Features", "id_om01_0252", ["id_om01_0252"]);

dbArray[1][37] = new DbEntry("om01/id_om01_0253.htm#id_om01_0253", "3.1 Accessing the Camera from Your Mobile Phone", "id_om01_0253", ["id_om01_0253"]);

dbArray[1][38] = new DbEntry("om01/id_om01_0223.htm#id_om01_0223", "3.2 Viewing Still Images on Your Mobile Phone", "id_om01_0223", ["id_om01_0223"]);

dbArray[1][39] = new DbEntry("om01/id_om01_0224.htm#id_om01_0224", "3.3 Viewing Alarm Logs on Your Mobile Phone", "id_om01_0224", ["id_om01_0224"]);

dbArray[1][40] = new DbEntry("om01/id_om01_0225.htm#id_om01_0225", "3.4 Enabling and Disabling Image Buffering Using Your Mobile Phone", "id_om01_0225", ["id_om01_0225"]);

dbArray[1][41] = new DbEntry("om01/id_om01_0276.htm#id_om01_0276", "4 Configuring the Camera for Access from the Internet", "id_om01_0276", ["id_om01_0276"]);

dbArray[1][42] = new DbEntry("om01/id_om01_0331.htm#id_om01_0331", "4.1 Configuring Port Forwarding", "id_om01_0331", ["id_om01_0331"]);

dbArray[1][43] = new DbEntry("om01/id_om01_0326.htm#id_om01_0326", "4.2 Configuring the Camera to Use a Dynamic DNS Service", "id_om01_0326", ["id_om01_0326"]);

dbArray[1][44] = new DbEntry("om01/id_om01_0327.htm#id_om01_0327", "4.2.1 Configuring the Camera to Use Viewnetcam.com", "id_om01_0327", ["id_om01_0327"]);

dbArray[1][45] = new DbEntry("om01/id_om01_0339.htm#id_om01_0339", "4.2.2 Configuring the Camera to Use a Third-party Dynamic DNS Service", "id_om01_0339", ["id_om01_0339"]);

dbArray[1][46] = new DbEntry("om01/id_om01_0333.htm#id_om01_0333", "4.3 Confirming Internet Access", "id_om01_0333", ["id_om01_0333"]);

dbArray[1][47] = new DbEntry("om01/id_om01_0254.htm#id_om01_0254", "5 Changing Camera Settings", "id_om01_0254", ["id_om01_0254"]);

dbArray[1][48] = new DbEntry("om01/id_om01_0255.htm#id_om01_0255", "5.1 Network Settings", "id_om01_0255", ["id_om01_0255"]);

dbArray[1][49] = new DbEntry("om01/id_om01_0329.htm#id_om01_0329", "5.1.1 Network (IPv4) Settings", "id_om01_0329", ["id_om01_0329"]);

dbArray[1][50] = new DbEntry("om01/id_om01_0386.htm#id_om01_0386", "5.1.2 Proxy Server Settings", "id_om01_0386", ["id_om01_0386"]);

dbArray[1][51] = new DbEntry("om01/id_om01_0471.htm#id_om01_0471", "5.2 HTTPS Settings", "id_om01_0471", ["id_om01_0471"]);

dbArray[1][52] = new DbEntry("om01/id_om01_0355.htm#id_om01_0355", "5.3 UPnP™ Settings", "id_om01_0355", ["id_om01_0355"]);

dbArray[1][53] = new DbEntry("om01/id_om01_0102.htm#id_om01_0102", "5.4 Setting the Date and Time", "id_om01_0102", ["id_om01_0102"]);

dbArray[1][54] = new DbEntry("om01/id_om01_0103.htm#id_om01_0103", "5.5 Changing Basic Camera Settings", "id_om01_0103", ["id_om01_0103"]);

dbArray[1][55] = new DbEntry("om01/id_om01_0318.htm#id_om01_0318", "5.6 Changing Audio Settings", "id_om01_0318", ["id_om01_0318"]);

dbArray[1][56] = new DbEntry("om01/id_om01_0354.htm#id_om01_0354", "5.7 Changing Video Streaming Settings", "id_om01_0354", ["id_om01_0354"]);

dbArray[1][57] = new DbEntry("om01/id_om01_0299.htm#id_om01_0299", "6 User Accounts", "id_om01_0299", ["id_om01_0299"]);

dbArray[1][58] = new DbEntry("om01/id_om01_0290.htm#id_om01_0290", "6.1 Understanding User Accounts", "id_om01_0290", ["id_om01_0290"]);

dbArray[1][59] = new DbEntry("om01/id_om01_0106.htm#id_om01_0106", "6.2 Changing the Administrator User Name and Password", "id_om01_0106", ["id_om01_0106"]);

dbArray[1][60] = new DbEntry("om01/id_om01_0109.htm#id_om01_0109", "6.3 General Users", "id_om01_0109", ["id_om01_0109"]);

dbArray[1][61] = new DbEntry("om01/id_om01_0297.htm#id_om01_0297", "6.4 Guest Users", "id_om01_0297", ["id_om01_0297"]);

dbArray[1][62] = new DbEntry("om01/id_om01_0296.htm#id_om01_0296", "6.5 The Login Tab", "id_om01_0296", ["id_om01_0296"]);

dbArray[1][63] = new DbEntry("om01/id_om01_0268.htm#id_om01_0268", "7 Advanced Settings", "id_om01_0268", ["id_om01_0268"]);

dbArray[1][64] = new DbEntry("om01/id_om01_0110.htm#id_om01_0110", "7.1 Changing Image Display Settings", "id_om01_0110", ["id_om01_0110"]);

dbArray[1][65] = new DbEntry("om01/id_om01_0111.htm#id_om01_0111", "7.2 Registering Multiple Cameras", "id_om01_0111", ["id_om01_0111"]);

dbArray[1][66] = new DbEntry("om01/id_om01_0283.htm#id_om01_0283", "7.3 Specifying Operation Times", "id_om01_0283", ["id_om01_0283"]);

dbArray[1][67] = new DbEntry("om01/id_om01_0393.htm#id_om01_0393", "7.4 Controlling the External Output Terminal", "id_om01_0393", ["id_om01_0393"]);

dbArray[1][68] = new DbEntry("om01/id_om01_0396.htm#id_om01_0396", "7.5 Controlling the Analog Video Output Signal", "id_om01_0396", ["id_om01_0396"]);

dbArray[1][69] = new DbEntry("om01/id_om01_0116.htm#id_om01_0116", "7.6 Changing the Indicator Display", "id_om01_0116", ["id_om01_0116"]);

dbArray[1][70] = new DbEntry("om01/id_om01_0269.htm#id_om01_0269", "8 Using SD Memory Cards", "id_om01_0269", ["id_om01_0269"]);

dbArray[1][71] = new DbEntry("om01/id_om01_0277.htm#id_om01_0277", "8.1 Inserting and Removing an SD Card", "id_om01_0277", ["id_om01_0277"]);

dbArray[1][72] = new DbEntry("om01/id_om01_0278.htm#id_om01_0278", "8.2 Formatting an SD Memory Card", "id_om01_0278", ["id_om01_0278"]);

dbArray[1][73] = new DbEntry("om01/id_om01_0279.htm#id_om01_0279", "8.3 Starting and Stopping SD Memory Card Recording", "id_om01_0279", ["id_om01_0279"]);

dbArray[1][74] = new DbEntry("om01/id_om01_0270.htm#id_om01_0270", "9 Camera Administration and Maintenance", "id_om01_0270", ["id_om01_0270"]);

dbArray[1][75] = new DbEntry("om01/id_om01_0307.htm#id_om01_0307", "9.1 Confirming Camera Status", "id_om01_0307", ["id_om01_0307"]);

dbArray[1][76] = new DbEntry("om01/id_om01_0303.htm#id_om01_0303", "9.2 Confirming Session Status", "id_om01_0303", ["id_om01_0303"]);

dbArray[1][77] = new DbEntry("om01/id_om01_0304.htm#id_om01_0304", "9.3 Confirming Alarm Logs", "id_om01_0304", ["id_om01_0304"]);

dbArray[1][78] = new DbEntry("om01/id_om01_0160.htm#id_om01_0160", "9.4 Restarting the Camera", "id_om01_0160", ["id_om01_0160"]);

dbArray[1][79] = new DbEntry("om01/id_om01_0161.htm#id_om01_0161", "9.5 Updating the Camera’s Firmware", "id_om01_0161", ["id_om01_0161"]);

dbArray[1][80] = new DbEntry("om01/id_om01_0162.htm#id_om01_0162", "9.6 Saving Settings in a Configuration File", "id_om01_0162", ["id_om01_0162"]);

dbArray[1][81] = new DbEntry("om01/id_om01_0163.htm#id_om01_0163", "9.7 Restoring Settings from a Configuration File", "id_om01_0163", ["id_om01_0163"]);

dbArray[1][82] = new DbEntry("om01/id_om01_0164.htm#id_om01_0164", "9.8 Resetting the Camera", "id_om01_0164", ["id_om01_0164"]);

dbArray[1][83] = new DbEntry("om01/id_om01_0271.htm#id_om01_0271", "10 The [Support] Tab", "id_om01_0271", ["id_om01_0271"]);

dbArray[1][84] = new DbEntry("om01/id_om01_0272.htm#id_om01_0272", "11 Using IPv6", "id_om01_0272", ["id_om01_0272"]);

dbArray[1][85] = new DbEntry("om01/id_om01_0336.htm#id_om01_0336", "11.1 Configuring Your Router for IPv6", "id_om01_0336", ["id_om01_0336"]);

dbArray[1][86] = new DbEntry("om01/id_om01_0280.htm#id_om01_0280", "11.2 Configuring Your PC for IPv6", "id_om01_0280", ["id_om01_0280"]);

dbArray[1][87] = new DbEntry("om01/id_om01_0338.htm#id_om01_0338", "11.3 Configuring Your Camera for IPv6", "id_om01_0338", ["id_om01_0338"]);

dbArray[1][88] = new DbEntry("om01/id_om01_0342.htm#id_om01_0342", "11.4 Accessing the Camera in IPv6 Mode", "id_om01_0342", ["id_om01_0342"]);

dbArray[1][89] = new DbEntry("om01/id_om01_0422.htm#id_om01_0422", "11.5 Allowing IPv6 Access from the Internet", "id_om01_0422", ["id_om01_0422"]);

dbArray[1][90] = new DbEntry("om01/id_om01_0273.htm#id_om01_0273", "12 PC Settings", "id_om01_0273", ["id_om01_0273"]);

dbArray[1][91] = new DbEntry("om01/id_om01_0191.htm#id_om01_0191", "12.1 Proxy Server Settings", "id_om01_0191", ["id_om01_0191"]);

dbArray[1][92] = new DbEntry("om01/id_om01_0193.htm#id_om01_0193", "12.2 Creating a Shortcut to the Camera", "id_om01_0193", ["id_om01_0193"]);

dbArray[1][93] = new DbEntry("om01/id_om01_0194.htm#id_om01_0194", "12.3 Changing the [Temporary Internet files] Setting", "id_om01_0194", ["id_om01_0194"]);

dbArray[1][94] = new DbEntry("om01/id_om01_0389.htm#id_om01_0389", "12.4 About the MPEG-4 Viewer Program", "id_om01_0389", ["id_om01_0389"]);

dbArray[1][95] = new DbEntry("om01/id_om01_0274.htm#id_om01_0274", "13 Using the Setup Program", "id_om01_0274", ["id_om01_0274"]);

dbArray[1][96] = new DbEntry("om01/id_om01_0275.htm#id_om01_0275", "14 Technical Information", "id_om01_0275", ["id_om01_0275"]);

dbArray[1][97] = new DbEntry("om01/id_om01_0182.htm#id_om01_0182", "14.1 Cleaning the Camera", "id_om01_0182", ["id_om01_0182"]);

dbArray[1][98] = new DbEntry("om01/id_om01_0398.htm#id_om01_0398", "14.2 ASCII Character Table", "id_om01_0398", ["id_om01_0398"]);

dbArray[1][99] = new DbEntry("om01/id_om01_0399.htm#id_om01_0399", "14.3 Internal Memory Capacity for Buffered Images", "id_om01_0399", ["id_om01_0399"]);

dbArray[1][100] = new DbEntry("om01/id_om01_0404.htm#id_om01_0404", "14.4 SD Memory Card Capacity for Buffered Images", "id_om01_0404", ["id_om01_0404"]);

dbArray[1][101] = new DbEntry("om01/id_om01_0400.htm#id_om01_0400", "14.5 Default Setting List", "id_om01_0400", ["id_om01_0400"]);

dbArray[1][102] = new DbEntry("om01/id_om01_0197.htm#id_om01_0197", "14.6 Specifications", "id_om01_0197", ["id_om01_0197"]);

